/*
 * Decompiled with CFR 0.152.
 */
package com.wombatscorp.confluence.tokens.filters;

import com.atlassian.confluence.security.seraph.ConfluenceUserPrincipal;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import com.wombatscorp.confluence.tokens.filters.RemoveAuthHeaderRequestWrapper;
import com.wombatscorp.confluence.tokens.persistance.Token;
import com.wombatscorp.confluence.tokens.persistance.TokenDAO;
import com.wombatscorp.confluence.tokens.security.LicenseManager;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class TokenFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TokenFilter.class);
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final TokenDAO tokenDAO;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final String PLUGIN_STORAGE_KEY = "com.wombatscorp.confluence.tokens";
    private static final String ENABLE_PASS_AUTH_KEY = "com.wombatscorp.confluence.tokens.enablepasswordauth";
    private static boolean isPassAuthKeyEnabled = false;
    private final LicenseManager licenseManager;

    @Inject
    public TokenFilter(UserAccessor userAccessor, TokenDAO tokenDAO, PluginSettingsFactory pluginSettingsFactory, LicenseManager licenseManager) {
        this.userAccessor = userAccessor;
        this.tokenDAO = tokenDAO;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.licenseManager = licenseManager;
    }

    public void init(FilterConfig filterConfig) {
        log.debug("-------------< TokenFilter init >----------------");
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        if (pluginSettings.get(ENABLE_PASS_AUTH_KEY) != null) {
            isPassAuthKeyEnabled = Boolean.parseBoolean((String)pluginSettings.get(ENABLE_PASS_AUTH_KEY));
        }
    }

    public void destroy() {
        log.debug("-------------< TokenFilter destroy >----------------");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            if (httpServletRequest.getRemoteUser() == null) {
                String uri = httpServletRequest.getRequestURI();
                String username = httpServletRequest.getRemoteUser();
                String authHeader = httpServletRequest.getHeader("Authorization");
                if (StringUtils.isNotEmpty((String)authHeader) && "basic".equalsIgnoreCase(authHeader.split(" ")[0])) {
                    String decodedString = new String(Base64.getDecoder().decode(authHeader.split(" ")[1]));
                    username = decodedString.split(":")[0];
                    String token = decodedString.split(":")[1].trim();
                    ConfluenceUser user = this.userAccessor.getUserByName(username);
                    log.debug("User:{}", (Object)user);
                    Token t = this.tokenDAO.checkToken(username, token);
                    if (user == null) {
                        log.warn("Somebody try to login via non-existent user [{}]", (Object)username);
                    } else if (this.userAccessor.isDeactivated((User)user)) {
                        log.warn("Somebody try to login via inactive user [{}]", (Object)username);
                    } else if (t == null) {
                        if (isPassAuthKeyEnabled) {
                            log.warn("Authentication for [{}] possible only via token", (Object)user);
                            String userProfileURL = this.getUserProfileURL(httpServletRequest);
                            String errorMessage = "Your Administrator torn off basic Authentication via password. For now Authentication possible only via API Tokens. You can get API Tokens at your User Profile (" + userProfileURL + ")";
                            ((HttpServletResponse)response).sendError(401, errorMessage);
                            return;
                        }
                        log.debug("Invalid token for [{}]. It's ok because it might be a password.", (Object)user);
                    } else if (!this.licenseManager.isValid()) {
                        log.warn("User {} cannot use API Token. License for API Tokens plugin is not valid", (Object)user);
                    } else {
                        if (this.isTokenExpired(t)) {
                            log.warn("API Token for [{}] is Expired", (Object)user);
                            String userProfileURL = this.getUserProfileURL(httpServletRequest);
                            String errorMessage = "Your Token was Expired! You can get new API Tokens at your User Profile (" + userProfileURL + ")";
                            ((HttpServletResponse)response).sendError(401, errorMessage);
                            return;
                        }
                        this.tokenDAO.useToken(t);
                        ConfluenceUserPrincipal userPrincipal = new ConfluenceUserPrincipal(user);
                        HttpSession session = httpServletRequest.getSession(true);
                        session.setAttribute("samlNameID", (Object)username);
                        session.setAttribute("seraph_defaultauthenticator_user", (Object)userPrincipal);
                        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
                        log.info("{} has been authenticated via API Token ({}", (Object)user, (Object)t.getKey());
                        request = new RemoveAuthHeaderRequestWrapper(httpServletRequest);
                    }
                    if (log.isDebugEnabled()) {
                        String queryString = httpServletRequest.getQueryString();
                        String timeString = simpleDateFormat.format(new Date());
                        log.debug(String.format("StartTime '%s' RequestURI '%s' QueryString '%s' User '%s'", timeString, uri, queryString, username));
                    }
                }
            }
            chain.doFilter(request, response);
        }
    }

    private String getUserProfileURL(HttpServletRequest httpServletRequest) {
        StringBuffer requestURL = httpServletRequest.getRequestURL();
        String requestURI = httpServletRequest.getRequestURI();
        String contextPath = httpServletRequest.getContextPath();
        String baseURL = requestURL.substring(0, requestURL.length() - requestURI.length()) + contextPath;
        return baseURL + "/secure/ViewProfile.jspa";
    }

    public static void setIsPassAuthKeyEnabled(Boolean isPassAuthKeyEnabled) {
        TokenFilter.isPassAuthKeyEnabled = isPassAuthKeyEnabled;
    }

    public boolean isTokenExpired(Token token) {
        Date today = new Date();
        Date expirationDate = token.getExpirationDate();
        if (expirationDate != null) {
            long expirationCounter = expirationDate.getTime() - today.getTime();
            return expirationCounter < 0L;
        }
        return false;
    }
}

