/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.servlets;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.wittified.groupadmin.ao.DelegationService;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageGroupServlet
extends HttpServlet {
    private static final long serialVersionUID = -9019919668940135048L;
    private static final Logger logger = LoggerFactory.getLogger(ManageGroupServlet.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final DelegationService delegationService;
    private final PluginLicenseManager pluginLicenseManager;

    public ManageGroupServlet(TemplateRenderer templateRenderer, UserManager userManager, DelegationService delegationService, PluginLicenseManager pluginLicenseManager) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.delegationService = delegationService;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @HtmlSafe
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LogManager.getLogger("com.wittified").setLevel(Level.INFO);
        if (this.userManager.getRemoteUser() == null) {
            this.handleUnauthenticatedUser(req, resp);
            return;
        }
        String groupName = req.getParameter("groupname");
        logger.debug("User {} attempting to manage group {}", (Object)this.userManager.getRemoteUser(), (Object)groupName);
        if (!this.isUserAuthorizedForGroup(groupName)) {
            logger.info("User {} is not authorized to edit group {}", (Object)this.userManager.getRemoteUser(), (Object)groupName);
            resp.sendError(403);
            return;
        }
        this.renderManageGroupsPage(resp, groupName);
    }

    private void handleUnauthenticatedUser(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.info("User accessing the manage groups is not logged in to the application");
        String redirectUrl = this.getRedirectUrl(req);
        logger.debug("Redirecting unauthenticated user to login page with URL: {}", (Object)redirectUrl);
        resp.sendRedirect(redirectUrl);
    }

    private String getRedirectUrl(HttpServletRequest req) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        String contextPath = req.getContextPath();
        String queryString = req.getQueryString();
        String pluginKey = this.pluginLicenseManager.getPluginKey();
        String baseUrl = scheme + "://" + serverName + (String)(serverPort != 80 && serverPort != 443 ? ":" + serverPort : "") + contextPath;
        String redirectUrl = String.valueOf(req.getRequestURL()) + (String)(queryString != null ? "?" + queryString : "");
        String encodedRedirectUrl = URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8);
        String loginUrl = pluginKey.equals("com.wittified.delegated-group-management-in-jira") ? "/login.jsp?os_destination=" : "/login.action?os_destination=";
        return baseUrl + loginUrl + encodedRedirectUrl;
    }

    private boolean isUserAuthorizedForGroup(String groupName) {
        List<String> groupNames = this.delegationService.getGroupDelegation(this.userManager.getRemoteUserKey().getStringValue());
        boolean isAuthorized = groupNames.contains(groupName);
        logger.debug("User {} authorization status for group {}: {}", new Object[]{this.userManager.getRemoteUser(), groupName, isAuthorized});
        return isAuthorized;
    }

    private void renderManageGroupsPage(HttpServletResponse resp, String groupName) throws IOException {
        HashMap<String, CallSite> context = new HashMap<String, CallSite>();
        context.put("groupName", (CallSite)((Object)("\"" + groupName + "\"")));
        logger.debug("Rendering manage groups page for group {}", (Object)groupName);
        this.templateRenderer.render("/templates/manageGroups.vm", context, (Writer)resp.getWriter());
    }
}

