/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.services;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import com.wittified.groupadmin.ao.DelegationService;
import com.wittified.groupadmin.product.DelegatedUser;
import com.wittified.groupadmin.product.ProductService;
import com.wittified.groupadmin.rest.MyGroupEntity;
import com.wittified.groupadmin.rest.PagerEntity;
import com.wittified.groupadmin.services.DelegatedGroupCommonService;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedGroupCommonServiceImpl
implements DelegatedGroupCommonService {
    private final Cache<String, List<User>> userCache;
    private final CacheManager cacheManager;
    private final ProductService productService;
    private final CrowdService crowdService;
    private final UserManager userManager;
    private final CrowdDirectoryService crowdDirectoryService;
    private final DelegationService delegationService;
    private static final Logger logger = LoggerFactory.getLogger(DelegatedGroupCommonServiceImpl.class);

    public DelegatedGroupCommonServiceImpl(CacheManager cacheManager, ProductService productService, CrowdService crowdService, UserManager userManager, CrowdDirectoryService crowdDirectoryService, DelegationService delegationService) {
        this.cacheManager = cacheManager;
        this.productService = productService;
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.crowdDirectoryService = crowdDirectoryService;
        this.userCache = cacheManager.getCache(DelegatedGroupCommonServiceImpl.class.getName() + ".cache", (CacheLoader)new ListUserCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());
        this.delegationService = delegationService;
    }

    @Override
    public int getPagePosition(Integer startPage, Integer page, Integer endPage) {
        int sum = 0;
        int middleNo = 0;
        for (int i = startPage.intValue(); i <= endPage; ++i) {
            sum += i;
        }
        middleNo = sum / 5;
        if (page == middleNo) {
            return 0;
        }
        if (page > middleNo && page == endPage) {
            return 2;
        }
        if (page > middleNo && page < endPage) {
            return 1;
        }
        if (page < middleNo && page == startPage) {
            return -2;
        }
        if (page < middleNo && page > startPage) {
            return -1;
        }
        return 0;
    }

    @Override
    public PagerEntity positionThePager(int startPage, int page, int endPage, int totalItems, int pageSize) {
        int totalPages = (int)Math.ceil((float)totalItems / (float)pageSize);
        PagerEntity pager = new PagerEntity();
        pager.setTotalSize(totalItems);
        pager.setPage(page);
        if (endPage == -1) {
            endPage = totalPages >= 5 ? 5 : totalPages;
            pager.setStartPage(1);
            pager.setEndPage(endPage);
            return pager;
        }
        int position = this.getPagePosition(startPage, page, endPage);
        if (position == 0 || page == 1 || page == totalPages) {
            pager.setStartPage(startPage);
            pager.setEndPage(endPage);
        } else if (position == -1) {
            if (page - 1 == 1) {
                pager.setStartPage(startPage);
                pager.setEndPage(endPage);
            } else {
                pager.setStartPage(startPage - 1);
                pager.setEndPage(endPage - 1);
            }
        } else if (position == -2) {
            if (page - 1 == 1) {
                pager.setStartPage(startPage - 1);
                pager.setEndPage(endPage - 1);
            } else {
                pager.setStartPage(startPage - 2);
                pager.setEndPage(endPage - 2);
            }
        } else if (position == 1) {
            if (page + 1 == totalPages) {
                pager.setStartPage(startPage);
                pager.setEndPage(endPage);
            } else {
                pager.setStartPage(startPage + 1);
                pager.setEndPage(endPage + 1);
            }
        } else if (position == 2) {
            if (page + 1 == totalPages) {
                pager.setStartPage(startPage + 1);
                pager.setEndPage(endPage + 1);
            } else {
                pager.setStartPage(startPage + 2);
                pager.setEndPage(endPage + 2);
            }
        } else {
            pager.setStartPage(startPage);
            pager.setEndPage(endPage);
        }
        return pager;
    }

    @Override
    public List<DelegatedUser> filterUsersInGroup(String groupName, String searchTerm) {
        List users = (List)this.userCache.get((Object)groupName);
        return users.stream().filter(user -> user != null && (user.getName().toLowerCase().contains(searchTerm.toLowerCase()) || user.getDisplayName().toLowerCase().contains(searchTerm.toLowerCase()) || user.getEmailAddress().toLowerCase().contains(searchTerm.toLowerCase()))).map(user -> this.convert((User)user, groupName)).collect(Collectors.toList());
    }

    @Override
    public Cache<String, List<User>> getUserCache() {
        return this.userCache;
    }

    List<User> renderUserList(String groupName) {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
        Iterable result = this.crowdService.search((Query)query);
        return Lists.newArrayList(result);
    }

    @Override
    public List<DelegatedUser> getUsersInGroup(String group, int page) {
        ArrayList<DelegatedUser> delegatedUsers = new ArrayList<DelegatedUser>();
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(group).startingAt((page - 1) * 20).returningAtMost(20);
        Iterable result = this.crowdService.search((Query)query);
        result.forEach(user -> delegatedUsers.add(this.convert((User)user, group)));
        return delegatedUsers;
    }

    @Override
    public List<DelegatedUser> getAllUsersInGroup(String group, int userCount) {
        ArrayList<DelegatedUser> delegatedUsers = new ArrayList<DelegatedUser>();
        if (group == null || group.trim().isEmpty()) {
            return delegatedUsers;
        }
        try {
            MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(group.trim()).returningAtMost(userCount);
            Iterable result = this.crowdService.search((Query)query);
            if (result != null) {
                for (User user : result) {
                    if (user == null) continue;
                    DelegatedUser delegatedUser = this.convert(user, group);
                    delegatedUsers.add(delegatedUser);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving users for group '" + group + "': " + e.getMessage());
            throw e;
        }
        return delegatedUsers;
    }

    @Override
    public CSVPrinter exportCSV(OutputStreamWriter osw, List<User> delegatedUsers) throws IOException {
        CSVFormat csvFileFormat = CSVFormat.DEFAULT.withDelimiter(',').withRecordSeparator("\n");
        CSVPrinter csvFilePrinter = new CSVPrinter(osw, csvFileFormat);
        try {
            csvFilePrinter.printRecord("Username", "Name", "Email");
            for (User user : delegatedUsers) {
                csvFilePrinter.printRecord(user.getName(), user.getDisplayName(), user.getEmailAddress());
            }
            return csvFilePrinter;
        }
        catch (IOException e) {
            logger.error("Error while exporting CSV: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    @Override
    public Map<String, Object> getPaginatedUsers(String requestedUserKey, String filterText, boolean paginate, Integer startPage, Integer endPage, Integer page) {
        List<String> groupNames = this.delegationService.getGroupDelegation(requestedUserKey);
        List<String> filteredGroupNames = this.filterGroupNames(groupNames, filterText);
        HashMap<String, Object> paginatedGroups = new HashMap<String, Object>();
        int totalGroups = filteredGroupNames.size();
        if (paginate) {
            this.adjustPagination(totalGroups, startPage, endPage, page);
            filteredGroupNames = this.paginateGroups(filteredGroupNames, page);
            paginatedGroups.put("pageEntity", this.positionThePager(startPage, page, endPage, totalGroups, 20));
        }
        String appName = this.productService.getApplicationType().toLowerCase();
        Map<String, Object> groupNamesWithUserCount = this.buildGroupInfo(requestedUserKey, filteredGroupNames, appName);
        paginatedGroups.put("delegatedGroups", filteredGroupNames);
        paginatedGroups.put("groupsInfo", groupNamesWithUserCount);
        paginatedGroups.put("appName", appName);
        paginatedGroups.put("total", totalGroups);
        paginatedGroups.put("viewPreference", "default");
        return paginatedGroups;
    }

    private List<String> filterGroupNames(List<String> groupNames, String filterText) {
        String string = filterText = filterText == null || filterText.equals("undefined") ? "" : filterText;
        if (StringUtils.isEmpty(filterText)) {
            return groupNames;
        }
        ArrayList<String> filteredGroupNames = new ArrayList<String>();
        for (String grp : groupNames) {
            if (!grp.contains(filterText)) continue;
            filteredGroupNames.add(grp);
        }
        return filteredGroupNames;
    }

    private void adjustPagination(int totalGroups, Integer startPage, Integer endPage, Integer page) {
        int totalPages = (int)Math.ceil((double)totalGroups / 20.0);
        if (totalPages < endPage) {
            if (page == endPage) {
                page = totalPages;
            }
            if ((endPage = Integer.valueOf(totalPages)) == (startPage = Integer.valueOf(Math.max(endPage - 4, 1)))) {
                endPage = -1;
            }
        } else if (endPage < startPage + 4) {
            int reqEndPage = startPage + 4;
            endPage = Math.min(reqEndPage, totalPages);
        }
        if (totalGroups == 0) {
            endPage = -1;
            page = 1;
        }
    }

    private List<String> paginateGroups(List<String> filteredGroupNames, Integer page) {
        int startIndex = (page - 1) * 20;
        int endIndex = Math.min(startIndex + 20, filteredGroupNames.size());
        return filteredGroupNames.subList(startIndex, endIndex);
    }

    private Map<String, Object> buildGroupInfo(String requestedUserKey, List<String> filteredGroupNames, String appName) {
        LinkedHashMap<String, Object> groupNamesWithUserCount = new LinkedHashMap<String, Object>();
        for (String groupName : filteredGroupNames) {
            List<String> favUsersList = this.delegationService.getFavoriteGroupUsers(groupName);
            boolean isFavorite = favUsersList.contains(requestedUserKey);
            MyGroupEntity myGroupEntity = new MyGroupEntity();
            myGroupEntity.setGroupName(groupName);
            myGroupEntity.setUserCount(this.productService.getUsersCountInGroup(groupName));
            myGroupEntity.setIsFavorite(isFavorite);
            myGroupEntity.setAppName(appName);
            groupNamesWithUserCount.put(groupName, myGroupEntity);
        }
        return groupNamesWithUserCount;
    }

    private DelegatedUser convert(User user, String groupName) {
        String key = null;
        UserProfile userProfile = this.userManager.getUserProfile(user.getName());
        if (userProfile != null) {
            key = userProfile.getUserKey().getStringValue();
        }
        DelegatedUser delegatedUser = null;
        if (this.productService.getApplicationType().equals("JIRA")) {
            String avatarUrl = this.productService.getAvatarUrl(key);
            boolean isFromNestedGroup = this.productService.isFromNestedGroup(key, groupName);
            delegatedUser = new DelegatedUser(key, user.getDisplayName(), user.getName(), user.getEmailAddress(), true, this.isUserReadOnly(user.getDirectoryId()), avatarUrl, isFromNestedGroup, true);
        } else {
            delegatedUser = new DelegatedUser(key, user.getDisplayName(), user.getName(), user.getEmailAddress(), true, this.isUserReadOnly(user.getDirectoryId()));
            delegatedUser.setUserAvatar(this.productService.getAvatarUrl(user.getName()));
        }
        delegatedUser.setActive(user.isActive());
        return delegatedUser;
    }

    private boolean isUserReadOnly(long directoryId) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        if (directory != null) {
            return !directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
        }
        return false;
    }

    private class ListUserCacheLoader
    implements CacheLoader<String, List<User>> {
        private ListUserCacheLoader() {
        }

        public List<User> load(@Nonnull String groupName) {
            return DelegatedGroupCommonServiceImpl.this.renderUserList(groupName);
        }
    }
}

