/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.general.servlet;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GettingStartedServlet
extends HttpServlet {
    @ComponentImport
    private final WebInterfaceManager webInterfaceManager;
    @ComponentImport
    private final TemplateRenderer templateRenderer;
    @ComponentImport
    private final RequestFactory requestFactory;
    private String pluginKey = "";
    private String pluginVersion = "";
    private String baseUrl = "";

    @Inject
    public GettingStartedServlet(WebInterfaceManager webInterfaceManager, TemplateRenderer templateRenderer, RequestFactory requestFactory) {
        this.webInterfaceManager = webInterfaceManager;
        this.templateRenderer = templateRenderer;
        this.requestFactory = requestFactory;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.pluginKey = config.getInitParameter("pluginKey");
        this.pluginVersion = config.getInitParameter("version");
        this.baseUrl = config.getInitParameter("baseUrl");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("contentPanelHtml", this.fetchPanelHtml("wittified.gettingStarted.contet"));
        context.put("leftPanelHtml", this.fetchPanelHtml("wittified.gettingStarted.left"));
        context.put("rightPanelHtml", this.fetchPanelHtml("wittified.gettingStarted.right"));
        context.put("topPanelHtml", this.fetchPanelHtml("wittified.gettingStarted.top"));
        context.put("bottomPanelHtml", this.fetchPanelHtml("wittified.gettingStarted.bottom"));
        this.templateRenderer.render("/communicator/templates/getting-started.vm", context, (Writer)resp.getWriter());
    }

    private String fetchPanelHtml(String location) {
        StringBuffer html = new StringBuffer();
        if (this.pluginVersion != null && this.baseUrl != null) {
            Request request = this.requestFactory.createRequest(Request.MethodType.GET, this.baseUrl + this.pluginKey + this.pluginVersion);
            request.setSoTimeout(1000);
            request.setConnectionTimeout(1000);
            try {
                String content = request.execute();
                if (content != null && !content.isEmpty()) {
                    return content;
                }
            }
            catch (ResponseException responseException) {
                responseException.printStackTrace();
            }
        }
        for (WebPanel webPanel : this.webInterfaceManager.getWebPanels(location + "." + this.pluginKey)) {
            html.append(webPanel.getHtml(new HashMap()));
        }
        return html.toString();
    }
}

