/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import io.keen.client.java.KeenAttemptCountingEventStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RamEventStore
implements KeenAttemptCountingEventStore {
    private long nextId = 0L;
    private Map<String, List<Long>> collectionIds = new HashMap<String, List<Long>>();
    private Map<Long, String> events = new HashMap<Long, String>();
    private int maxEventsPerCollection = 10000;
    private Map<String, Map<String, String>> attempts;

    @Override
    public synchronized Object store(String projectId, String eventCollection, String event) throws IOException {
        String key = String.format(Locale.US, "%s$%s", projectId, eventCollection);
        List<Long> collectionEvents = this.collectionIds.get(key);
        if (collectionEvents == null) {
            collectionEvents = new ArrayList<Long>();
            this.collectionIds.put(key, collectionEvents);
        }
        while (collectionEvents.size() >= this.maxEventsPerCollection) {
            long idToRemove = collectionEvents.remove(0);
            this.events.remove(idToRemove);
        }
        long id = this.getNextId();
        this.events.put(id, event);
        collectionEvents.add(id);
        return id;
    }

    @Override
    public synchronized String get(Object handle) throws IOException {
        Long id = this.handleToId(handle);
        return this.events.get(id);
    }

    @Override
    public synchronized void remove(Object handle) throws IOException {
        Long id = this.handleToId(handle);
        this.events.remove(id);
    }

    @Override
    public synchronized Map<String, List<Object>> getHandles(String projectId) throws IOException {
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        for (Map.Entry<String, List<Long>> entry : this.collectionIds.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(projectId)) continue;
            String eventCollection = key.substring(projectId.length() + 1);
            List<Long> ids = entry.getValue();
            ArrayList<Long> handles = new ArrayList<Long>();
            Iterator<Long> iterator = ids.iterator();
            while (iterator.hasNext()) {
                Long id = iterator.next();
                if (this.events.get(id) == null) {
                    iterator.remove();
                    continue;
                }
                handles.add(id);
            }
            if (handles.size() <= 0) continue;
            result.put(eventCollection, handles);
        }
        return result;
    }

    @Override
    public String getAttempts(String projectId, String eventCollection) {
        if (this.attempts == null) {
            return null;
        }
        Map<String, String> project = this.attempts.get(projectId);
        if (project == null) {
            return null;
        }
        return project.get(eventCollection);
    }

    @Override
    public void setAttempts(String projectId, String eventCollection, String attemptsString) {
        Map<String, String> project;
        if (this.attempts == null) {
            this.attempts = new HashMap<String, Map<String, String>>();
        }
        if ((project = this.attempts.get(projectId)) == null) {
            project = new HashMap<String, String>();
            this.attempts.put(projectId, project);
        }
        project.put(eventCollection, attemptsString);
    }

    public void setMaxEventsPerCollection(int maxEventsPerCollection) {
        this.maxEventsPerCollection = maxEventsPerCollection;
    }

    void clear() {
        this.nextId = 0L;
        this.collectionIds = new HashMap<String, List<Long>>();
        this.events = new HashMap<Long, String>();
    }

    private long getNextId() {
        if ((long)this.events.size() > Long.MAX_VALUE) {
            throw new IllegalStateException("Event store exceeded maximum size");
        }
        long id = this.nextId;
        while (this.events.get(id) != null) {
            ++id;
        }
        this.nextId = id + 1L;
        return id;
    }

    private Long handleToId(Object handle) {
        if (handle instanceof Long) {
            return (Long)handle;
        }
        throw new IllegalArgumentException("Expected handle to be a Long, but was: " + handle.getClass().getCanonicalName());
    }
}

