/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.rest;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.wittified.groupadmin.ao.DelegationGroup;
import com.wittified.groupadmin.ao.DelegationService;
import com.wittified.groupadmin.ao.GroupOwner;
import com.wittified.groupadmin.ao.UserOwner;
import com.wittified.groupadmin.product.DelegatedUser;
import com.wittified.groupadmin.product.DelegatedUserDTO;
import com.wittified.groupadmin.product.ProductService;
import com.wittified.groupadmin.rest.MyGroupEntity;
import com.wittified.groupadmin.services.DelegatedGroupCommonService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/delegation")
public class DelegationEndPoints {
    private final DelegationService delegationService;
    private final ProductService productService;
    private final UserManager userManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final DelegatedGroupCommonService delegatedGroupPaginationService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final Logger logger = LoggerFactory.getLogger(DelegationEndPoints.class);

    @Inject
    public DelegationEndPoints(DelegationService delegationService, UserManager userManager, ProductService productService, PluginLicenseManager pluginLicenseManager, DelegatedGroupCommonService delegatedGroupPaginationService, PluginSettingsFactory pluginSettingsFactory) {
        this.delegationService = delegationService;
        this.userManager = userManager;
        this.productService = productService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.delegatedGroupPaginationService = delegatedGroupPaginationService;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Path(value="/my-groups")
    @GET
    @Produces(value={"application/json"})
    public Response listMyGroups(@QueryParam(value="filterText") String filterText, @QueryParam(value="paginate") boolean paginate, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="page") Integer page, @QueryParam(value="endPage") Integer endPage, @QueryParam(value="pageSize") Integer pageSize) {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        String loggedInUserKey = this.userManager.getRemoteUserKey().getStringValue();
        Map<String, Object> paginatedGroups = this.delegatedGroupPaginationService.getPaginatedUsers(loggedInUserKey, filterText, paginate, startPage, endPage, page);
        return Response.ok(paginatedGroups).build();
    }

    private String getDefaultViewPreference() {
        return this.delegationService.getPreferredViewForUser(this.userManager.getRemoteUserKey().getStringValue());
    }

    @Path(value="/my-preferred-view")
    @GET
    @Produces(value={"text/plain"})
    public Response getUserPreferenceView() {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        return Response.ok((Object)this.getDefaultViewPreference()).build();
    }

    @Path(value="/my-favorite-groups")
    @GET
    @Produces(value={"application/json"})
    public Response listMyFavoriteGroups(@QueryParam(value="filterText") String filterText, @QueryParam(value="paginate") boolean paginate, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="page") Integer page, @QueryParam(value="endPage") Integer endPage, @QueryParam(value="pageSize") Integer pageSize) {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        LinkedHashMap<String, MyGroupEntity> favGroupNamesWithUserCount = new LinkedHashMap<String, MyGroupEntity>();
        List<String> groupNames = this.delegationService.getGroupDelegation(this.userManager.getRemoteUserKey().getStringValue());
        String loggedInUserKey = this.userManager.getRemoteUserKey().getStringValue();
        List<Object> filteredGroupNames = new ArrayList();
        String string = filterText = filterText.equals("undefined") ? "" : filterText;
        if (StringUtils.isNotEmpty(filterText)) {
            for (String string2 : groupNames) {
                if (!string2.contains(filterText)) continue;
                filteredGroupNames.add(string2);
            }
        } else {
            filteredGroupNames = groupNames;
        }
        String appName = this.productService.getApplicationType().toLowerCase();
        for (String string3 : filteredGroupNames) {
            List<String> favUsersList = this.delegationService.getFavoriteGroupUsers(string3);
            boolean isFavorite = false;
            if (!favUsersList.contains(loggedInUserKey)) continue;
            isFavorite = true;
            MyGroupEntity myGroupEntity = new MyGroupEntity();
            myGroupEntity.setGroupName(string3);
            myGroupEntity.setUserCount(this.productService.getUsersCountInGroup(string3));
            myGroupEntity.setIsFavorite(isFavorite);
            myGroupEntity.setAppName(appName);
            favGroupNamesWithUserCount.put(string3, myGroupEntity);
        }
        WeakHashMap<String, Object> weakHashMap = new WeakHashMap<String, Object>();
        int n = favGroupNamesWithUserCount.size();
        if (paginate) {
            int totalPage = (int)Math.ceil((double)n / 20.0);
            if (totalPage < endPage) {
                if (page == endPage) {
                    page = totalPage;
                }
                if ((startPage = Integer.valueOf((endPage = Integer.valueOf(totalPage)) - 4)) < 1) {
                    startPage = 1;
                }
                if (endPage == startPage) {
                    endPage = -1;
                }
            } else if (endPage < startPage + 4) {
                int reqEndPage = startPage + 4;
                endPage = reqEndPage <= totalPage ? reqEndPage : totalPage;
            }
            if (favGroupNamesWithUserCount.isEmpty()) {
                endPage = -1;
                page = 1;
            }
            filteredGroupNames = n >= (page - 1) * 20 + 20 ? filteredGroupNames.subList((page - 1) * 20, (page - 1) * 20 + 20) : filteredGroupNames.subList((page - 1) * 20, n);
            weakHashMap.put("delegatedGroups", filteredGroupNames);
            weakHashMap.put("pageEntity", this.delegatedGroupPaginationService.positionThePager(startPage, page, endPage, n, 20));
        } else {
            weakHashMap.put("delegatedGroups", filteredGroupNames);
        }
        weakHashMap.put("groupsInfo", favGroupNamesWithUserCount);
        weakHashMap.put("appName", appName);
        weakHashMap.put("total", n);
        weakHashMap.put("viewPreference", "favorite");
        return Response.ok(weakHashMap).build();
    }

    @Path(value="/my-recent-groups")
    @GET
    @Produces(value={"application/json"})
    public Response listMyRecentGroups(@QueryParam(value="filterText") String filterText, @QueryParam(value="paginate") boolean paginate, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="page") Integer page, @QueryParam(value="endPage") Integer endPage, @QueryParam(value="pageSize") Integer pageSize) {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        LinkedHashMap<String, MyGroupEntity> groupNamesWithUserCount = new LinkedHashMap<String, MyGroupEntity>();
        List<String> groupNames = this.delegationService.getGroupDelegation(this.userManager.getRemoteUserKey().getStringValue());
        List<Object> filteredGroupNames = new ArrayList();
        String string = filterText = filterText.equals("undefined") ? "" : filterText;
        if (StringUtils.isNotEmpty(filterText)) {
            for (String grp : groupNames) {
                if (!grp.contains(filterText)) continue;
                filteredGroupNames.add(grp);
            }
        } else {
            filteredGroupNames = groupNames;
        }
        WeakHashMap<String, Object> paginatedGroups = new WeakHashMap<String, Object>();
        int totalGroups = filteredGroupNames.size();
        if (paginate) {
            int totalPage = (int)Math.ceil((double)totalGroups / 20.0);
            if (totalPage < endPage) {
                if (page == endPage) {
                    page = totalPage;
                }
                if ((startPage = Integer.valueOf((endPage = Integer.valueOf(totalPage)) - 4)) < 1) {
                    startPage = 1;
                }
                if (endPage == startPage) {
                    endPage = -1;
                }
            } else if (endPage < startPage + 4) {
                int reqEndPage = startPage + 4;
                endPage = reqEndPage <= totalPage ? reqEndPage : totalPage;
            }
            if (filteredGroupNames.isEmpty()) {
                endPage = -1;
                page = 1;
            }
            filteredGroupNames = totalGroups >= (page - 1) * 20 + 20 ? filteredGroupNames.subList((page - 1) * 20, (page - 1) * 20 + 20) : filteredGroupNames.subList((page - 1) * 20, totalGroups);
            paginatedGroups.put("delegatedGroups", filteredGroupNames);
            paginatedGroups.put("pageEntity", this.delegatedGroupPaginationService.positionThePager(startPage, page, endPage, totalGroups, 20));
        } else {
            paginatedGroups.put("delegatedGroups", filteredGroupNames);
        }
        List<DelegationGroup> delGroupObjs = this.delegationService.getDelegationGroupObjs(filteredGroupNames);
        Collections.sort(delGroupObjs, new SortDelGroupsbyID());
        String loggedInUserKey = this.userManager.getRemoteUserKey().getStringValue();
        int counter = 0;
        String appName = this.productService.getApplicationType().toLowerCase();
        for (DelegationGroup delGroup : delGroupObjs) {
            ++counter;
            String groupName = delGroup.getGroupName();
            List<String> favUsersList = this.delegationService.getFavoriteGroupUsers(groupName);
            boolean isFavorite = false;
            if (favUsersList.contains(loggedInUserKey)) {
                isFavorite = true;
            }
            MyGroupEntity myGroupEntity = new MyGroupEntity();
            myGroupEntity.setGroupName(groupName);
            myGroupEntity.setUserCount(this.productService.getUsersCountInGroup(groupName));
            myGroupEntity.setIsFavorite(isFavorite);
            myGroupEntity.setAppName(appName);
            if (counter < 3) {
                myGroupEntity.setIsNew(true);
            }
            groupNamesWithUserCount.put(groupName, myGroupEntity);
        }
        paginatedGroups.put("groupsInfo", groupNamesWithUserCount);
        paginatedGroups.put("appName", appName);
        paginatedGroups.put("total", totalGroups);
        paginatedGroups.put("viewPreference", "recent");
        return Response.ok(paginatedGroups).build();
    }

    @Path(value="/my-group")
    @GET
    @Produces(value={"application/json"})
    public Response listContentsOfMyGroup(@QueryParam(value="group") String group, @QueryParam(value="paginate") boolean paginate, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="page") Integer page, @QueryParam(value="endPage") Integer endPage, @QueryParam(value="searchTerm") String searchTerm) throws Exception {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        group = URLDecoder.decode(group, "UTF-8");
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        List<Object> delegatedUsers = Lists.newArrayList();
        int totalUsers = 0;
        if (!StringUtils.isBlank(searchTerm)) {
            delegatedUsers = this.delegatedGroupPaginationService.filterUsersInGroup(group, searchTerm);
            totalUsers = delegatedUsers.size();
        } else {
            totalUsers = this.productService.getUsersCountInGroup(group);
        }
        WeakHashMap<String, Object> paginatedUsers = new WeakHashMap<String, Object>();
        if (paginate) {
            int totalPage = (int)Math.ceil((double)totalUsers / 20.0);
            if (totalPage < endPage) {
                if (page == endPage) {
                    page = totalPage;
                }
                if ((startPage = Integer.valueOf((endPage = Integer.valueOf(totalPage)) - 4)) < 1) {
                    startPage = 1;
                }
                if (endPage == startPage) {
                    endPage = -1;
                }
            } else if (endPage < startPage + 4) {
                int reqEndPage = startPage + 4;
                endPage = reqEndPage <= totalPage ? reqEndPage : totalPage;
            }
            if (totalUsers == 0) {
                endPage = -1;
                page = 1;
            }
            if (!StringUtils.isBlank(searchTerm)) {
                List<Object> filtered = Lists.newArrayList();
                filtered = totalUsers >= (page - 1) * 20 + 20 ? delegatedUsers.subList((page - 1) * 20, (page - 1) * 20 + 20) : delegatedUsers.subList((page - 1) * 20, totalUsers);
                paginatedUsers.put("delegatedUsers", filtered);
            } else {
                delegatedUsers = this.delegatedGroupPaginationService.getUsersInGroup(group, page);
                paginatedUsers.put("delegatedUsers", delegatedUsers);
            }
            paginatedUsers.put("pageEntity", this.delegatedGroupPaginationService.positionThePager(startPage, page, endPage, totalUsers, 20));
        } else {
            paginatedUsers.put("delegatedUsers", delegatedUsers);
        }
        return Response.ok(paginatedUsers).build();
    }

    @Path(value="/my-group")
    @DELETE
    @Produces(value={"application/json"})
    public Response removeGroup(Map<String, String> data) {
        String group = data.get("group");
        String userKey = data.get("user");
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        if (this.userManager.getRemoteUserKey().getStringValue().equals(userKey)) {
            return Response.ok().build();
        }
        try {
            this.productService.removeUserFromGroup(group, this.userManager.getRemoteUserKey().getStringValue(), userKey);
            this.delegatedGroupPaginationService.getUserCache().remove((Object)group);
        }
        catch (Exception e) {
            logger.error("Error when removing user from group: [" + group + "] Error:" + e.getMessage());
        }
        return Response.ok().build();
    }

    @Path(value="/user/bulk-remove")
    @DELETE
    @Produces(value={"application/json"})
    public Response bulkRemoveGroup(Map<String, String> data) {
        Gson converter = new Gson();
        String group = data.get("group");
        List rawList = converter.fromJson(data.get("users"), List.class);
        List userKeyList = rawList.stream().map(String::valueOf).collect(Collectors.toList());
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        for (String userKey : userKeyList) {
            try {
                this.productService.removeUserFromGroup(group, this.userManager.getRemoteUserKey().getStringValue(), userKey);
                this.delegatedGroupPaginationService.getUserCache().remove((Object)group);
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)e.getMessage()).build();
            }
        }
        return Response.ok().build();
    }

    @Path(value="/setOrUnsetFavoriteGroup")
    @POST
    @Produces(value={"application/json"})
    public Response setOrUnsetFavoriteGroup(Map<String, String> data) {
        String userKey = this.userManager.getRemoteUserKey().getStringValue();
        if (userKey == null) {
            return Response.status((int)403).build();
        }
        String group = data.get("group");
        String setOrUnset = data.get("setOrUnset");
        if (StringUtils.isNotEmpty(setOrUnset) && setOrUnset.equalsIgnoreCase("set")) {
            this.delegationService.addFavoriteUserGroup(group, userKey);
        } else if (StringUtils.isNotEmpty(setOrUnset) && setOrUnset.equalsIgnoreCase("unset")) {
            this.delegationService.removeFavoriteUserGroup(group, userKey);
        }
        return Response.ok().build();
    }

    @Path(value="/configured-whitelist-groups")
    @GET
    @Produces(value={"application/json"})
    public Response getWhiteListGroups() {
        String whiteListGroupsFromDelegation = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whiteListGroups");
        if (whiteListGroupsFromDelegation == null || whiteListGroupsFromDelegation.trim().isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        List resultList = Arrays.stream(whiteListGroupsFromDelegation.split(",")).map(group -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", group.trim());
            map.put("text", group.trim());
            return map;
        }).collect(Collectors.toList());
        return Response.ok(resultList).build();
    }

    @Path(value="/my-group/bulk")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addBulkUsersToGroup(Map<String, String> data) {
        if (data == null || data.isEmpty()) {
            return this.buildErrorResponse(Response.Status.BAD_REQUEST, "Request body is missing.");
        }
        String group = this.safeTrim(data.get("group"));
        String usersList = this.safeTrim(data.get("user"));
        if (group == null || usersList == null) {
            return this.buildErrorResponse(Response.Status.BAD_REQUEST, "Missing or empty 'group' or 'user' parameters.");
        }
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.isInValid()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        Set<String> allowedUserKeys = this.getAllowedUserKeysFromWhitelistedGroups();
        ArrayList<String> unknownUsersList = new ArrayList<String>();
        int validUserProfileCounter = 0;
        try {
            String[] userKeys;
            for (String rawUserKey : userKeys = usersList.split(",")) {
                String userKey = this.safeTrim(rawUserKey);
                if (userKey == null) continue;
                UserProfile userProfile = this.userManager.getUserProfile(userKey);
                if (userProfile != null && userProfile.getUserKey() != null) {
                    if (allowedUserKeys.isEmpty() || allowedUserKeys.contains(userKey)) {
                        this.productService.addUserToGroup(group, this.userManager.getRemoteUserKey().getStringValue(), userProfile.getUserKey().getStringValue());
                        ++validUserProfileCounter;
                        continue;
                    }
                    unknownUsersList.add(userKey);
                    continue;
                }
                unknownUsersList.add(userKey);
            }
            this.delegatedGroupPaginationService.getUserCache().remove((Object)group);
        }
        catch (Exception e) {
            return this.buildErrorResponse(Response.Status.BAD_REQUEST, "Error adding users to group: " + e.getMessage());
        }
        return this.buildSuccessResponse(validUserProfileCounter, unknownUsersList);
    }

    @Path(value="/my-group")
    @POST
    @Produces(value={"application/json"})
    public Response addGroup(Map<String, String> data) {
        String group = data.get("group");
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        String userKey = data.get("user");
        try {
            UserProfile userProfile;
            if (userKey != null && group != null && this.userManager.getRemoteUserKey() != null && (userProfile = this.userManager.getUserProfile(userKey)) != null && userProfile.getUserKey() != null && this.userManager.getRemoteUserKey() != null) {
                this.productService.addUserToGroup(group, this.userManager.getRemoteUserKey().getStringValue(), userProfile.getUserKey().getStringValue());
                this.delegatedGroupPaginationService.getUserCache().remove((Object)group);
            }
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @Path(value="/find-user")
    @GET
    @Produces(value={"application/json"})
    public Response findUser(@QueryParam(value="user") String user, @QueryParam(value="group") String group) {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        return Response.ok((Object)this.filterUsers(group, this.productService.finderUsers(user, null))).build();
    }

    @Path(value="/setAsPreferredView")
    @POST
    @Produces(value={"application/json"})
    public Response setAsPreferredForUser(Map<String, String> data) {
        String userKey = this.userManager.getRemoteUserKey().getStringValue();
        if (userKey == null) {
            return Response.status((int)403).build();
        }
        String setView = data.get("setView");
        if (StringUtils.isNotEmpty(setView)) {
            this.delegationService.setAsPreferredViewForUser(setView, userKey);
        }
        return Response.ok().build();
    }

    private DelegatedUserDTO filterUsers(String group, List<DelegatedUser> finderUsers) {
        boolean flag = false;
        DelegatedUserDTO delegatedUserDTO = new DelegatedUserDTO();
        ArrayList<String> usernamesInDelegatedGroup = new ArrayList<String>();
        for (DelegatedUser userInDelegatedGroup : this.productService.getUsersInGroup(group)) {
            usernamesInDelegatedGroup.add(userInDelegatedGroup.getName());
        }
        List<DelegatedUser> finderUsersWhiteListed = this.getWhiteListedUsers(finderUsers);
        finderUsers = finderUsersWhiteListed;
        Iterator<DelegatedUser> finderUsersIter = finderUsers.iterator();
        while (finderUsersIter.hasNext()) {
            DelegatedUser delegatedUser = finderUsersIter.next();
            if (!usernamesInDelegatedGroup.contains(delegatedUser.getName())) continue;
            flag = true;
            finderUsersIter.remove();
        }
        delegatedUserDTO.setDelegatedUsers(finderUsers);
        if (flag && finderUsers.isEmpty()) {
            delegatedUserDTO.setIsUserExists(true);
        }
        return delegatedUserDTO;
    }

    private List<DelegatedUser> getWhiteListedUsers(List<DelegatedUser> finderUsers) {
        String whiteListedDomains = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whiteListedDomains");
        String includeOrExclude = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whitelist.whitelistRadio");
        if (StringUtils.isNotBlank(whiteListedDomains) && StringUtils.isNotBlank(includeOrExclude)) {
            whiteListedDomains = whiteListedDomains.replaceAll("\\s", "");
            String[] domainArr = whiteListedDomains.split(",");
            Iterator<DelegatedUser> finderUsersIterator = finderUsers.iterator();
            while (finderUsersIterator.hasNext()) {
                DelegatedUser delegatedUser = finderUsersIterator.next();
                String email = delegatedUser.getEmail();
                String emailDomain = "";
                if (StringUtils.isNotBlank(email) && email.contains("@")) {
                    emailDomain = email.substring(email.indexOf("@") + 1);
                }
                if ((!includeOrExclude.equalsIgnoreCase("exclude") || !Arrays.asList(domainArr).contains(emailDomain)) && (!includeOrExclude.equalsIgnoreCase("include") || Arrays.asList(domainArr).contains(emailDomain))) continue;
                finderUsersIterator.remove();
            }
        }
        return finderUsers;
    }

    private boolean isInValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            if (((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid()) {
                return false;
            }
            logger.error("Delegated groups license is invalid: " + ((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).toString());
            return true;
        }
        logger.error("Delegated groups license is not licensed");
        return true;
    }

    @Path(value="/getAll")
    @GET
    @Produces(value={"application/json"})
    public Response listAllDelegatedGroups() throws Exception {
        if (this.userManager.getRemoteUserKey() == null || this.userManager.getRemoteUserKey() != null && !this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        List<String> allDelegatedGroups = this.delegationService.getAllDelegatedGroupNames();
        JSONArray delegatedGroupsJson = new JSONArray();
        for (String delegatedGroup : allDelegatedGroups) {
            delegatedGroupsJson.put(new JSONObject(this.getDelegatedGroupAsStr(delegatedGroup)));
        }
        return Response.ok((Object)delegatedGroupsJson.toString().replace("\\", "")).build();
    }

    @Path(value="/getGroup/{group}")
    @GET
    @Produces(value={"application/json"})
    public Response getGroup(@PathParam(value="group") String groupName) {
        Response validationResponse = this.validateRequest();
        if (validationResponse != null) {
            return validationResponse;
        }
        return Response.ok((Object)this.getDelegatedGroupAsStr(groupName)).build();
    }

    @Path(value="/groups")
    @GET
    @Produces(value={"application/json"})
    public Response getGroupByQuery(@QueryParam(value="group") String groupName) {
        Response validationResponse = this.validateRequest();
        if (validationResponse != null) {
            return validationResponse;
        }
        if (groupName == null || groupName.trim().isEmpty()) {
            logger.warn("Group name is null or empty.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\": \"Missing required query parameter: group\"}").build();
        }
        String groupResult = this.getDelegatedGroupAsStr(groupName = URLDecoder.decode(groupName, StandardCharsets.UTF_8));
        if (groupResult == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)groupResult).build();
    }

    private Response validateRequest() {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.isInValid()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return null;
    }

    private String getDelegatedGroupAsStr(String groupName) {
        StringBuilder userOwners = new StringBuilder();
        StringBuilder groupOwners = new StringBuilder();
        for (DelegationGroup delegation : this.delegationService.getDelegatedGroup(groupName)) {
            for (GroupOwner groupOwner : delegation.getGroupOwners()) {
                groupOwners.append(groupOwner.getOwnerName() + ",");
            }
            for (UserOwner userOwner : delegation.getUserOwners()) {
                UserProfile userProfile = this.userManager.getUserProfile(new UserKey(userOwner.getOwnerKey()));
                if (userProfile != null) {
                    userOwners.append(userProfile.getUsername() + ",");
                    continue;
                }
                userOwners.append(userOwner.getOwnerKey() + ",");
            }
        }
        JSONObject delegatedGroupJson = new JSONObject();
        try {
            delegatedGroupJson.put("group", groupName);
            delegatedGroupJson.put("groupOwners", StringUtils.removeEnd(groupOwners.toString(), ","));
            delegatedGroupJson.put("userOwners", StringUtils.removeEnd(userOwners.toString(), ","));
        }
        catch (JSONException e) {
            logger.error("Error when constructing the JSON Object:" + e.getMessage());
        }
        logger.debug(delegatedGroupJson.toString());
        return delegatedGroupJson.toString();
    }

    @Path(value="/export-csv")
    @Produces(value={"application/octet-stream"})
    @GET
    public Response exportGroupUsersAsCSV(@QueryParam(value="group") String groupName, @Context HttpServletResponse response) throws IOException {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.isInValid()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        List users = (List)this.delegatedGroupPaginationService.getUserCache().get((Object)groupName);
        if (users == null || users.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        String remoteUserName = Optional.ofNullable(this.userManager.getRemoteUser()).map(UserProfile::getUsername).orElse(null);
        boolean userNotFound = users.stream().filter(Objects::nonNull).map(Principal::getName).filter(Objects::nonNull).noneMatch(name -> name.equals(remoteUserName));
        if (userNotFound) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)gzipOutputStream, StandardCharsets.UTF_8);){
            response.setContentType("text/csv; charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + groupName.concat("-users") + System.currentTimeMillis() + ".csv");
            response.setHeader("Content-Encoding", "gzip");
            CSVPrinter csvFilePrinter = this.delegatedGroupPaginationService.exportCSV(osw, users);
            if (csvFilePrinter != null) {
                csvFilePrinter.flush();
            }
        }
        catch (IOException e) {
            logger.error("users-export : Exception while export", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error exporting users").build();
        }
        return Response.ok().build();
    }

    @Path(value="/users/{username}/delegated-groups")
    @GET
    @Produces(value={"application/json"})
    public Response getAllDelegatedGroupsForUser(@QueryParam(value="filter") String filter, @QueryParam(value="paginate") boolean paginate, @QueryParam(value="start_page") Integer startPage, @QueryParam(value="page") Integer page, @QueryParam(value="end_page") Integer endPage, @PathParam(value="username") String userName) {
        Response validationResponse = this.validateRequestData(userName);
        if (validationResponse != null) {
            return validationResponse;
        }
        UserProfile userProfile = this.userManager.getUserProfile(userName);
        if (userProfile == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"User profile not found or invalid username").build();
        }
        String requestedUserKey = String.valueOf(userProfile.getUserKey());
        Map<String, Object> paginatedGroups = this.delegatedGroupPaginationService.getPaginatedUsers(requestedUserKey, filter, paginate, startPage, endPage, page);
        return Response.ok(paginatedGroups).build();
    }

    private Response validateRequestData(String userName) {
        if (userName == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User profile is not valid").build();
        }
        if (this.isInValid()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Invalid license").build();
        }
        if (!this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User profile has no permission for viewing the groups").build();
        }
        return null;
    }

    private String safeTrim(String value) {
        return value == null || value.trim().isEmpty() ? null : value.trim();
    }

    private Response buildErrorResponse(Response.Status status, String message) {
        ObjectNode errorNode = new ObjectMapper().createObjectNode();
        errorNode.put("error", message);
        return Response.status((Response.Status)status).type("application/json").entity((Object)errorNode.toString()).build();
    }

    private Response buildSuccessResponse(int usersAdded, List<String> unknownUsersList) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode responseNode = mapper.createObjectNode();
        responseNode.put("status", "success");
        responseNode.put("usersAdded", usersAdded);
        if (!unknownUsersList.isEmpty() || usersAdded == 0) {
            ArrayNode failedArray = mapper.createArrayNode();
            for (String user : unknownUsersList) {
                failedArray.add(user);
            }
            responseNode.set("unknownUsers/usersNotInWhitelistedGroups", failedArray);
        }
        return Response.ok((Object)responseNode.toString(), (String)"application/json").build();
    }

    private Set<String> getAllowedUserKeysFromWhitelistedGroups() {
        String[] groups;
        HashSet<String> allowedUserKeys = new HashSet<String>();
        Object rawSetting = this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whiteListGroups");
        if (!(rawSetting instanceof String)) {
            return allowedUserKeys;
        }
        String whiteListGroups = ((String)rawSetting).trim();
        if (whiteListGroups.isEmpty()) {
            return allowedUserKeys;
        }
        for (String group : groups = whiteListGroups.split(",")) {
            String trimmedGroup = this.safeTrim(group);
            if (trimmedGroup == null) continue;
            try {
                int totalUsers = this.productService.getUsersCountInGroup(trimmedGroup);
                List<DelegatedUser> users = this.delegatedGroupPaginationService.getAllUsersInGroup(trimmedGroup, totalUsers);
                for (DelegatedUser user : users) {
                    if (user == null || user.getName() == null) continue;
                    allowedUserKeys.add(user.getName());
                }
            }
            catch (Exception e) {
                logger.error("Error in getting users from group : Exception while retrieval", (Throwable)e);
            }
        }
        return allowedUserKeys;
    }

    class SortDelGroupsbyID
    implements Comparator<DelegationGroup> {
        SortDelGroupsbyID() {
        }

        @Override
        public int compare(DelegationGroup group1, DelegationGroup group2) {
            return group2.getID() - group1.getID();
        }
    }
}

