/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.reload4j;

import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.slf4j.Marker;
import org.slf4j.event.DefaultLoggingEvent;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.AbstractLogger;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.helpers.NormalizedParameters;
import org.slf4j.spi.DefaultLoggingEventBuilder;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventAware;

public final class Reload4jLoggerAdapter
extends LegacyAbstractLogger
implements LocationAwareLogger,
LoggingEventAware,
Serializable {
    private static final long serialVersionUID = 6989384227325275811L;
    final transient Logger logger;
    static final String FQCN_NOMINAL;
    static final String FQCN_SUBSTITUE;
    static final String FQCN_FLUENT;

    Reload4jLoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor(Level.ERROR);
    }

    public void log(Marker marker, String callerFQCN, int level, String msg, Object[] arguments, Throwable t2) {
        Level log4jLevel = this.toLog4jLevel(level);
        NormalizedParameters np = NormalizedParameters.normalize((String)msg, (Object[])arguments, (Throwable)t2);
        String formattedMessage = MessageFormatter.basicArrayFormat((String)np.getMessage(), (Object[])np.getArguments());
        this.logger.log(callerFQCN, log4jLevel, formattedMessage, np.getThrowable());
    }

    protected void handleNormalizedLoggingCall(org.slf4j.event.Level level, Marker marker, String msg, Object[] arguments, Throwable throwable) {
        Level log4jLevel = this.toLog4jLevel(level.toInt());
        String formattedMessage = MessageFormatter.basicArrayFormat((String)msg, (Object[])arguments);
        this.logger.log(this.getFullyQualifiedCallerName(), log4jLevel, formattedMessage, throwable);
    }

    public void log(org.slf4j.event.LoggingEvent event) {
        Level log4jLevel = this.toLog4jLevel(event.getLevel().toInt());
        if (!this.logger.isEnabledFor(log4jLevel)) {
            return;
        }
        LoggingEvent log4jevent = this.event2Log4jEvent(event, log4jLevel);
        this.logger.callAppenders(log4jevent);
    }

    private LoggingEvent event2Log4jEvent(org.slf4j.event.LoggingEvent event, Level log4jLevel) {
        String formattedMessage = MessageFormatter.basicArrayFormat((String)event.getMessage(), (Object[])event.getArgumentArray());
        LocationInfo locationInfo = null;
        String fqcn = null;
        if (event instanceof SubstituteLoggingEvent) {
            locationInfo = new LocationInfo("NA/SubstituteLogger", "NA/SubstituteLogger", "NA/SubstituteLogger", "0");
            fqcn = FQCN_SUBSTITUE;
        } else {
            fqcn = FQCN_FLUENT;
        }
        ThrowableInformation ti = null;
        Throwable t2 = event.getThrowable();
        if (t2 != null) {
            ti = new ThrowableInformation(t2);
        }
        if (event instanceof DefaultLoggingEvent) {
            DefaultLoggingEvent defaultLoggingEvent = (DefaultLoggingEvent)event;
            defaultLoggingEvent.setTimeStamp(System.currentTimeMillis());
        }
        LoggingEvent log4jEvent = new LoggingEvent(fqcn, this.logger, event.getTimeStamp(), log4jLevel, formattedMessage, event.getThreadName(), ti, null, locationInfo, null);
        return log4jEvent;
    }

    private Level toLog4jLevel(int slf4jLevelInt) {
        Level log4jLevel;
        switch (slf4jLevelInt) {
            case 0: {
                log4jLevel = Level.TRACE;
                break;
            }
            case 10: {
                log4jLevel = Level.DEBUG;
                break;
            }
            case 20: {
                log4jLevel = Level.INFO;
                break;
            }
            case 30: {
                log4jLevel = Level.WARN;
                break;
            }
            case 40: {
                log4jLevel = Level.ERROR;
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + slf4jLevelInt + " is not recognized.");
            }
        }
        return log4jLevel;
    }

    protected String getFullyQualifiedCallerName() {
        return FQCN_NOMINAL;
    }

    static {
        FQCN_SUBSTITUE = FQCN_NOMINAL = AbstractLogger.class.getName();
        FQCN_FLUENT = DefaultLoggingEventBuilder.class.getName();
    }
}

