/*
 * Decompiled with CFR 0.152.
 */
package com.appfire.common.analytics.core;

import com.appfire.common.analytics.bean.EventDetails;
import com.appfire.common.analytics.bean.GlobalEventData;
import com.appfire.common.analytics.core.AnalyticsClientCallback;
import com.appfire.common.analytics.core.AnalyticsService;
import com.appfire.common.analytics.util.AnalyticsUtil;
import com.appfire.common.analytics.util.AppfireKeenClientBuilder;
import io.keen.client.java.KeenClient;
import io.keen.client.java.KeenProject;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsServiceImpl
implements AnalyticsService {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsServiceImpl.class);
    private final String projectKey;
    private final String writeKey;
    private final GlobalEventData globalData;

    public AnalyticsServiceImpl(String projectKey, String writeKey, GlobalEventData globalData) {
        this.projectKey = projectKey;
        this.writeKey = writeKey;
        this.globalData = globalData;
    }

    @Override
    public void addEvent(EventDetails eventDetails) {
        this.postEvent(eventDetails);
    }

    @Override
    public void addEvent(String eventType, Map<String, Object> eventData) {
        this.postEvent(eventType, eventData);
    }

    @Override
    public void addEvents(Collection<EventDetails> eventDetailsList) {
        this.postEvents(eventDetailsList);
    }

    private void postEvent(EventDetails eventDetails) {
        if (eventDetails != null && StringUtils.isNotBlank(eventDetails.getCollectionName())) {
            this.postEvent(eventDetails.getCollectionName(), eventDetails.getEventData());
        }
    }

    private void postEvent(String eventType, Map<String, Object> eventData) {
        try {
            Map<String, Object> eventDataMap = AnalyticsUtil.buildEventDataMap(eventData);
            KeenClient keenClient = this.getKeenClient();
            AnalyticsClientCallback callback = new AnalyticsClientCallback(eventDataMap, (ExecutorService)keenClient.getPublishExecutor());
            log.debug("Posting analytics with collection name : " + eventType);
            keenClient.addEventAsync(null, eventType, eventDataMap, null, callback);
        }
        catch (Exception e) {
            log.warn("Error posting analytics data. ", (Throwable)e);
        }
    }

    private void postEvents(Collection<EventDetails> eventDetailsList) {
        if (eventDetailsList != null && eventDetailsList.size() > 0) {
            log.debug("Events count:" + eventDetailsList.size());
            try {
                eventDetailsList.forEach(eventDetails -> {
                    KeenClient keenClient = this.getKeenClient();
                    Map<String, Object> eventDataMap = AnalyticsUtil.buildEventDataMap(eventDetails);
                    AnalyticsClientCallback callback = new AnalyticsClientCallback(eventDataMap, (ExecutorService)keenClient.getPublishExecutor());
                    log.debug("Posting analytics with collection name : " + eventDetails.getCollectionName());
                    keenClient.addEventAsync(null, eventDetails.getCollectionName(), eventDataMap, null, callback);
                });
            }
            catch (Exception e) {
                log.warn("Error posting analytics data", (Throwable)e);
            }
        }
    }

    public KeenClient getKeenClient() {
        KeenClient keenClient = null;
        try {
            keenClient = new AppfireKeenClientBuilder().build();
            KeenClient.initialize(keenClient);
            KeenProject keenProject = new KeenProject(this.projectKey, this.writeKey, null);
            keenClient.setDefaultProject(keenProject);
            keenClient.setGlobalProperties(AnalyticsUtil.buildGlobalProps(this.globalData));
            log.debug("Initialized Keen client.");
        }
        catch (Throwable e) {
            log.debug("Error while initializing Keen client", e);
        }
        return keenClient;
    }
}

