/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.servlets;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.wittified.groupadmin.product.ProductService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class GettingStartedServlet
extends HttpServlet {
    private static final long serialVersionUID = 3775888253622251060L;
    private final TemplateRenderer templateRenderer;
    private final ProductService productService;
    private final UserManager userManager;

    public GettingStartedServlet(UserManager userManager, ProductService productService, TemplateRenderer templateRenderer) {
        this.userManager = userManager;
        this.productService = productService;
        this.templateRenderer = templateRenderer;
    }

    @HtmlSafe
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.userManager.getRemoteUser() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            resp.sendError(404);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("applicationType", StringUtils.capitalize(this.productService.getApplicationType().toLowerCase()));
        context.put("marketplaceAppId", this.productService.getMarketplaceAppId());
        context.put("contextPath", req.getContextPath());
        this.templateRenderer.render("/templates/getStarted.vm", context, (Writer)resp.getWriter());
    }
}

