/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.listeners;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.event.PluginLicenseAddedEvent;
import com.atlassian.upm.api.license.event.PluginLicenseUpdatedEvent;
import com.wittified.groupadmin.analytics.DelGroupsAnalytics;
import com.wittified.groupadmin.analytics.EventType;
import com.wittified.groupadmin.ao.DelegationGroup;
import com.wittified.groupadmin.ao.DelegationService;
import com.wittified.groupadmin.product.ProductService;
import java.util.List;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DelGroupsListener
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final DelGroupsAnalytics delgroupsAnalytics;
    private final PluginLicenseEventRegistry pluginLicenseEventRegistry;
    private final DelegationService delegationService;
    private final ProductService productService;
    private static final Logger logger = LoggerFactory.getLogger(DelGroupsListener.class);

    public DelGroupsListener(EventPublisher eventPublisher, DelGroupsAnalytics delgroupsAnalytics, PluginLicenseEventRegistry pluginLicenseEventRegistry, DelegationService delegationService, ProductService productService) {
        this.eventPublisher = eventPublisher;
        this.delgroupsAnalytics = delgroupsAnalytics;
        this.pluginLicenseEventRegistry = pluginLicenseEventRegistry;
        this.pluginLicenseEventRegistry.register((Object)this);
        this.delegationService = delegationService;
        this.productService = productService;
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        if ("com.wittified.delegated-group-management-in-confluence".equals(plugin.getKey()) || "com.wittified.delegated-group-management-in-jira".equals(plugin.getKey())) {
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            WeakHashMap<String, Integer> configMap = new WeakHashMap<String, Integer>();
            eventDataMap.put("type", EventType.INSTALL.toString());
            List<DelegationGroup> groups = this.delegationService.getAllDelegatedGroupObjs();
            configMap.put("totalNoOfDelegatedGroups", groups != null ? groups.size() : 0);
            configMap.put("maxNoOfOwnerGroups", this.delegationService.getMaxOwnerGroups());
            configMap.put("maxNoOfOwnerUsers", this.delegationService.getMaxOwnerUsers());
            configMap.put("noOfZeroOwnerGroups", this.delegationService.getNoOfZeroOwnerGroups());
            configMap.put("maxNoOfOwnersForAGroup", groups != null ? this.delgroupsAnalytics.getMaxNoOfOwners(groups) : 0);
            eventDataMap.put("configList", configMap);
            this.delgroupsAnalytics.postEventInfo(EventType.INSTALL, eventDataMap);
        }
    }

    @EventListener
    public void onPluginLicenseAddedEvent(PluginLicenseAddedEvent pluginLicenseAddedEvent) {
        try {
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            WeakHashMap<String, Integer> configMap = new WeakHashMap<String, Integer>();
            eventDataMap.put("type", EventType.LICENSE_ADDED.toString());
            List<DelegationGroup> groups = this.delegationService.getAllDelegatedGroupObjs();
            configMap.put("totalNoOfDelegatedGroups", groups != null ? groups.size() : 0);
            configMap.put("maxNoOfOwnerGroups", this.delegationService.getMaxOwnerGroups());
            configMap.put("maxNoOfOwnerUsers", this.delegationService.getMaxOwnerUsers());
            configMap.put("noOfZeroOwnerGroups", this.delegationService.getNoOfZeroOwnerGroups());
            configMap.put("maxNoOfOwnersForAGroup", groups != null ? this.delgroupsAnalytics.getMaxNoOfOwners(groups) : 0);
            eventDataMap.put("configList", configMap);
            this.delgroupsAnalytics.postEventInfo(EventType.LICENSE_ADDED, eventDataMap);
            this.productService.sendEmail("Welcome to Delegated Group Management app", "Welcome to Delegated Group Management app");
        }
        catch (Exception e) {
            logger.debug("Error while posting analytics data: ", (Throwable)e);
        }
    }

    @EventListener
    public void onPluginLicenseUpdatedEvent(PluginLicenseUpdatedEvent pluginLicenseUpdatedEvent) {
        try {
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            WeakHashMap<String, Integer> configMap = new WeakHashMap<String, Integer>();
            eventDataMap.put("type", EventType.LICENSE_UPDATED.toString());
            List<DelegationGroup> groups = this.delegationService.getAllDelegatedGroupObjs();
            configMap.put("totalNoOfDelegatedGroups", groups != null ? groups.size() : 0);
            configMap.put("maxNoOfOwnerGroups", this.delegationService.getMaxOwnerGroups());
            configMap.put("maxNoOfOwnerUsers", this.delegationService.getMaxOwnerUsers());
            configMap.put("noOfZeroOwnerGroups", this.delegationService.getNoOfZeroOwnerGroups());
            configMap.put("maxNoOfOwnersForAGroup", groups != null ? this.delgroupsAnalytics.getMaxNoOfOwners(groups) : 0);
            eventDataMap.put("configList", configMap);
            this.delgroupsAnalytics.postEventInfo(EventType.LICENSE_UPDATED, eventDataMap);
        }
        catch (Exception e) {
            logger.debug("Error while posting analytics data: ", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        this.delgroupsAnalytics.postEventInfo(EventType.UNINSTALL);
        this.eventPublisher.unregister((Object)this);
        this.pluginLicenseEventRegistry.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

