/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.rest;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.wittified.groupadmin.ao.DelegationGroup;
import com.wittified.groupadmin.ao.DelegationService;
import com.wittified.groupadmin.ao.GroupOwner;
import com.wittified.groupadmin.ao.UserOwner;
import com.wittified.groupadmin.product.DelegatedUser;
import com.wittified.groupadmin.product.DelegatedUserDTO;
import com.wittified.groupadmin.product.ProductService;
import com.wittified.groupadmin.rest.MyGroupEntity;
import com.wittified.groupadmin.services.DelegatedGroupCommonService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/delegation")
public class DelegationEndPoints {
    private final DelegationService delegationService;
    private final ProductService productService;
    private final UserManager userManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final DelegatedGroupCommonService delegatedGroupPaginationService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final Logger logger = LoggerFactory.getLogger(DelegationEndPoints.class);

    public DelegationEndPoints(DelegationService delegationService, UserManager userManager, ProductService productService, PluginLicenseManager pluginLicenseManager, DelegatedGroupCommonService delegatedGroupPaginationService, PluginSettingsFactory pluginSettingsFactory) {
        this.delegationService = delegationService;
        this.userManager = userManager;
        this.productService = productService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.delegatedGroupPaginationService = delegatedGroupPaginationService;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Path(value="/my-groups")
    @GET
    @Produces(value={"application/json"})
    public Response listMyGroups(@QueryParam(value="filterText") String filterText, @QueryParam(value="paginate") boolean paginate, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="page") Integer page, @QueryParam(value="endPage") Integer endPage, @QueryParam(value="pageSize") Integer pageSize) {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        LinkedHashMap<String, MyGroupEntity> groupNamesWithUserCount = new LinkedHashMap<String, MyGroupEntity>();
        String loggedInUserKey = this.userManager.getRemoteUserKey().getStringValue();
        List<String> groupNames = this.delegationService.getGroupDelegation(loggedInUserKey);
        List<Object> filteredGroupNames = new ArrayList();
        String string = filterText = filterText == null || filterText.equals("undefined") ? "" : filterText;
        if (StringUtils.isNotEmpty(filterText)) {
            for (String grp : groupNames) {
                if (!grp.contains(filterText)) continue;
                filteredGroupNames.add(grp);
            }
        } else {
            filteredGroupNames = groupNames;
        }
        WeakHashMap<String, Object> paginatedGroups = new WeakHashMap<String, Object>();
        int totalGroups = filteredGroupNames.size();
        if (paginate) {
            int totalPage = (int)Math.ceil((double)totalGroups / 20.0);
            if (totalPage < endPage) {
                if (page == endPage) {
                    page = totalPage;
                }
                if ((startPage = Integer.valueOf((endPage = Integer.valueOf(totalPage)) - 4)) < 1) {
                    startPage = 1;
                }
                if (endPage == startPage) {
                    endPage = -1;
                }
            } else if (endPage < startPage + 4) {
                int reqEndPage = startPage + 4;
                endPage = reqEndPage <= totalPage ? reqEndPage : totalPage;
            }
            if (filteredGroupNames.isEmpty()) {
                endPage = -1;
                page = 1;
            }
            filteredGroupNames = totalGroups >= (page - 1) * 20 + 20 ? filteredGroupNames.subList((page - 1) * 20, (page - 1) * 20 + 20) : filteredGroupNames.subList((page - 1) * 20, totalGroups);
            paginatedGroups.put("delegatedGroups", filteredGroupNames);
            paginatedGroups.put("pageEntity", this.delegatedGroupPaginationService.positionThePager(startPage, page, endPage, totalGroups, 20));
        } else {
            paginatedGroups.put("delegatedGroups", filteredGroupNames);
        }
        String appName = this.productService.getApplicationType().toLowerCase();
        for (String string2 : filteredGroupNames) {
            List<String> favUsersList = this.delegationService.getFavoriteGroupUsers(string2);
            boolean isFavorite = false;
            if (favUsersList.contains(loggedInUserKey)) {
                isFavorite = true;
            }
            MyGroupEntity myGroupEntity = new MyGroupEntity();
            myGroupEntity.setGroupName(string2);
            myGroupEntity.setUserCount(this.productService.getUsersCountInGroup(string2));
            myGroupEntity.setIsFavorite(isFavorite);
            myGroupEntity.setAppName(appName);
            groupNamesWithUserCount.put(string2, myGroupEntity);
        }
        paginatedGroups.put("groupsInfo", groupNamesWithUserCount);
        paginatedGroups.put("appName", appName);
        paginatedGroups.put("total", totalGroups);
        paginatedGroups.put("viewPreference", "default");
        return Response.ok(paginatedGroups).build();
    }

    private String getDefaultViewPreference() {
        return this.delegationService.getPreferredViewForUser(this.userManager.getRemoteUserKey().getStringValue());
    }

    @Path(value="/my-preferred-view")
    @GET
    @Produces(value={"text/plain"})
    public Response getUserPreferenceView() {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        return Response.ok((Object)this.getDefaultViewPreference()).build();
    }

    @Path(value="/my-favorite-groups")
    @GET
    @Produces(value={"application/json"})
    public Response listMyFavoriteGroups(@QueryParam(value="filterText") String filterText, @QueryParam(value="paginate") boolean paginate, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="page") Integer page, @QueryParam(value="endPage") Integer endPage, @QueryParam(value="pageSize") Integer pageSize) {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        LinkedHashMap<String, MyGroupEntity> favGroupNamesWithUserCount = new LinkedHashMap<String, MyGroupEntity>();
        List<String> groupNames = this.delegationService.getGroupDelegation(this.userManager.getRemoteUserKey().getStringValue());
        String loggedInUserKey = this.userManager.getRemoteUserKey().getStringValue();
        List<Object> filteredGroupNames = new ArrayList();
        String string = filterText = filterText.equals("undefined") ? "" : filterText;
        if (StringUtils.isNotEmpty(filterText)) {
            for (String string2 : groupNames) {
                if (!string2.contains(filterText)) continue;
                filteredGroupNames.add(string2);
            }
        } else {
            filteredGroupNames = groupNames;
        }
        String appName = this.productService.getApplicationType().toLowerCase();
        for (String string3 : filteredGroupNames) {
            List<String> favUsersList = this.delegationService.getFavoriteGroupUsers(string3);
            boolean isFavorite = false;
            if (!favUsersList.contains(loggedInUserKey)) continue;
            isFavorite = true;
            MyGroupEntity myGroupEntity = new MyGroupEntity();
            myGroupEntity.setGroupName(string3);
            myGroupEntity.setUserCount(this.productService.getUsersCountInGroup(string3));
            myGroupEntity.setIsFavorite(isFavorite);
            myGroupEntity.setAppName(appName);
            favGroupNamesWithUserCount.put(string3, myGroupEntity);
        }
        WeakHashMap<String, Object> weakHashMap = new WeakHashMap<String, Object>();
        int n = favGroupNamesWithUserCount.size();
        if (paginate) {
            int totalPage = (int)Math.ceil((double)n / 20.0);
            if (totalPage < endPage) {
                if (page == endPage) {
                    page = totalPage;
                }
                if ((startPage = Integer.valueOf((endPage = Integer.valueOf(totalPage)) - 4)) < 1) {
                    startPage = 1;
                }
                if (endPage == startPage) {
                    endPage = -1;
                }
            } else if (endPage < startPage + 4) {
                int reqEndPage = startPage + 4;
                endPage = reqEndPage <= totalPage ? reqEndPage : totalPage;
            }
            if (favGroupNamesWithUserCount.isEmpty()) {
                endPage = -1;
                page = 1;
            }
            filteredGroupNames = n >= (page - 1) * 20 + 20 ? filteredGroupNames.subList((page - 1) * 20, (page - 1) * 20 + 20) : filteredGroupNames.subList((page - 1) * 20, n);
            weakHashMap.put("delegatedGroups", filteredGroupNames);
            weakHashMap.put("pageEntity", this.delegatedGroupPaginationService.positionThePager(startPage, page, endPage, n, 20));
        } else {
            weakHashMap.put("delegatedGroups", filteredGroupNames);
        }
        weakHashMap.put("groupsInfo", favGroupNamesWithUserCount);
        weakHashMap.put("appName", appName);
        weakHashMap.put("total", n);
        weakHashMap.put("viewPreference", "favorite");
        return Response.ok(weakHashMap).build();
    }

    @Path(value="/my-recent-groups")
    @GET
    @Produces(value={"application/json"})
    public Response listMyRecentGroups(@QueryParam(value="filterText") String filterText, @QueryParam(value="paginate") boolean paginate, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="page") Integer page, @QueryParam(value="endPage") Integer endPage, @QueryParam(value="pageSize") Integer pageSize) {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        LinkedHashMap<String, MyGroupEntity> groupNamesWithUserCount = new LinkedHashMap<String, MyGroupEntity>();
        List<String> groupNames = this.delegationService.getGroupDelegation(this.userManager.getRemoteUserKey().getStringValue());
        List<Object> filteredGroupNames = new ArrayList();
        String string = filterText = filterText.equals("undefined") ? "" : filterText;
        if (StringUtils.isNotEmpty(filterText)) {
            for (String grp : groupNames) {
                if (!grp.contains(filterText)) continue;
                filteredGroupNames.add(grp);
            }
        } else {
            filteredGroupNames = groupNames;
        }
        WeakHashMap<String, Object> paginatedGroups = new WeakHashMap<String, Object>();
        int totalGroups = filteredGroupNames.size();
        if (paginate) {
            int totalPage = (int)Math.ceil((double)totalGroups / 20.0);
            if (totalPage < endPage) {
                if (page == endPage) {
                    page = totalPage;
                }
                if ((startPage = Integer.valueOf((endPage = Integer.valueOf(totalPage)) - 4)) < 1) {
                    startPage = 1;
                }
                if (endPage == startPage) {
                    endPage = -1;
                }
            } else if (endPage < startPage + 4) {
                int reqEndPage = startPage + 4;
                endPage = reqEndPage <= totalPage ? reqEndPage : totalPage;
            }
            if (filteredGroupNames.isEmpty()) {
                endPage = -1;
                page = 1;
            }
            filteredGroupNames = totalGroups >= (page - 1) * 20 + 20 ? filteredGroupNames.subList((page - 1) * 20, (page - 1) * 20 + 20) : filteredGroupNames.subList((page - 1) * 20, totalGroups);
            paginatedGroups.put("delegatedGroups", filteredGroupNames);
            paginatedGroups.put("pageEntity", this.delegatedGroupPaginationService.positionThePager(startPage, page, endPage, totalGroups, 20));
        } else {
            paginatedGroups.put("delegatedGroups", filteredGroupNames);
        }
        List<DelegationGroup> delGroupObjs = this.delegationService.getDelegationGroupObjs(filteredGroupNames);
        Collections.sort(delGroupObjs, new SortDelGroupsbyID());
        String loggedInUserKey = this.userManager.getRemoteUserKey().getStringValue();
        int counter = 0;
        String appName = this.productService.getApplicationType().toLowerCase();
        for (DelegationGroup delGroup : delGroupObjs) {
            ++counter;
            String groupName = delGroup.getGroupName();
            List<String> favUsersList = this.delegationService.getFavoriteGroupUsers(groupName);
            boolean isFavorite = false;
            if (favUsersList.contains(loggedInUserKey)) {
                isFavorite = true;
            }
            MyGroupEntity myGroupEntity = new MyGroupEntity();
            myGroupEntity.setGroupName(groupName);
            myGroupEntity.setUserCount(this.productService.getUsersCountInGroup(groupName));
            myGroupEntity.setIsFavorite(isFavorite);
            myGroupEntity.setAppName(appName);
            if (counter < 3) {
                myGroupEntity.setIsNew(true);
            }
            groupNamesWithUserCount.put(groupName, myGroupEntity);
        }
        paginatedGroups.put("groupsInfo", groupNamesWithUserCount);
        paginatedGroups.put("appName", appName);
        paginatedGroups.put("total", totalGroups);
        paginatedGroups.put("viewPreference", "recent");
        return Response.ok(paginatedGroups).build();
    }

    @Path(value="/my-group")
    @GET
    @Produces(value={"application/json"})
    public Response listContentsOfMyGroup(@QueryParam(value="group") String group, @QueryParam(value="paginate") boolean paginate, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="page") Integer page, @QueryParam(value="endPage") Integer endPage, @QueryParam(value="searchTerm") String searchTerm) throws Exception {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        group = URLDecoder.decode(group, "UTF-8");
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        List<Object> delegatedUsers = Lists.newArrayList();
        int totalUsers = 0;
        if (!StringUtils.isBlank(searchTerm)) {
            delegatedUsers = this.delegatedGroupPaginationService.filterUsersInGroup(group, searchTerm);
            totalUsers = delegatedUsers.size();
        } else {
            totalUsers = this.productService.getUsersCountInGroup(group);
        }
        WeakHashMap<String, Object> paginatedUsers = new WeakHashMap<String, Object>();
        if (paginate) {
            int totalPage = (int)Math.ceil((double)totalUsers / 20.0);
            if (totalPage < endPage) {
                if (page == endPage) {
                    page = totalPage;
                }
                if ((startPage = Integer.valueOf((endPage = Integer.valueOf(totalPage)) - 4)) < 1) {
                    startPage = 1;
                }
                if (endPage == startPage) {
                    endPage = -1;
                }
            } else if (endPage < startPage + 4) {
                int reqEndPage = startPage + 4;
                endPage = reqEndPage <= totalPage ? reqEndPage : totalPage;
            }
            if (totalUsers == 0) {
                endPage = -1;
                page = 1;
            }
            if (!StringUtils.isBlank(searchTerm)) {
                List<Object> filtered = Lists.newArrayList();
                filtered = totalUsers >= (page - 1) * 20 + 20 ? delegatedUsers.subList((page - 1) * 20, (page - 1) * 20 + 20) : delegatedUsers.subList((page - 1) * 20, totalUsers);
                paginatedUsers.put("delegatedUsers", filtered);
            } else {
                delegatedUsers = this.delegatedGroupPaginationService.getUsersInGroup(group, page);
                paginatedUsers.put("delegatedUsers", delegatedUsers);
            }
            paginatedUsers.put("pageEntity", this.delegatedGroupPaginationService.positionThePager(startPage, page, endPage, totalUsers, 20));
        } else {
            paginatedUsers.put("delegatedUsers", delegatedUsers);
        }
        return Response.ok(paginatedUsers).build();
    }

    @Path(value="/my-group")
    @DELETE
    @Produces(value={"application/json"})
    public Response removeGroup(Map<String, String> data) {
        String group = data.get("group");
        String userKey = data.get("user");
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        if (this.userManager.getRemoteUserKey().getStringValue().equals(userKey)) {
            return Response.ok().build();
        }
        try {
            this.productService.removeUserFromGroup(group, this.userManager.getRemoteUserKey().getStringValue(), userKey);
            this.delegatedGroupPaginationService.getUserCache().remove((Object)group);
        }
        catch (Exception e) {
            logger.error("Error when removing user from group: [" + group + "] Error:" + e.getMessage());
        }
        return Response.ok().build();
    }

    @Path(value="/user/bulk-remove")
    @DELETE
    @Produces(value={"application/json"})
    public Response bulkRemoveGroup(Map<String, String> data) {
        Gson converter = new Gson();
        String group = data.get("group");
        List userKeyList = converter.fromJson(data.get("users"), List.class);
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        for (String userKey : userKeyList) {
            try {
                this.productService.removeUserFromGroup(group, this.userManager.getRemoteUserKey().getStringValue(), userKey);
                this.delegatedGroupPaginationService.getUserCache().remove((Object)group);
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)e.getMessage()).build();
            }
        }
        return Response.ok().build();
    }

    @Path(value="/setOrUnsetFavoriteGroup")
    @POST
    @Produces(value={"application/json"})
    public Response setOrUnsetFavoriteGroup(Map<String, String> data) {
        String userKey = this.userManager.getRemoteUserKey().getStringValue();
        if (userKey == null) {
            return Response.status((int)403).build();
        }
        String group = data.get("group");
        String setOrUnset = data.get("setOrUnset");
        if (StringUtils.isNotEmpty(setOrUnset) && setOrUnset.equalsIgnoreCase("set")) {
            this.delegationService.addFavoriteUserGroup(group, userKey);
        } else if (StringUtils.isNotEmpty(setOrUnset) && setOrUnset.equalsIgnoreCase("unset")) {
            this.delegationService.removeFavoriteUserGroup(group, userKey);
        }
        return Response.ok().build();
    }

    @Path(value="/configured-whitelist-groups")
    @GET
    @Produces(value={"application/json"})
    public Response getWhiteListGroups() {
        String whiteListGroupsFromDelegation = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whiteListGroups");
        if (whiteListGroupsFromDelegation == null || whiteListGroupsFromDelegation.trim().isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        List resultList = Arrays.stream(whiteListGroupsFromDelegation.split(",")).map(group -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", group.trim());
            map.put("text", group.trim());
            return map;
        }).collect(Collectors.toList());
        return Response.ok(resultList).build();
    }

    @Path(value="/my-group")
    @POST
    @Produces(value={"application/json"})
    public Response addGroup(Map<String, String> data) {
        String group = data.get("group");
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        String userKey = data.get("user");
        try {
            UserProfile userProfile;
            if (userKey != null && group != null && this.userManager.getRemoteUserKey() != null && (userProfile = this.userManager.getUserProfile(userKey)) != null && userProfile.getUserKey() != null && this.userManager.getRemoteUserKey() != null) {
                this.productService.addUserToGroup(group, this.userManager.getRemoteUserKey().getStringValue(), userProfile.getUserKey().getStringValue());
                this.delegatedGroupPaginationService.getUserCache().remove((Object)group);
            }
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @Path(value="/find-user")
    @GET
    @Produces(value={"application/json"})
    public Response findUser(@QueryParam(value="user") String user, @QueryParam(value="group") String group) {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        return Response.ok((Object)this.filterUsers(group, this.productService.finderUsers(user, null))).build();
    }

    @Path(value="/setAsPreferredView")
    @POST
    @Produces(value={"application/json"})
    public Response setAsPreferredForUser(Map<String, String> data) {
        String userKey = this.userManager.getRemoteUserKey().getStringValue();
        if (userKey == null) {
            return Response.status((int)403).build();
        }
        String setView = data.get("setView");
        if (StringUtils.isNotEmpty(setView)) {
            this.delegationService.setAsPreferredViewForUser(setView, userKey);
        }
        return Response.ok().build();
    }

    private DelegatedUserDTO filterUsers(String group, List<DelegatedUser> finderUsers) {
        boolean flag = false;
        DelegatedUserDTO delegatedUserDTO = new DelegatedUserDTO();
        ArrayList<String> usernamesInDelegatedGroup = new ArrayList<String>();
        for (DelegatedUser userInDelegatedGroup : this.productService.getUsersInGroup(group)) {
            usernamesInDelegatedGroup.add(userInDelegatedGroup.getName());
        }
        List<DelegatedUser> finderUsersWhiteListed = this.getWhiteListedUsers(finderUsers);
        finderUsers = finderUsersWhiteListed;
        Iterator<DelegatedUser> finderUsersIter = finderUsers.iterator();
        while (finderUsersIter.hasNext()) {
            DelegatedUser delegatedUser = finderUsersIter.next();
            if (!usernamesInDelegatedGroup.contains(delegatedUser.getName())) continue;
            flag = true;
            finderUsersIter.remove();
        }
        delegatedUserDTO.setDelegatedUsers(finderUsers);
        if (flag && finderUsers.isEmpty()) {
            delegatedUserDTO.setIsUserExists(true);
        }
        return delegatedUserDTO;
    }

    private List<DelegatedUser> getWhiteListedUsers(List<DelegatedUser> finderUsers) {
        String whiteListedDomains = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whiteListedDomains");
        String includeOrExclude = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whitelist.whitelistRadio");
        if (StringUtils.isNotBlank(whiteListedDomains) && StringUtils.isNotBlank(includeOrExclude)) {
            whiteListedDomains = whiteListedDomains.replaceAll("\\s", "");
            String[] domainArr = whiteListedDomains.split(",");
            Iterator<DelegatedUser> finderUsersIterator = finderUsers.iterator();
            while (finderUsersIterator.hasNext()) {
                DelegatedUser delegatedUser = finderUsersIterator.next();
                String email = delegatedUser.getEmail();
                String emailDomain = "";
                if (StringUtils.isNotBlank(email) && email.contains("@")) {
                    emailDomain = email.substring(email.indexOf("@") + 1);
                }
                if ((!includeOrExclude.equalsIgnoreCase("exclude") || !Arrays.asList(domainArr).contains(emailDomain)) && (!includeOrExclude.equalsIgnoreCase("include") || Arrays.asList(domainArr).contains(emailDomain))) continue;
                finderUsersIterator.remove();
            }
        }
        return finderUsers;
    }

    private boolean isInValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            if (((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid()) {
                return false;
            }
            logger.error("Delegated groups license is invalid: " + ((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).toString());
            return true;
        }
        logger.error("Delegated groups license is not licensed");
        return true;
    }

    @Path(value="/getAll")
    @GET
    @Produces(value={"application/json"})
    public Response listAllDelegatedGroups() throws Exception {
        if (this.userManager.getRemoteUserKey() == null || this.userManager.getRemoteUserKey() != null && !this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        List<String> allDelegatedGroups = this.delegationService.getAllDelegatedGroupNames();
        JSONArray delegatedGroupsJson = new JSONArray();
        for (String delegatedGroup : allDelegatedGroups) {
            delegatedGroupsJson.put(new JSONObject(this.getDelegatedGroupAsStr(delegatedGroup)));
        }
        return Response.ok((Object)delegatedGroupsJson.toString().replace("\\", "")).build();
    }

    @Path(value="/getGroup/{group}")
    @GET
    @Produces(value={"application/json"})
    public Response getGroup(@PathParam(value="group") String groupName) {
        if (this.userManager.getRemoteUserKey() == null || this.userManager.getRemoteUserKey() != null && !this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        return Response.ok((Object)this.getDelegatedGroupAsStr(groupName)).build();
    }

    private String getDelegatedGroupAsStr(String groupName) {
        StringBuilder userOwners = new StringBuilder();
        StringBuilder groupOwners = new StringBuilder();
        for (DelegationGroup delegation : this.delegationService.getDelegatedGroup(groupName)) {
            for (GroupOwner groupOwner : delegation.getGroupOwners()) {
                groupOwners.append(groupOwner.getOwnerName() + ",");
            }
            for (UserOwner userOwner : delegation.getUserOwners()) {
                UserProfile userProfile = this.userManager.getUserProfile(new UserKey(userOwner.getOwnerKey()));
                if (userProfile != null) {
                    userOwners.append(userProfile.getUsername() + ",");
                    continue;
                }
                userOwners.append(userOwner.getOwnerKey() + ",");
            }
        }
        JSONObject delegatedGroupJson = new JSONObject();
        try {
            delegatedGroupJson.put("group", groupName);
            delegatedGroupJson.put("groupOwners", StringUtils.removeEnd(groupOwners.toString(), ","));
            delegatedGroupJson.put("userOwners", StringUtils.removeEnd(userOwners.toString(), ","));
        }
        catch (JSONException e) {
            logger.error("Error when constructing the JSON Object:" + e.getMessage());
        }
        logger.debug(delegatedGroupJson.toString());
        return delegatedGroupJson.toString();
    }

    @Path(value="/{groupName}/export-csv")
    @Produces(value={"application/octet-stream"})
    @GET
    public Response exportGroupUsersAsCSV(@PathParam(value="groupName") String groupName, @Context HttpServletResponse response) throws IOException {
        if (this.userManager.getRemoteUserKey() == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.isInValid()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        String group = URLDecoder.decode(groupName, StandardCharsets.UTF_8.name());
        List users = (List)this.delegatedGroupPaginationService.getUserCache().get((Object)groupName);
        if (users == null || users.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);){
            CSVPrinter csvFilePrinter = this.delegatedGroupPaginationService.exportCSV(osw, users);
            if (csvFilePrinter != null) {
                response.setHeader("Content-Disposition", "attachment; filename=" + group.concat("-users") + System.currentTimeMillis() + ".csv");
                response.setContentType("text/csv");
                csvFilePrinter.flush();
            }
        }
        catch (IOException e) {
            logger.error("users-export : Exception while export", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error exporting users").build();
        }
        return Response.ok().build();
    }

    class SortDelGroupsbyID
    implements Comparator<DelegationGroup> {
        SortDelGroupsbyID() {
        }

        @Override
        public int compare(DelegationGroup group1, DelegationGroup group2) {
            return group2.getID() - group1.getID();
        }
    }
}

