/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.general.support;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.wittified.general.support.SupportBarService;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.joda.time.DateTime;

@ExportAsService
@Named
public class SupportBarServiceImpl
implements SupportBarService {
    @ComponentImport
    private final TemplateRenderer templateRenderer;
    @ComponentImport
    private final PageBuilderService pageBuilderService;
    @ComponentImport
    private final PluginRetrievalService pluginRetrievalService;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    private PluginLicense testPluginLicense = null;

    @Inject
    public SupportBarServiceImpl(TemplateRenderer templateRenderer, PageBuilderService pageBuilderService, PluginRetrievalService pluginRetrievalService, PluginLicenseManager pluginLicenseManager) {
        this.templateRenderer = templateRenderer;
        this.pageBuilderService = pageBuilderService;
        this.pluginRetrievalService = pluginRetrievalService;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Override
    public void setLicense(PluginLicense pluginLicense) {
        this.testPluginLicense = pluginLicense;
    }

    @Override
    public String getHtml() {
        Plugin thisPlugin = this.pluginRetrievalService.getPlugin();
        String pluginKey = thisPlugin.getKey();
        String restBase = null;
        boolean isEAP = false;
        try {
            Document p2Descriptor = new SAXBuilder().build(thisPlugin.getResource("atlassian-plugin.xml"));
            Element restElement = p2Descriptor.getRootElement().getChild("rest");
            String path = restElement.getAttributeValue("path");
            String version = restElement.getAttributeValue("version");
            if (path != null && version != null) {
                restBase = path + "/" + version;
            }
        }
        catch (Exception p2Descriptor) {
            // empty catch block
        }
        this.pageBuilderService.assembler().resources().requireContext("communicator-resources");
        Map params = thisPlugin.getPluginInformation().getParameters();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("pluginKey", pluginKey);
        context.put("version", thisPlugin.getPluginInformation().getVersion());
        String sha = (String)params.get("sha");
        if (sha == null) {
            sha = "";
        }
        context.put("sha", sha);
        if (sha.length() < 7) {
            context.put("shortSha", sha);
        } else {
            context.put("shortSha", ((String)params.get("sha")).substring(0, 6));
        }
        context.put("support", params.get("supportUrl"));
        context.put("documentation", params.get("documentationUrl"));
        context.put("title", thisPlugin.getName());
        context.put("restBase", restBase);
        context.put("buildNumber", params.get("buildNumber"));
        context.put("EAPIssued", params.get("eap"));
        context.put("isEAP", params.containsKey("eap"));
        context.put("isEvaluation", false);
        context.put("expiration", new Date());
        context.put("maintenanceExpired", false);
        PluginLicense pluginLicense = this.testPluginLicense;
        if (this.testPluginLicense == null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined()) {
            pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
        }
        if (pluginLicense != null) {
            if (pluginLicense.isEvaluation()) {
                context.put("isEvaluation", true);
                context.put("expiration", ((DateTime)pluginLicense.getExpiryDate().get()).toDate());
                context.put("maintenanceExpired", true);
            } else if (pluginLicense.isMaintenanceExpired()) {
                context.put("maintenanceExpired", true);
                context.put("expiration", ((DateTime)pluginLicense.getMaintenanceExpiryDate().get()).toDate());
            }
        }
        StringWriter writer = new StringWriter();
        try {
            if (isEAP) {
                this.templateRenderer.render("/communicator/templates/eap-support-bar.vm", context, (Writer)writer);
            } else {
                this.templateRenderer.render("/communicator/templates/support-bar.vm", context, (Writer)writer);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        return writer.toString();
    }
}

