/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.product;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.mail.Email;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.google.common.collect.Lists;
import com.wittified.groupadmin.ao.DelegationGroup;
import com.wittified.groupadmin.ao.DelegationService;
import com.wittified.groupadmin.ao.GroupOwner;
import com.wittified.groupadmin.ao.UserOwner;
import com.wittified.groupadmin.product.DelegatedUser;
import com.wittified.groupadmin.product.ProductService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraProductServiceImpl
implements ProductService {
    private final GroupManager groupManager;
    private final DelegationService delegationService;
    private final UserManager userManager;
    private final com.atlassian.jira.user.util.UserManager jiraUserManager;
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final AvatarService avatarService;
    private final MailServerManager mailServerManager;
    private final GroupPickerSearchService groupPickerSearchService;
    public static final String JIRA_SOFTWARE_KEY_NAME = "jiraSoftware";
    public static final String JIRA_CORE_NAME = "JIRA Core";
    public static final String JIRA_SOFTWARE_NAME = "JIRA Software";
    private final Logger logger = LoggerFactory.getLogger(JiraProductServiceImpl.class);

    public JiraProductServiceImpl(GroupManager groupManager, UserManager userManager, DelegationService delegationService, com.atlassian.jira.user.util.UserManager jiraUserManager, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, AvatarService avatarService, MailServerManager mailServerManager, GroupPickerSearchService groupPickerSearchService) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.delegationService = delegationService;
        this.jiraUserManager = jiraUserManager;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.avatarService = avatarService;
        this.mailServerManager = mailServerManager;
        this.groupPickerSearchService = groupPickerSearchService;
    }

    @Override
    public List<String> getGroupsStartingWith(String startString, String excluded) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String groupName : this.userManager.findGroupNamesByPrefix(startString, 0, 30)) {
            if (excluded.equalsIgnoreCase(groupName) || this.delegationService.getDelegatedGroup(groupName).length != 0) continue;
            groups.add(groupName);
        }
        return groups;
    }

    @Override
    public List<DelegatedUser> getUsersInGroup(String groupName) {
        ArrayList<DelegatedUser> users = new ArrayList<DelegatedUser>();
        Group group = this.groupManager.getGroup(groupName);
        if (group != null) {
            Collection directUsersList = this.groupManager.getDirectUsersInGroup(group);
            for (ApplicationUser applicationUser : this.groupManager.getUsersInGroup(group)) {
                boolean isNestedGroupMember = false;
                if (applicationUser != null && !directUsersList.contains(applicationUser)) {
                    isNestedGroupMember = true;
                    this.logger.debug("User " + applicationUser.getUsername() + " is part of nested group");
                }
                if (applicationUser == null || !applicationUser.isActive()) continue;
                users.add(this.convertApplicationUserWithAvatar(applicationUser, isNestedGroupMember));
            }
        } else {
            this.logger.debug(String.format("group: %s is not found", groupName));
        }
        return users;
    }

    @Override
    public List<String> getDelegatedGroups(String user) {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (String groupName : this.delegationService.getGroupDelegation(user)) {
            Group group = this.groupManager.getGroup(groupName);
            if (group == null) continue;
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    @Override
    public List<DelegatedUser> getDelegatedGroup(String group, String user) {
        ArrayList<DelegatedUser> users = new ArrayList<DelegatedUser>();
        if (!this.delegationService.hasGroupDelegation(group, user, null)) {
            return users;
        }
        for (ApplicationUser applicationUser : this.groupManager.getUsersInGroup(this.groupManager.getGroup(group))) {
            if (applicationUser == null) continue;
            users.add(this.convertApplicationUser(applicationUser));
        }
        return users;
    }

    @Override
    public void addUserToGroup(String group, String who, String userToAdd) throws Exception {
        if (!this.delegationService.hasGroupDelegation(group, who, null)) {
            return;
        }
        Group groupObj = this.groupManager.getGroup(group);
        ApplicationUser applicationUser = this.jiraUserManager.getUserByKey(userToAdd);
        if (groupObj == null || applicationUser == null) {
            return;
        }
        try {
            this.groupManager.addUserToGroup(applicationUser, groupObj);
        }
        catch (GroupNotFoundException | OperationFailedException | OperationNotPermittedException | UserNotFoundException e) {
            this.logger.error(e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void removeUserFromGroup(String group, String who, String userToRemove) throws Exception {
        if (!this.delegationService.hasGroupDelegation(group, who, null)) {
            return;
        }
        Group groupObj = this.groupManager.getGroup(group);
        ApplicationUser applicationUser = this.jiraUserManager.getUserByKey(userToRemove);
        if (groupObj == null || applicationUser == null) {
            return;
        }
        try {
            this.crowdService.removeUserFromGroup(applicationUser.getDirectoryUser(), groupObj);
        }
        catch (OperationNotPermittedException notPermittedException) {
            this.logger.error("Operation not permitted: " + notPermittedException.getMessage());
            throw new Exception(notPermittedException.getMessage());
        }
    }

    @Override
    public List<DelegatedUser> finderUsers(String startsWith, String groupName) {
        ArrayList<DelegatedUser> delegatedUsers = new ArrayList<DelegatedUser>();
        ArrayList<TermRestriction> searchTerms = new ArrayList<TermRestriction>();
        searchTerms.add(new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)startsWith));
        searchTerms.add(new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)startsWith));
        searchTerms.add(new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)startsWith));
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)Combine.anyOf(searchTerms), (int)0, (int)30);
        Iterable result = this.crowdService.search((Query)query);
        result.forEach(user -> {
            if (user.isActive()) {
                ApplicationUser applicationUser = this.jiraUserManager.getUserByName(user.getName());
                delegatedUsers.add(this.convertApplicationUser(applicationUser));
            }
        });
        return delegatedUsers;
    }

    private DelegatedUser convertApplicationUser(ApplicationUser applicationUser) {
        return new DelegatedUser(applicationUser.getKey(), applicationUser.getDisplayName(), applicationUser.getName(), applicationUser.getEmailAddress(), true, this.isUserReadOnly(applicationUser.getDirectoryId()));
    }

    private DelegatedUser convertApplicationUserWithAvatar(ApplicationUser applicationUser, boolean isNestedGroupMember) {
        return new DelegatedUser(applicationUser.getKey(), applicationUser.getDisplayName(), applicationUser.getName(), applicationUser.getEmailAddress(), true, this.isUserReadOnly(applicationUser.getDirectoryId()), this.avatarService.getAvatarURL(applicationUser, applicationUser, Avatar.Size.SMALL).toString(), isNestedGroupMember, true);
    }

    private boolean isUserReadOnly(long directoryId) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        if (directory != null) {
            return !directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
        }
        return false;
    }

    @Override
    public List<String> getGroupsContain(String search, String delegatedGroupName) {
        ArrayList<String> groups = new ArrayList<String>();
        List groupsList = this.groupPickerSearchService.findGroups(search);
        for (Group group : groupsList) {
            if (search == null || !group.getName().contains(search) || this.delegationService.hasGroupDelegation(delegatedGroupName, null, group.getName())) continue;
            groups.add(group.getName());
        }
        return groups;
    }

    @Override
    public boolean isGroupExists(String groupName) {
        return this.groupManager.getGroup(groupName) != null;
    }

    @Override
    public int getUsersCountInGroup(String groupName) {
        return this.groupManager.getUserNamesInGroup(groupName).size();
    }

    @Override
    public String getApplicationType() {
        return "JIRA";
    }

    @Override
    public String getAvatarUrl(String key) {
        ApplicationUser user = this.jiraUserManager.getUserByKey(key);
        return this.avatarService.getAvatarURL(user, user, Avatar.Size.SMALL).toString();
    }

    @Override
    public boolean isFromNestedGroup(String key, String groupName) {
        ApplicationUser user = this.jiraUserManager.getUserByKey(key);
        Group group = this.groupManager.getGroup(groupName);
        return !this.groupManager.getDirectUsersInGroup(group).contains(user);
    }

    @Override
    public boolean doesUserExistAndIsActive(String user) {
        User jiraUser = this.crowdService.getUser(user);
        if (jiraUser != null) {
            return jiraUser.isActive();
        }
        return false;
    }

    @Override
    public Map<String, Object> getPluginInfo(PluginLicenseManager licenseManager) {
        this.logger.debug("Building plugin  data...");
        HashMap<String, Object> pluginAnalyticsData = new HashMap<String, Object>();
        PluginAccessor pluginAccessor = ComponentAccessor.getPluginAccessor();
        pluginAnalyticsData.put("pluginVersion", JiraProductServiceImpl.getPluginVersion(licenseManager, pluginAccessor));
        pluginAnalyticsData.put("pluginKey", JiraProductServiceImpl.getPluginKey(licenseManager));
        pluginAnalyticsData.put("pluginLicense", JiraProductServiceImpl.getPluginLicense(licenseManager));
        try {
            Option licenseOption = licenseManager.getLicense();
            String LicenseSEN = (String)((PluginLicense)licenseOption.get()).getSupportEntitlementNumber().get();
            if (licenseOption.isDefined()) {
                pluginAnalyticsData.put("pluginLicenseSEN", LicenseSEN);
                pluginAnalyticsData.put("isDataCenter", ((PluginLicense)licenseOption.get()).isDataCenter());
                pluginAnalyticsData.put("isUnlimitedUsers", ((PluginLicense)licenseOption.get()).isUnlimitedEdition());
                pluginAnalyticsData.put("pluginLicenseError", "NONE");
                pluginAnalyticsData.put("isEvaluation", ((PluginLicense)licenseOption.get()).isEvaluation());
                pluginAnalyticsData.put("isSubscription", ((PluginLicense)licenseOption.get()).isSubscription());
                pluginAnalyticsData.put("pluginLicenseType", ((PluginLicense)licenseOption.get()).getLicenseType().name());
                pluginAnalyticsData.put("isMaintenanceExpired", ((PluginLicense)licenseOption.get()).isMaintenanceExpired());
            } else {
                pluginAnalyticsData.put("pluginLicenseSEN", "NONE");
            }
        }
        catch (Exception e) {
            this.logger.debug("Unable to fetch SupportEntitlementNumber for License when posting PluginInfo event, Setting it to None.");
            pluginAnalyticsData.put("pluginLicenseSEN", "NONE");
        }
        return pluginAnalyticsData;
    }

    @Override
    public Map<String, Object> getClientInfo() {
        return new HashMap<String, Object>();
    }

    private static String getPluginVersion(PluginLicenseManager licenseManager, PluginAccessor pluginAccessor) {
        return pluginAccessor.getPlugin(licenseManager.getPluginKey()).getPluginInformation().getVersion();
    }

    private static String getPluginKey(PluginLicenseManager licenseManager) {
        return licenseManager.getPluginKey();
    }

    private static String getPluginLicense(PluginLicenseManager licenseManager) {
        boolean licenseOk;
        boolean bl = licenseOk = licenseManager.getLicense() != null && licenseManager.getLicense().isDefined();
        if (licenseOk) {
            PluginLicense pluginLicense = (PluginLicense)licenseManager.getLicense().get();
            licenseOk = pluginLicense.isValid();
            if (!licenseOk) {
                return ((LicenseError)pluginLicense.getError().get()).name();
            }
            return pluginLicense.getLicenseType().name();
        }
        return "UNLICENSED";
    }

    @Override
    public Map<String, Object> getHostInfo(HostLicenseInformation hostLicenseInformation) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        JiraLicenseService jiraLicenseService = (JiraLicenseService)ComponentAccessor.getComponent(JiraLicenseService.class);
        ArrayList jirLicenseDetails = Lists.newArrayList((Iterable)jiraLicenseService.getLicenses());
        try {
            LicenseDetails coreLicenceDetail = jirLicenseDetails.stream().filter(item -> JIRA_CORE_NAME.equalsIgnoreCase(item.getApplicationDescription())).findAny().orElse(null);
            LicenseDetails softwareLicenceDetail = jirLicenseDetails.stream().filter(item -> JIRA_SOFTWARE_NAME.equalsIgnoreCase(item.getApplicationDescription())).findAny().orElse(null);
            JiraProductServiceImpl.populateBaseLicenseDetails(data, hostLicenseInformation, jiraLicenseService.getServerId());
            JiraProductServiceImpl.populateJiraLicenseDetails(data, coreLicenceDetail);
            if (softwareLicenceDetail != null) {
                HashMap<String, Object> jiraSoftwareData = new HashMap<String, Object>();
                JiraProductServiceImpl.populateJiraLicenseDetails(jiraSoftwareData, softwareLicenceDetail);
                data.put(JIRA_SOFTWARE_KEY_NAME, jiraSoftwareData);
            }
        }
        catch (Exception e) {
            data = null;
        }
        return data;
    }

    private static void populateBaseLicenseDetails(Map<String, Object> data, HostLicenseInformation hostLicenseInformation, String serverId) {
        data.put("hostServerId", serverId == null ? "NONE" : serverId);
        data.put("hostVersion".toString(), ComponentAccessor.getApplicationProperties().getString("jira.version"));
        if (hostLicenseInformation != null) {
            data.put("hostIsDataCenter", hostLicenseInformation.isDataCenter());
            data.put("hostIsEvaluation", hostLicenseInformation.isEvaluation());
            if (hostLicenseInformation.getEdition() != null && hostLicenseInformation.getEdition().isDefined()) {
                data.put("hostEdition", hostLicenseInformation.getEdition().get());
            }
        }
    }

    private static void populateJiraLicenseDetails(Map<String, Object> data, LicenseDetails licenceDetails) {
        int totalUserLimit = 0;
        if (licenceDetails != null) {
            data.put("hostLicenseType", licenceDetails.getLicenseType() == null ? "NONE" : licenceDetails.getLicenseType().name());
            data.put("hostSEN", licenceDetails.getSupportEntitlementNumber() == null ? "NONE" : licenceDetails.getSupportEntitlementNumber());
            data.put("hostMaxUsers", licenceDetails.getJiraLicense() == null ? "NONE" : Integer.valueOf(licenceDetails.getJiraLicense().getMaximumNumberOfUsers()));
            totalUserLimit = JiraProductServiceImpl.getUserLimit(licenceDetails);
            data.put("hostLicenseLevel", Integer.toString(totalUserLimit));
        }
    }

    private static int getUserLimit(LicenseDetails licenceDetail) {
        int totalUserLimit = 0;
        if (licenceDetail != null) {
            LicensedApplications applications = licenceDetail.getLicensedApplications();
            Set keys = applications.getKeys();
            for (ApplicationKey key : keys) {
                totalUserLimit = applications.getUserLimit(key);
            }
        }
        return totalUserLimit;
    }

    @Override
    public int getMarketplaceAppId() {
        return 1215247;
    }

    @Override
    public int getMaxNoOfOwners(List<DelegationGroup> groups) {
        int index = 0;
        int[] countArr = new int[groups.size()];
        for (DelegationGroup del : groups) {
            GroupOwner[] groupOwners;
            int userCount = 0;
            UserOwner[] userOwners = del.getUserOwners();
            userCount += userOwners.length;
            for (GroupOwner owner : groupOwners = del.getGroupOwners()) {
                Group group;
                Group group2 = group = owner.getOwnerName() != null ? this.groupManager.getGroup(owner.getOwnerName()) : null;
                if (group == null) continue;
                Collection groupMembers = this.groupManager.getUsersInGroup(group);
                userCount = (int)((long)userCount + groupMembers.stream().filter(ApplicationUser::isActive).count());
            }
            countArr[index++] = userCount;
        }
        return this.maxNumber(countArr);
    }

    private int maxNumber(int[] countArr) {
        int max = countArr.length > 0 ? countArr[0] : 0;
        for (int ind = 1; ind < countArr.length; ++ind) {
            if (countArr[ind] <= max) continue;
            max = countArr[ind];
        }
        return max;
    }

    @Override
    public void sendEmail(String subject, String body) {
        SMTPMailServer mailServer = this.mailServerManager.getDefaultSMTPMailServer();
        if (mailServer == null) {
            return;
        }
        try {
            if (this.userManager.getRemoteUser() != null) {
                com.atlassian.jira.mail.Email mail = new com.atlassian.jira.mail.Email(this.userManager.getRemoteUser().getEmail());
                mail.setSubject(subject);
                MimeMultipart mainPart = new MimeMultipart();
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Object)body, "text/plain; charset=utf-8");
                mainPart.addBodyPart((BodyPart)messageBodyPart);
                mail.setMultipart((Multipart)mainPart);
                mailServer.send((Email)mail);
                this.logger.debug("Sending message '{}' from Jira SMTP mail server", (Object)subject);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to send email: ", (Object)e.getMessage());
        }
    }
}

