/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.product;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.google.common.collect.Lists;
import com.wittified.groupadmin.ao.DelegationGroup;
import com.wittified.groupadmin.ao.DelegationService;
import com.wittified.groupadmin.ao.GroupOwner;
import com.wittified.groupadmin.ao.UserOwner;
import com.wittified.groupadmin.product.DelegatedUser;
import com.wittified.groupadmin.product.ProductService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceProductServiceImpl
implements ProductService {
    private final UserAccessor userAccessor;
    private final DelegationService delegationService;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final MailServerManager mailServerManager;
    private final MultiQueueTaskManager taskManager;
    Logger logger = LoggerFactory.getLogger(ConfluenceProductServiceImpl.class);

    public ConfluenceProductServiceImpl(UserManager userManager, UserAccessor userAccessor, DelegationService delegationService, GroupManager groupManager, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, MailServerManager mailServerManager, MultiQueueTaskManager taskManager) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.delegationService = delegationService;
        this.groupManager = groupManager;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.mailServerManager = mailServerManager;
        this.taskManager = taskManager;
    }

    @Override
    public List<String> getGroupsStartingWith(String startString, String excluded) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String groupName : this.userManager.findGroupNamesByPrefix(startString, 0, 30)) {
            if (excluded.equalsIgnoreCase(groupName) || this.delegationService.getDelegatedGroup(groupName).length != 0) continue;
            groups.add(groupName);
        }
        return groups;
    }

    @Override
    public List<String> getGroupsContain(String search, String delegatedGroupName) {
        ArrayList<String> groups = Lists.newArrayList();
        List groupsList = this.userAccessor.getGroupsAsList();
        for (com.atlassian.user.Group group : groupsList) {
            if (search == null || !group.getName().contains(search) || this.delegationService.hasGroupDelegation(delegatedGroupName, null, group.getName())) continue;
            groups.add(group.getName());
        }
        groups = new ArrayList<String>(new HashSet(groups));
        return groups;
    }

    @Override
    public List<DelegatedUser> getUsersInGroup(String groupName) {
        ArrayList<DelegatedUser> users = new ArrayList<DelegatedUser>();
        try {
            com.atlassian.user.Group group = this.groupManager.getGroup(groupName);
            if (group == null) {
                return users;
            }
            for (String userKey : this.groupManager.getMemberNames(group)) {
                if (userKey == null || this.userAccessor.isDeactivated(userKey)) continue;
                ConfluenceUser user = this.userAccessor.getUserByName(userKey);
                ProfilePictureInfo userAvatar = this.userAccessor.getUserProfilePicture((User)user);
                DelegatedUser delegatedUser = new DelegatedUser(userKey, user.getFullName(), user.getName(), user.getEmail(), !this.userManager.getRemoteUser().getUsername().equalsIgnoreCase(userKey), this.isUserReadOnly(userKey), userAvatar.getUriReference(), false, false);
                users.add(delegatedUser);
            }
        }
        catch (EntityException e) {
            e.printStackTrace();
        }
        return users;
    }

    @Override
    public List<String> getDelegatedGroups(String user) {
        ArrayList<String> groupNames = new ArrayList<String>();
        try {
            for (String groupName : this.delegationService.getGroupDelegation(user)) {
                com.atlassian.user.Group group = this.groupManager.getGroup(groupName);
                if (group == null) continue;
                groupNames.add(group.getName());
            }
        }
        catch (EntityException e) {
            e.printStackTrace();
        }
        return groupNames;
    }

    @Override
    public List<DelegatedUser> getDelegatedGroup(String group, String user) {
        ArrayList<DelegatedUser> users = new ArrayList<DelegatedUser>();
        if (!this.delegationService.hasGroupDelegation(group, user, null)) {
            return users;
        }
        try {
            Pager groupPager = this.userAccessor.getMemberNames(this.groupManager.getGroup(group));
            if (groupPager == null) {
                return users;
            }
            Iterator userNames = groupPager.iterator();
            while (userNames.hasNext()) {
                users.add(this.convert(this.userAccessor.getUser((String)userNames.next())));
            }
            return users;
        }
        catch (EntityException entityException) {
            return users;
        }
    }

    @Override
    public void addUserToGroup(String group, String who, String userToAdd) throws Exception {
        if (!this.delegationService.hasGroupDelegation(group, who, null)) {
            return;
        }
        String username = this.userManager.getUserProfile(new UserKey(userToAdd)).getUsername();
        com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
        Group groupObject = this.crowdService.getGroup(group);
        try {
            this.crowdService.addUserToGroup(user, groupObject);
        }
        catch (Exception e) {
            this.logger.error("Unable to add user to group " + e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void removeUserFromGroup(String group, String who, String userToRemove) throws Exception {
        if (!this.delegationService.hasGroupDelegation(group, who, null)) {
            return;
        }
        String username = this.userManager.getUserProfile(new UserKey(userToRemove)).getUsername();
        com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
        Group groupObject = this.crowdService.getGroup(group);
        try {
            this.crowdService.removeUserFromGroup(user, groupObject);
        }
        catch (OperationNotPermittedException opExc) {
            this.logger.error("Unable to add user to group " + opExc.getMessage());
            throw new Exception(opExc.getMessage());
        }
    }

    @Override
    public List<DelegatedUser> finderUsers(String startsWith, String groupName) {
        ArrayList<DelegatedUser> delegatedUsers = new ArrayList<DelegatedUser>();
        ArrayList<TermRestriction> searchTerms = new ArrayList<TermRestriction>();
        searchTerms.add(new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)startsWith));
        searchTerms.add(new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)startsWith));
        searchTerms.add(new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)startsWith));
        EntityQuery query = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)Combine.anyOf(searchTerms), (int)0, (int)30);
        Iterable result = this.crowdService.search((Query)query);
        result.forEach(user -> {
            if (user.isActive()) {
                delegatedUsers.add(this.convert((com.atlassian.crowd.embedded.api.User)user));
            }
        });
        return delegatedUsers;
    }

    private DelegatedUser convert(User user) {
        String key = null;
        UserProfile userProfile = this.userManager.getUserProfile(user.getName());
        if (userProfile != null) {
            key = userProfile.getUserKey().getStringValue();
        }
        return new DelegatedUser(key, user.getFullName(), user.getName(), user.getEmail(), true, this.isUserReadOnly(user.getName()));
    }

    private DelegatedUser convert(com.atlassian.crowd.embedded.api.User user) {
        String key = null;
        UserProfile userProfile = this.userManager.getUserProfile(user.getName());
        if (userProfile != null) {
            key = userProfile.getUserKey().getStringValue();
        }
        return new DelegatedUser(key, user.getDisplayName(), user.getName(), user.getEmailAddress(), true, this.isUserReadOnly(user.getName()));
    }

    private boolean isUserReadOnly(String userKey) {
        if (userKey == null) {
            return false;
        }
        com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(userKey);
        if (user == null) {
            return false;
        }
        long directoryId = user.getDirectoryId();
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        if (directory != null) {
            return !directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
        }
        return false;
    }

    @Override
    public boolean isGroupExists(String groupName) {
        try {
            if (this.groupManager.getGroup(groupName) != null) {
                return true;
            }
        }
        catch (EntityException exp) {
            this.logger.error("Unable to add user to group " + exp.getMessage());
        }
        return false;
    }

    @Override
    public int getUsersCountInGroup(String groupName) {
        return this.userAccessor.getMemberNamesAsList(this.userAccessor.getGroup(groupName)).size();
    }

    @Override
    public String getApplicationType() {
        return "CONFLUENCE";
    }

    @Override
    public String getAvatarUrl(String username) {
        return this.userAccessor.getUserProfilePicture((User)this.userAccessor.getUserByName(username)).getUriReference();
    }

    @Override
    public boolean isFromNestedGroup(String key, String groupName) {
        return false;
    }

    @Override
    public Map<String, Object> getPluginInfo(PluginLicenseManager licenseManager) {
        this.logger.debug("Building plugin  data...");
        HashMap<String, Object> pluginAnalyticsData = new HashMap<String, Object>();
        PluginAccessor pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
        pluginAnalyticsData.put("pluginVersion", pluginAccessor.getPlugin("com.wittified.delegated-group-management-in-confluence").getPluginInformation().getVersion());
        pluginAnalyticsData.put("pluginKey", ConfluenceProductServiceImpl.getPluginKey(licenseManager));
        pluginAnalyticsData.put("pluginLicense", ConfluenceProductServiceImpl.getPluginLicense(licenseManager));
        try {
            Option licenseOption = licenseManager.getLicense();
            String LicenseSEN = (String)((PluginLicense)licenseOption.get()).getSupportEntitlementNumber().get();
            if (licenseOption.isDefined()) {
                pluginAnalyticsData.put("pluginLicenseSEN", LicenseSEN);
                pluginAnalyticsData.put("isDataCenter", ((PluginLicense)licenseOption.get()).isDataCenter());
                pluginAnalyticsData.put("isUnlimitedUsers", ((PluginLicense)licenseOption.get()).isUnlimitedEdition());
                pluginAnalyticsData.put("pluginLicenseError", "NONE");
                pluginAnalyticsData.put("isEvaluation", ((PluginLicense)licenseOption.get()).isEvaluation());
                pluginAnalyticsData.put("isSubscription", ((PluginLicense)licenseOption.get()).isSubscription());
                pluginAnalyticsData.put("pluginLicenseType", ((PluginLicense)licenseOption.get()).getLicenseType().name());
                pluginAnalyticsData.put("isMaintenanceExpired", ((PluginLicense)licenseOption.get()).isMaintenanceExpired());
            } else {
                pluginAnalyticsData.put("pluginLicenseSEN", "NONE");
            }
        }
        catch (Exception e) {
            this.logger.debug("Unable to fetch SupportEntitlementNumber for License when posting PluginInfo event, Setting it to None.");
            pluginAnalyticsData.put("pluginLicenseSEN", "NONE");
        }
        return pluginAnalyticsData;
    }

    @Override
    public Map<String, Object> getClientInfo() {
        return new HashMap<String, Object>();
    }

    private static String getPluginKey(PluginLicenseManager licenseManager) {
        return licenseManager.getPluginKey();
    }

    private static String getPluginLicense(PluginLicenseManager licenseManager) {
        boolean licenseOk;
        boolean bl = licenseOk = licenseManager.getLicense() != null && licenseManager.getLicense().isDefined();
        if (licenseOk) {
            PluginLicense pluginLicense = (PluginLicense)licenseManager.getLicense().get();
            licenseOk = pluginLicense.isValid();
            if (!licenseOk) {
                return ((LicenseError)pluginLicense.getError().get()).name();
            }
            return pluginLicense.getLicenseType().name();
        }
        return "UNLICENSED";
    }

    @Override
    public Map<String, Object> getHostInfo(HostLicenseInformation hostLicenseInformation) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        LicenseService licenseService = (LicenseService)ContainerManager.getComponent((String)"licenseService");
        ConfluenceLicense confluenceLicense = licenseService.retrieve();
        data.put("hostLicenseType", confluenceLicense.getLicenseType().name());
        data.put("hostVersion".toString(), confluenceLicense.getLicenseVersion());
        data.put("hostLicenseLevel", confluenceLicense.getMaximumNumberOfUsers());
        return data;
    }

    @Override
    public boolean doesUserExistAndIsActive(String user) {
        return this.userAccessor.exists(user) && !this.userAccessor.isDeactivated(user);
    }

    @Override
    public int getMarketplaceAppId() {
        return 1215163;
    }

    @Override
    public int getMaxNoOfOwners(List<DelegationGroup> groups) {
        int index = 0;
        int[] countArr = new int[groups.size()];
        for (DelegationGroup del : groups) {
            GroupOwner[] groupOwners;
            UserOwner[] userOwners;
            int userCount = 0;
            for (UserOwner user : userOwners = del.getUserOwners()) {
                if (this.userAccessor.isDeactivated(user.getOwnerKey())) continue;
                ++userCount;
            }
            userCount += userOwners.length;
            for (GroupOwner owner : groupOwners = del.getGroupOwners()) {
                try {
                    for (String userKey : this.groupManager.getMemberNames(this.groupManager.getGroup(owner.getOwnerName()))) {
                        if (userKey == null || this.userAccessor.isDeactivated(userKey)) continue;
                        ++userCount;
                    }
                }
                catch (EntityException e) {
                    this.logger.error("Error while fetching group members", e);
                }
            }
            countArr[index] = userCount;
            ++index;
        }
        return this.maxNumber(countArr);
    }

    private int maxNumber(int[] countArr) {
        int max = countArr.length > 0 ? countArr[0] : 0;
        for (int ind = 1; ind < countArr.length; ++ind) {
            if (countArr[ind] <= max) continue;
            max = countArr[ind];
        }
        return max;
    }

    @Override
    public void sendEmail(String subject, String body) {
        SMTPMailServer mailServer = this.mailServerManager.getDefaultSMTPMailServer();
        if (mailServer == null) {
            return;
        }
        try {
            if (this.userManager.getRemoteUser() != null) {
                ConfluenceMailQueueItem mailQueueItem = new ConfluenceMailQueueItem(this.userManager.getRemoteUser().getEmail(), subject, body, "text/plain");
                this.taskManager.addTask("mail", () -> ConfluenceProductServiceImpl.lambda$sendEmail$8ecd2c13$1((MailQueueItem)mailQueueItem));
                this.logger.debug("Added message '{}' to the Confluence mail queue...", (Object)mailQueueItem.getSubject());
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to send email: ", (Object)e.getMessage());
        }
    }

    private static /* synthetic */ void lambda$sendEmail$8ecd2c13$1(MailQueueItem mailQueueItem) throws Exception {
        mailQueueItem.send();
    }
}

