if(!window.wittified) {
    window.wittified = {};
}
if(!window.wittified.delegatedAdmin) {
    window.wittified.delegatedAdmin = {};
}

window.wittified.delegatedAdmin.user = {

    'currentDialog': false,
    'showDialog': function(fromManageGroups) {
		var contextPath = require('wrm/context-path');
        if(!this.currentDialog) {
            this.currentDialog =new AJS.Dialog({
                                    width: 1000,
                                    height: 500,
                                    id: "delegated-user-dialog",
                                    closeOnOutsideClick: fromManageGroups ? false : true
                                });

            this.currentDialog.addHeader("Select group to administer");
            this.currentDialog.addPanel('group-select', '<div id="delegated-group-user-select">&nbsp;</div>');

            this.currentDialog.addButton("Close", function (dialog) {
                /* DELGROUP-333 This code block will execute only for manage groups
                    when request comes from outside of the application */
                if(dialog.redirectToLoginOnClose)
                {
                    window.location.href = getLoginURL(contextPath);
                }
                dialog.hide();
            });
            this.currentDialog.addPage();
            this.currentDialog.addHeader("Edit users in group");
            this.currentDialog.addPanel('group-select', '<div id="delegated-group-user-edit">&nbsp;</div>');

            this.currentDialog.addButton("Add user(s) to group", function (dialog) {
                var group = AJS.$('#search-for-users').data('group');
                dialog.gotoPage(2);
                AJS.$("#user_search_help_link").tooltip({gravity: 'w'});
                wittified.delegatedAdmin.user.currentDialog.updateHeight();
                AJS.$('.wittified-add-user-button').attr('disabled','disabled');
                AJS.$('.wittified-add-user-button').removeClass('button-panel-button');
				
				
			var $eventSelect=AJS.$("#search-for-users").auiSelect2({
            placeholder:"Start typing for user suggestions",
            ajax: {
	 			url: contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/find-user',
				type: "GET",
				dataType: 'json',
				contentType: 'application/json',
				method:"GET",
                data: function (params) {
                    return  {
                        user: params,
                        group: group
                    }
                },
                results: function (data) {
                   var obj = [];
					if(data.isUserExists){
						 obj.push({id:'', 
					text:AJS.I18n.getText('wittified.delgroup.user.search.exist.msg'),
					disabled:true});
					}else{
                    $.each(data.delegatedUsers, function(index,res) {
                        obj.push({id:res.name, text:res.displayName+ '['+res.name+']'});
                        return res;
                      });
					}
                    return {results:obj};
                    
                },
                cache:true
            },
 			formatNoMatches: function formatNoMatches(query) {
                return "No matches found";
            },
			closeOnSelect:false,
             minimumInputLength: 1,
             multiple:true
             
        });
        
		AJS.$('#search-for-users').on('change', function (e) {
 			 // Do something
			var userKey =AJS.$('#search-for-users').select2('val') + ''; 
				if(userKey!='') {
                        AJS.$('.wittified-add-user-button').removeAttr('disabled');
                    } else {
                        AJS.$('.wittified-add-user-button').attr('disabled','disabled');
                    }
				});
               wittified.delegatedAdmin.user.currentDialog.addHeader("Add user to group: " + group);
               
            },'wittified-add-users-button');
        
    
            this.currentDialog.addButton("Remove user(s) from group", function (dialog)
            {
            	AJS.$('#delegated-group-user-edit').spin();
            	AJS.$('.wittified-remove-button').attr('disabled','disabled');
            	var users = [];
            	var group = '';
            	var rowsToDel = [];
            	   AJS.$('#dataTable tbody tr').find('td:first :checkbox').each(function (chkbox) {
            	      group = AJS.$(this).context.dataset.group;
            	       if(AJS.$(this).context.checked){
            	    	   var user =  AJS.$(this).context.dataset.key;
            	    	   var row=document.getElementById("tr_data_"+user);
            	    	   rowsToDel.push(row);
            	    	   users.push(user);
            	       }
            	   });
            	   
        	AJS.$.ajax({
        		'url': contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/user/bulk-remove',
        		'method': 'DELETE',
        		'type':'DELETE',
        		'dataType':'json',
        		'contentType': 'application/json',
        		'data': JSON.stringify( {'users': JSON.stringify(users), 'group': group} ),
        		'success': function(d)
        		{
        			AJS.$('#delegated-group-user-edit').spinStop();
        			//DELGROUPS-147 - check if any filter text is present
        			var searchTerm =  AJS.$('#user-filter').val();
        			wittified.delegatedAdmin.user.showGroup(group, wittified.delegatedAdmin.user.startPage, 
                    		wittified.delegatedAdmin.user.page, wittified.delegatedAdmin.user.endPage, searchTerm);
        			AJS.messages.success("#wittified-message", {
              		    title: 'Success!',
              		    body: "User/s successfully removed."
              		});
        			AJS.$('#wittified-message').show(500);
        			
        			AJS.$('#selectAll').prop('checked', false);
        			setTimeout(function(){
        				AJS.$('#wittified-message').hide(500);
        			}, 2000)

        		},
        		'error': function(response) {
        			var error = response.responseText;
              	  	AJS.messages.error("#wittified-message", {
              		    title: 'Error!',
              		    body: error,
              		    closeable: true
              		});
        			AJS.$('#wittified-message').show();
        		}
        	});
			   
            AJS.$('.wittified-add-users-button').removeAttr('disabled');	
            },'wittified-remove-button');

            
            this.currentDialog.addButton("Cancel", function (dialog)
            {
                dialog.gotoPage(0);
                dialog.updateHeight();
                AJS.$('.wittified-remove-button').attr('disabled','disabled');
                
                showDelegatedGroups('', 1,1,-1);
                /* DELGROUP-333 This code block will execute only for manage groups
                                    when request comes from outside of the application */
                if(dialog.redirectToLoginOnClose)
                {
                    dialog.hide();
                    window.location.href = getLoginURL(contextPath);
                }
            });
                    
            
            this.currentDialog.addLink("Close", function (dialog) {
            /* DELGROUP-333 This code block will execute only for manage groups
                                when request comes from outside of the application */
                if(dialog.redirectToLoginOnClose)
                {
                    window.location.href = getLoginURL(contextPath);
                }
                dialog.hide();
            });

            this.currentDialog.addPage();
            this.currentDialog.addHeader("Add user to group");
            this.currentDialog.addPanel('add-user-select', '<div id="delegated-add-user-to-group">&nbsp;</div>');


            this.currentDialog.addButton("Add User(s)", function( dialog)
            {
                    var group = AJS.$('#search-for-users').data('group');
                    //var userKey = AJS.$('#select-user-to-add').val();
 					var userKey =AJS.$('#search-for-users').select2('val'); 
                    
                    AJS.$.ajax({
                          'url': contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/my-group',
                          'method': 'POST',
                          'type':'POST',
                          'dataType':'json',

                          'contentType': 'application/json',
                          'data': JSON.stringify( {'user': JSON.stringify(userKey), 'group': group} ),
                          'success': function(d)
                          {
                        	//DELGROUPS-147 - check if any filter text is present
                  			var searchTerm = AJS.$('#user-filter').val();
                            wittified.delegatedAdmin.user.showGroup(group, wittified.delegatedAdmin.user.startPage, 
                                		wittified.delegatedAdmin.user.page, wittified.delegatedAdmin.user.endPage, searchTerm);

                          },
                          'error': function(response) {
                             var error = response.responseText;
                             if (response.status === 200) {
                                 AJS.$('#search-for-users').val(null).trigger('change');
                                 AJS.messages.info("#delegated-add-user-to-group-error", {
                                     title: 'Info!',
                                     body: error,
                                     fadeout: true
                                 });
                             } else {
                                 AJS.messages.error("#delegated-add-user-to-group-error", {
                                     title: 'Error!',
                                     body: error,
                                     fadeout: true
                                 });
                             }
                        }
                     });

            },'aui-button aui-button-primary wittified-add-user-button');
           
            
            this.currentDialog.addButton("Cancel", function (dialog)
            {
                dialog.gotoPage(1);
                dialog.updateHeight();
                /* DELGROUP-333 This code block will execute only for manage groups
                                    when request comes from outside of the application */
                if(dialog.redirectToLoginOnClose && dialog.getTitle() && dialog.getTitle().indexOf("Add user to group") !== -1)
                {
                    dialog.hide();
                    window.location.href = getLoginURL(contextPath);
                }
            });

            this.currentDialog.addLink("Close", function (dialog) {
                dialog.hide();
                /* DELGROUP-333 This code block will execute only for manage groups
                                    when request comes from outside of the application */
                if(dialog.redirectToLoginOnClose)
                {
                    window.location.href = getLoginURL(contextPath);
                }
            });

            AJS.$('.wittified-remove-button').attr('disabled','disabled');
        }
        this.currentDialog.gotoPage(0);
        this.currentDialog.show();
		
        showDelegatedGroups('', 1,1,-1);
        AJS.$(document).on('keydown', function (event) {
            if(window.wittified &&
                window.wittified.delegatedAdmin &&
                    window.wittified.delegatedAdmin.user &&
                        window.wittified.delegatedAdmin.user.currentDialog){
                var currentDialog = window.wittified.delegatedAdmin.user.currentDialog;
                if (event.keyCode === 27 && currentDialog && currentDialog.redirectToLoginOnClose) { // ESC key code
                      event.stopImmediatePropagation();  // Prevent the default action
                }
            }
        });
    },
    'copyLinkTextToClipboard': function(groupName) {
        var contextPath = require('wrm/context-path');
        var clipBoardText = window.location.origin+contextPath()+'/plugins/servlet/wittified/delegated/groups/manage-group?groupname='+groupName;
        navigator.clipboard.writeText(clipBoardText);
    },
    'addGroupAsFavorite': function(groupName){
    	var contextPath = require('wrm/context-path');
    	//ajax call to add group as favorite for this user - setOrUnsetFavoriteGroup
    	AJS.$.ajax({
              'url': contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/setOrUnsetFavoriteGroup',
              'method': 'POST',
              'type':'POST',
              'dataType':'json',
              'contentType': 'application/json',
              'data': JSON.stringify( {'setOrUnset':'set','group': groupName} ),
              'success': function(d)
              {
    			wittified.delegatedAdmin.user.showSelectedCriteriaGroups('');	
              },
              'error': function(response) {
              }
         });
    },
    'removeGroupAsFavorite': function(groupName){
		var contextPath = require('wrm/context-path');
    	AJS.$('#addedAsFavorite-'+groupName).attr("style", "display:none");
    	AJS.$('#addAsFavorite-'+groupName).attr("style", "display:block");
    	//ajax call to remove group as favorite for this user - setOrUnsetFavoriteGroup
    	AJS.$.ajax({
              'url': contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/setOrUnsetFavoriteGroup',
              'method': 'POST',
              'type':'POST',
              'dataType':'json',
              'contentType': 'application/json',
              'data': JSON.stringify( {'setOrUnset':'unset','group': groupName} ),
              'success': function(d)
              {
    			wittified.delegatedAdmin.user.showSelectedCriteriaGroups('');
              },
              'error': function(response) {
              }
         });
    },
    'showSelectedCriteriaGroups': function(filterText){
    	var pref = $('#show-selected-groups option:selected').val();
	    if (pref === 'default') { showDefaultGroups(filterText, 1,1,-1); }
	    else if (pref === "recent") { showRecentlyAddedGroups(filterText, 1,1,-1); } 
	    else if (pref === "favorite") { showFavoriteGroups(filterText, 1,1,-1); } 
	    else { showDefaultGroups(filterText, 1,1,-1); }
    },
    'showFilteredGroups': function(){
    	var filterText = AJS.$("#filter-group")[0].value;
    	wittified.delegatedAdmin.user.showSelectedCriteriaGroups(filterText);
    },
    'resetFilterText': function(){
    	AJS.$("#filter-group")[0].value="";
    	wittified.delegatedAdmin.user.showSelectedCriteriaGroups('');
    },
    'showGroup': function(group, startPage, page, endPage, searchTerm, redirectToLoginFlag)
    {
		var contextPath = require('wrm/context-path');
        var impl = this;
        if(wittified.delegatedAdmin.user.currentDialog){
            wittified.delegatedAdmin.user.currentDialog.gotoPage(1);
        }
        AJS.$('#delegated-group-user-edit').spin();
        if(!searchTerm) {
        	searchTerm = AJS.$('#user-filter').val();
        }
        AJS.$.get( contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/my-group',
        		{"group":encodeURIComponent(group), "paginate":true, "startPage":startPage, "page":page, "endPage":endPage, "searchTerm":searchTerm}, function(result)
        {
        	AJS.$('#delegated-group-user-edit').spinStop();
        	AJS.$('#delegated-group-user-edit').html('');
        	
        	function checkIfNestedGroupMemberExists() {
        	    for(var memberId = 0; memberId < result.delegatedUsers.length; memberId++) {
        	        if(members[memberId].isFromNestedGroup == true) {
        	           return true;
        	        }
        	    }
        	}
        	function checkIfInstanceIsJira() {
        	    for(var memberId = 0; memberId < members.length; memberId++) {
        	        if(members[memberId].isJiraUser == true) {
        	           return true;
        	        }
        	    }
        	}
            if(wittified.delegatedAdmin.user.currentDialog){
        	    wittified.delegatedAdmin.user.currentDialog.addHeader("Edit users in group: " + group);
        	    /* DELGROUP-333 This code block will execute only for manage groups
                                    when request comes from outside of the application */
        	    if(redirectToLoginFlag) {
        	        wittified.delegatedAdmin.user.currentDialog.redirectToLoginOnClose = true;
        	    }
        	}
			AJS.$('#delegated-group-user-edit').html( wittified.templates.delegatedgroups.user.renderUsers(
					{ 
						'group':group, 
						'users': result.delegatedUsers,
						'pageEntity':result.pageEntity,
						'page':result.pageEntity.page
					}) );
            AJS.$('#delegated-add-user-to-group').html( wittified.templates.delegatedgroups.user.addUser({'group':group}));

            if(wittified.delegatedAdmin.user.currentDialog){
                wittified.delegatedAdmin.user.currentDialog.updateHeight();
            }
            
            AJS.$('#user-filter').val(searchTerm);
            
            wittified.delegatedAdmin.user.page = result.pageEntity.page;
            wittified.delegatedAdmin.user.startPage = result.pageEntity.startPage;
            wittified.delegatedAdmin.user.endPage = result.pageEntity.endPage;


            AJS.$('.delegated-remove-user').on('click', function(evt)
            {
                evt.preventDefault();
                var group = AJS.$(this).data('group');
                var userKey = AJS.$(this).data('key');


                   AJS.$.ajax({
                      'url': contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/my-group',
                      'method': 'DELETE',
                      'type':'DELETE',
                      'dataType':'json',

                      'contentType': 'application/json',
                      'data': JSON.stringify( {'group': group, 'user': JSON.stringify(userKey)} ),
                      'success': function(d)
                      {
                        impl.showGroup( group, wittified.delegatedAdmin.user.startPage, wittified.delegatedAdmin.user.page, wittified.delegatedAdmin.user.endPage, '');
                    }
                });
            })
            
            AJS.$("#member-filter-submit").on('click', function(evt){
            	evt.preventDefault();
            	var group = AJS.$(this).data('group');
            	var userSearchTerm = AJS.$('#user-filter').val();
            	impl.showGroup(group, 1, 1, -1, userSearchTerm);
            });
        });
    },
    'setAsPreferredView': function(){
		var contextPath = require('wrm/context-path');
		var view = AJS.$("#show-selected-groups").val();
		AJS.$.ajax({
              'url': contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/setAsPreferredView',
              'method': 'POST',
              'type':'POST',
              'dataType':'json',
              'contentType': 'application/json',
              'data': JSON.stringify( {'setView':view} ),
              'success': function(d) {
    			AJS.$("#set-default-view-btn").attr("disabled",true);
    			AJS.$("#saved-msg")[0].innerHTML="<span class='aui-icon aui-icon-small aui-iconfont-approve' style='color:#008000'>Saved</span>";
              },
              'error': function(e) {
              }
         });
	}
}

function getLoginURL(contextPath) {
    var redirectURL = window.jira ? "/login.jsp" : "/login.action";
    return contextPath()+redirectURL;
}

function text(str){
	   return $('<div>',{text:str}).text();
	}
	
var preference="";
function getMyPreferredView() {
	var contextPath = require('wrm/context-path');
	return new Promise(function(resolve, reject){
		AJS.$.get(contextPath() + '/rest/wittified/delegated-groups/1.0/delegation/my-preferred-view', function(data){
	    	resolve(data);
		}).fail(function(error) {
			reject(error);
		});
	})
}

function showDelegatedGroups(filterText, startPage, page, endPage) {
    if(preference){
        preference.then(function (val) {
            if(val==="recent") { showRecentlyAddedGroups(filterText, startPage, page, endPage);}
            else if(val==="favorite") { showFavoriteGroups(filterText, startPage, page, endPage);}
            else { showDefaultGroups(filterText, startPage, page, endPage);}
        });
    }
}

function showDefaultGroups(filterText, startPage, page, endPage) {
	var contextPath = require('wrm/context-path');
	AJS.$('#delegated-group-user-select').spin();
	AJS.$.get( contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/my-groups?filterText='+filterText+'&paginate=true&startPage='+startPage+'&page='+page+'&endPage='+endPage, function(groups)
			{
		AJS.$('#delegated-group-user-select').spinStop();
		
		wittified.delegatedAdmin.user.startPage = groups.pageEntity.startPage;
		wittified.delegatedAdmin.user.page = groups.pageEntity.page;
		wittified.delegatedAdmin.user.endPage = groups.pageEntity.endPage;
		
		AJS.$('#delegated-group-user-select').html(wittified.templates.delegatedgroups.user.renderList({groups:groups,selectedCriteria:groups.viewPreference,contextPath:contextPath(),filterText:filterText,pageEntity:groups.pageEntity,page:groups.pageEntity.page}));
		AJS.$('#myGroups-delegated-groupCount').html(groups.total);
		wittified.delegatedAdmin.user.currentDialog.updateHeight();
		AJS.$('.delegated-edit-users').on('click', function(evt)
			{
			evt.preventDefault();
			AJS.$('#delegated-group-user-edit').html('');
			wittified.delegatedAdmin.user.showGroup( AJS.$(this).data('group'), 1,1,-1, '');
			})
		});
}

function showFavoriteGroups(filterText, startPage, page, endPage) {
	var contextPath = require('wrm/context-path');
	AJS.$('#delegated-group-user-select').spin();
	AJS.$.get( contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/my-favorite-groups?filterText='+filterText+'&paginate=true&startPage='+startPage+'&page='+page+'&endPage='+endPage, function(groups)
			{
		AJS.$('#delegated-group-user-select').spinStop();
		
		wittified.delegatedAdmin.user.startPage = groups.pageEntity.startPage;
		wittified.delegatedAdmin.user.page = groups.pageEntity.page;
		wittified.delegatedAdmin.user.endPage = groups.pageEntity.endPage;
		
		AJS.$('#delegated-group-user-select').html(wittified.templates.delegatedgroups.user.renderList({groups:groups,selectedCriteria:'favorite',contextPath:contextPath(),filterText:filterText,pageEntity:groups.pageEntity,page:groups.pageEntity.page}));
		AJS.$('#myGroups-delegated-groupCount').html(groups.total);
		wittified.delegatedAdmin.user.currentDialog.updateHeight();
		AJS.$('.delegated-edit-users').on('click', function(evt)
			{
			evt.preventDefault();
			AJS.$('#delegated-group-user-edit').html('');
			wittified.delegatedAdmin.user.showGroup( AJS.$(this).data('group'), wittified.delegatedAdmin.user.startPage,wittified.delegatedAdmin.user.page, wittified.delegatedAdmin.user.endPage, '');

			})
		});
}

function showRecentlyAddedGroups(filterText, startPage, page, endPage) {
	var contextPath = require('wrm/context-path');
	AJS.$('#delegated-group-user-select').spin();
	AJS.$.get( contextPath()+'/rest/wittified/delegated-groups/1.0/delegation/my-recent-groups?filterText='+filterText+'&paginate=true&startPage='+startPage+'&page='+page+'&endPage='+endPage, function(groups)
			{
		AJS.$('#delegated-group-user-select').spinStop();
		
		wittified.delegatedAdmin.user.startPage = groups.pageEntity.startPage;
		wittified.delegatedAdmin.user.page = groups.pageEntity.page;
		wittified.delegatedAdmin.user.endPage = groups.pageEntity.endPage;
		
		AJS.$('#delegated-group-user-select').html(wittified.templates.delegatedgroups.user.renderList({groups:groups,selectedCriteria:'recent',contextPath:contextPath(),filterText:filterText,pageEntity:groups.pageEntity,page:groups.pageEntity.page}));
		AJS.$('#myGroups-delegated-groupCount').html(groups.total);
		wittified.delegatedAdmin.user.currentDialog.updateHeight();
		AJS.$('.delegated-edit-users').on('click', function(evt)
			{
			evt.preventDefault();
			AJS.$('#delegated-group-user-edit').html('');
			wittified.delegatedAdmin.user.showGroup( AJS.$(this).data('group'), wittified.delegatedAdmin.user.startPage,wittified.delegatedAdmin.user.page, wittified.delegatedAdmin.user.endPage, '');

			})
		});
}

function toggleButtonState (chktoremove) {
	var values = document.querySelectorAll(".check-boxes"); 
	input = Array.prototype.slice.call(values);
	var found = false;
	input.forEach(function(item){
		if(item.checked){
			found=true
		}
	})

	if (found){
		AJS.$('.wittified-remove-button').removeAttr('disabled');
		AJS.$('.wittified-add-users-button').attr('disabled','disabled');
	}
	else{
		AJS.$('.wittified-remove-button').attr('disabled','disabled');
		AJS.$('.wittified-add-users-button').removeAttr('disabled');
	}
		
}

function findUser() {
    var filter = AJS.$('#user-filter').val().toLowerCase();
    var isAttrExist = function (entry) {
        return entry.trim().toLowerCase().indexOf(filter) > -1;
    };
    AJS.$("#dataTable tbody tr").each(function(idx, row){
    	
    	if(idx > 0){
        var cols = row.children;
        var usernameCol = cols[1];
        var nameCol = cols[2];
        var emailCol = cols[3];
        row.style.display = isAttrExist(usernameCol && (usernameCol.textContent || usernameCol.innerText))
        || isAttrExist(nameCol && (nameCol.textContent || nameCol.innerText))
        || isAttrExist(emailCol && (emailCol.textContent || emailCol.innerText)) ? "" : "none";
    }
    })
}

AJS.toInit(function() {
	AJS.$('#selectAll').live('click', function () {
	    var checkedStatus = this.checked;
	   AJS.$('#dataTable tbody tr').find('td:first :checkbox').each(function () {
	       
	       if(checkedStatus){
   			AJS.$('.wittified-remove-button').removeAttr('disabled');
   			AJS.$('.wittified-add-users-button').attr('disabled','disabled');
   		   }
	       else{
	    	AJS.$('.wittified-remove-button').attr('disabled','disabled');
	    	AJS.$('.wittified-add-users-button').removeAttr('disabled');
	       }
	   });
	});
	
	
    AJS.$('#my-delegated-group-link').live('click', function(evt) {
        evt.preventDefault();
    	preference = getMyPreferredView();
        window.wittified.delegatedAdmin.user.showDialog();
    });

    AJS.$('#my-delegated-group-link-confluence').live('click', function(evt) {
        evt.preventDefault();
    	preference = getMyPreferredView();
        window.wittified.delegatedAdmin.user.showDialog();
    });
//TODO : Below is not right thing to do to search for groups if 'Enter' key is pressed, fix this
//    document.addEventListener('keydown', function () {
//        if(window.event.keyCode == '13') {
//            window.wittified.delegatedAdmin.user.showFilteredGroups();
//        }
//    });
});