/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.keen.client.java.KeenJsonHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JacksonJsonHandler
implements KeenJsonHandler {
    private static final MapType MAP_TYPE = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);
    private static final CollectionType COLLECTION_TYPE = TypeFactory.defaultInstance().constructCollectionType(List.class, Object.class);
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public Map<String, Object> readJson(Reader reader) throws IOException {
        JsonNode rootNode = this.mapper.readTree(reader);
        Map<String, Object> rootMap = null;
        if (null == rootNode) {
            throw new IllegalArgumentException("Empty reader or ill-formatted JSON encountered.");
        }
        if (rootNode.isArray()) {
            rootMap = new LinkedHashMap<String, Object>();
            rootMap.put("io.keen.client.java.__fake_root", this.mapper.readValue(rootNode.traverse(), (JavaType)COLLECTION_TYPE));
        } else if (rootNode.isObject()) {
            rootMap = (Map)this.mapper.readValue(rootNode.traverse(), (JavaType)MAP_TYPE);
        }
        return rootMap;
    }

    @Override
    public void writeJson(Writer writer, Map<String, ?> value) throws IOException {
        this.mapper.writeValue(writer, value);
    }

    public JacksonJsonHandler() {
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

