/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.upgradetasks;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.wittified.groupadmin.ao.Delegation;
import com.wittified.groupadmin.ao.DelegationService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedGroupUpgradeTask
implements PluginUpgradeTask {
    private final PluginLicenseManager pluginLicenseManager;
    private final DelegationService delegationService;
    private static Logger logger = LoggerFactory.getLogger(DelegatedGroupUpgradeTask.class);

    public DelegatedGroupUpgradeTask(PluginLicenseManager pluginLicenseManager, DelegationService delegationService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.delegationService = delegationService;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Refactor delegated group tables";
    }

    public Collection<Message> doUpgrade() throws Exception {
        LogManager.getLogger("com.wittified").setLevel(Level.INFO);
        List<Delegation> delegationObjs = this.delegationService.getAllDelegatedGroups();
        int count = 0;
        for (Delegation delegation : delegationObjs) {
            String delegatedGroup = delegation.getGroupObj();
            this.delegationService.addGroupDelegation(delegatedGroup);
            String userKey = delegation.getUserKey();
            String groupOwnerName = delegation.getGroupKey();
            if (StringUtils.isNotBlank(userKey)) {
                this.delegationService.addUserOwner(delegatedGroup, userKey);
            }
            if (StringUtils.isNotBlank(groupOwnerName)) {
                this.delegationService.addGroupOwner(delegatedGroup, groupOwnerName);
            }
            logger.info("Migrated record : " + ++count);
        }
        LogManager.getLogger("com.wittified").setLevel(null);
        return Collections.emptySet();
    }

    public String getPluginKey() {
        return this.pluginLicenseManager.getPluginKey();
    }
}

