/*
 * Decompiled with CFR 0.152.
 */
package com.appfire.common.analytics.util;

import com.appfire.common.analytics.bean.EventDetails;
import com.appfire.common.analytics.bean.GlobalEventData;
import com.appfire.common.analytics.core.AnalyticsService;
import com.appfire.common.analytics.core.AnalyticsServiceImpl;
import com.appfire.common.analytics.core.GlobalDataKeys;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsHelper {
    public static final String APPLICATION_PROD_PROPERTIES = "application-prod.properties";
    public static final String APPLICATION_DEV_PROPERTIES = "application-dev.properties";
    public static final String KEEN_WRITE_KEY = "keen.writeKey";
    public static final String KEEN_PROJECT_ID_KEY = "keen.projectId";
    public static final String LICENSE_TYPE_TESTING = "TESTING";
    public static final String LICENSE_TYPE_DEVELOPER = "DEVELOPER";
    private static final Logger log = LoggerFactory.getLogger(AnalyticsHelper.class);
    private static final Map<String, Properties> applicationPropertiesCache = new HashMap<String, Properties>();
    private AnalyticsService analyticsService;

    public AnalyticsHelper(Map<String, Object> hostData, Map<String, Object> pluginData, ClassLoader classLoader) {
        try {
            if (hostData != null && pluginData != null) {
                this.loadApplicationPropertiesIntoCache(classLoader);
                String hostLicenseType = (String)hostData.get(GlobalDataKeys.HOST_LICENSE_TYPE_KEY.getValue());
                Properties properties = this.getApplicationProperties(hostLicenseType);
                String projectKey = properties.getProperty(this.getProjectIdPropertyName());
                String writeKey = properties.getProperty(this.getWriteKeyPropertyName());
                this.analyticsService = new AnalyticsServiceImpl(projectKey, writeKey, new GlobalEventData(hostData, pluginData));
            } else {
                log.debug("Unable to retrieve HostInfo or PluginInfo and hence not posting analytics...");
            }
        }
        catch (Throwable e) {
            log.debug("Error while creating AnalyticsHelper instance", e);
        }
    }

    protected String getProjectIdPropertyName() {
        return KEEN_PROJECT_ID_KEY;
    }

    protected String getWriteKeyPropertyName() {
        return KEEN_WRITE_KEY;
    }

    protected void loadApplicationPropertiesIntoCache(ClassLoader classLoader) {
        String[] propFiles;
        for (String fileName : propFiles = new String[]{APPLICATION_DEV_PROPERTIES, APPLICATION_PROD_PROPERTIES}) {
            if (applicationPropertiesCache.get(fileName) != null) continue;
            applicationPropertiesCache.put(fileName, this.loadPropertiesFromFile(fileName, classLoader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromFile(String propertiesFileName, ClassLoader classLoader) {
        Properties prop = new Properties();
        InputStream input = null;
        try {
            input = classLoader.getResourceAsStream(propertiesFileName);
            prop.load(input);
        }
        catch (Exception ex) {
            prop = null;
            log.debug("Exception while reading analytics configuration ", ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception ex) {
                    log.debug(ex.getMessage(), ex);
                }
            }
        }
        return prop;
    }

    protected Properties getApplicationProperties(String hostLicenseType) {
        String propertiesFileName = this.getApplicationPropertiesFile(hostLicenseType);
        return applicationPropertiesCache.get(propertiesFileName);
    }

    protected String getApplicationPropertiesFile(String licenseType) {
        if (StringUtils.containsIgnoreCase(licenseType, LICENSE_TYPE_DEVELOPER) || LICENSE_TYPE_TESTING.equalsIgnoreCase(licenseType)) {
            return APPLICATION_DEV_PROPERTIES;
        }
        return APPLICATION_PROD_PROPERTIES;
    }

    public void postAnalyticsEvent(String collectionName, Map<String, Object> eventDataMap) {
        try {
            if (this.analyticsService != null) {
                log.debug("Trying to post event  : " + collectionName);
                this.analyticsService.addEvent(collectionName, eventDataMap);
            }
        }
        catch (Exception e) {
            log.debug("Error while posting analytics data ", e);
        }
    }

    public void postAnalyticsEvents(Collection<EventDetails> eventDetailsList) {
        try {
            if (this.analyticsService != null) {
                this.analyticsService.addEvents(eventDetailsList);
            }
        }
        catch (Exception e) {
            log.debug("Error while posting analytics data ", e);
        }
    }
}

