/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.servlets;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.wittified.general.support.SupportBarService;
import com.wittified.groupadmin.ao.DelegationService;
import java.io.IOException;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalConfiguration
extends HttpServlet {
    private static final long serialVersionUID = -6871000211022257460L;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final PageBuilderService pageBuilderService;
    private final SupportBarService supportBarService;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final DelegationService delegationService;
    private static final Logger logger = LoggerFactory.getLogger(GlobalConfiguration.class);

    public GlobalConfiguration(SoyTemplateRenderer soyTemplateRenderer, PageBuilderService pageBuilderService, SupportBarService supportBarService, PluginLicenseManager pluginLicenseManager, UserManager userManager, DelegationService delegationService) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.pageBuilderService = pageBuilderService;
        this.supportBarService = supportBarService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.delegationService = delegationService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.userManager.getRemoteUser() == null) {
            resp.sendError(404);
            return;
        }
        if (!this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            resp.sendError(404);
            return;
        }
        String start = req.getParameter("start");
        WeakHashMap<String, String> context = new WeakHashMap<String, String>();
        context.put("supportBar", this.supportBarService.getHtml());
        try {
            resp.setContentType("text/html");
            String licenseMessage = null;
            if (this.pluginLicenseManager.getLicense() == null || !this.pluginLicenseManager.getLicense().isDefined()) {
                licenseMessage = "Delegated Group Management requires a license in order to function. No valid license was found.";
            } else if (this.pluginLicenseManager.getLicense().get() != null && !((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() && ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                licenseMessage = ((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name().equalsIgnoreCase(LicenseError.EXPIRED.toString()) ? "License has expired. Please visit the Atlassian Marketplace to renew" : (((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name().equalsIgnoreCase(LicenseError.TYPE_MISMATCH.toString()) ? "Add-on License Type does not match product license type" : (((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name().equalsIgnoreCase(LicenseError.USER_MISMATCH.toString()) ? "User count for add-on license does not match product license user count" : (((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name().equalsIgnoreCase(LicenseError.VERSION_MISMATCH.toString()) ? "Version mismatch for license" : ((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name())));
            }
            if (licenseMessage == null) {
                this.pageBuilderService.assembler().resources().requireWebResource(this.pluginLicenseManager.getPluginKey() + ":atl.general");
                this.pageBuilderService.assembler().resources().requireWebResource(this.pluginLicenseManager.getPluginKey() + ":delegated-group-admin-resources").requireContext("delegated-group-admin");
                if (this.delegationService.getDelegationGroupCount() > 0) {
                    start = "no";
                }
                context.put("start", start);
                this.soyTemplateRenderer.render((Appendable)resp.getWriter(), this.pluginLicenseManager.getPluginKey() + ":delegated-group-admin-resources", "wittified.templates.delegatedgroups.renderPage", context);
            } else {
                context.put("licenseMessage", licenseMessage);
                this.soyTemplateRenderer.render((Appendable)resp.getWriter(), this.pluginLicenseManager.getPluginKey() + ":delegated-group-admin-resources", "wittified.templates.delegatedgroups.errorPage", context);
            }
        }
        catch (SoyException soyException) {
            logger.error("Error rendering " + soyException.getMessage());
            soyException.printStackTrace();
            resp.setStatus(500);
        }
    }
}

