/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.analytics;

import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.upm.datacentercompatibility.impl.CompatibilityHostLicenseInformation;
import com.wittified.groupadmin.analytics.DelGroupsAnalytics;
import com.wittified.groupadmin.analytics.DelGroupsAnalyticsHelper;
import com.wittified.groupadmin.analytics.EventType;
import com.wittified.groupadmin.ao.DelegationGroup;
import com.wittified.groupadmin.product.ProductService;
import com.wittified.groupadmin.services.GeneralConfigService;
import java.util.List;
import java.util.Map;

public class DelGroupsAnalyticsImpl
implements DelGroupsAnalytics {
    protected PluginLicenseManager licenseManager;
    private final HostLicenseInformation hostLicenseInformation;
    private final GeneralConfigService generalConfigService;
    private final ProductService productService;

    public DelGroupsAnalyticsImpl(PluginLicenseManager licenseManager, com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, LicenseHandler licenseHandler, GeneralConfigService generalConfigService, ProductService productService) {
        this.licenseManager = licenseManager;
        this.hostLicenseInformation = this.getHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
        this.generalConfigService = generalConfigService;
        this.productService = productService;
    }

    @Override
    public void postEventInfo(EventType eventType) {
        if (this.generalConfigService.getSendStatisticsSetting().equals("on")) {
            DelGroupsAnalyticsHelper helper = this.getHelper(this.licenseManager, this.hostLicenseInformation, this.productService);
            helper.postEventInfo(eventType);
        }
    }

    protected HostLicenseInformation getHostLicenseInformation(com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, LicenseHandler licenseHandler) {
        return new CompatibilityHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
    }

    protected DelGroupsAnalyticsHelper getHelper(PluginLicenseManager licenseManager, HostLicenseInformation hostLicenseInformation, ProductService productService) {
        return new DelGroupsAnalyticsHelper(licenseManager, hostLicenseInformation, productService);
    }

    @Override
    public void postEventInfo(EventType eventType, Map<String, Object> eventDataMap) {
        if (this.generalConfigService.getSendStatisticsSetting().equals("on")) {
            DelGroupsAnalyticsHelper helper = this.getHelper(this.licenseManager, this.hostLicenseInformation, this.productService);
            helper.postEvent(eventType, eventDataMap);
        } else if (eventType.equals((Object)EventType.GENERAL_CONFIG)) {
            DelGroupsAnalyticsHelper helper = this.getHelper(this.licenseManager, this.hostLicenseInformation, this.productService);
            helper.postEvent(eventType, eventDataMap);
        }
    }

    @Override
    public int getMaxNoOfOwners(List<DelegationGroup> groups) {
        return this.productService.getMaxNoOfOwners(groups);
    }
}

