/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.general.rest;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseException;
import com.wittified.general.rest.QuestionsEntity;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

@Scanned
@Path(value="/wittified-communicator")
public class AnswersEndPoint {
    @ComponentImport
    private final RequestFactory requestFactory;
    private static final String ANSWERS_BASE_URL = "https://wittified.atlassian.net/wiki/rest/searchv3/1.0/search?";

    @Inject
    public AnswersEndPoint(RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @Produces(value={"application/json"})
    @Path(value="/search")
    @GET
    public Response search(@QueryParam(value="key") String pluginKey, @QueryParam(value="search") String search) {
        try {
            search = URLEncoder.encode(search, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<QuestionsEntity> questionsEntityList = new ArrayList<QuestionsEntity>();
        try {
            String json = this.requestFactory.createRequest(Request.MethodType.GET, "https://wittified.atlassian.net/wiki/rest/searchv3/1.0/search?queryString=labelText%3A" + pluginKey + "+AND+" + search + "&startIndex=0&where=conf_all").execute();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(json);
            Iterator questions = rootNode.get("results").getElements();
            while (questions.hasNext()) {
                JsonNode questionNode = (JsonNode)questions.next();
                if (!questionNode.has("url") || !questionNode.has("title")) continue;
                QuestionsEntity questionsEntity = new QuestionsEntity();
                questionsEntity.setTitle(this.decode(questionNode.get("title").getTextValue()));
                questionsEntity.setHighlight(this.decode(questionNode.get("bodyTextHighlights").getTextValue()));
                questionsEntity.setUrl(questionNode.get("url").getTextValue());
                if (questionNode.has("acceptedAnswerId")) {
                    questionsEntity.setAccepted(true);
                } else {
                    questionsEntity.setAccepted(false);
                }
                questionsEntityList.add(questionsEntity);
            }
        }
        catch (ResponseException responseException) {
            responseException.printStackTrace();
        }
        catch (IOException responseException) {
            responseException.printStackTrace();
        }
        return Response.ok(questionsEntityList).build();
    }

    private String decode(String str) {
        str = StringUtils.replace((String)str, (String)"@@@hl@@@", (String)"<b>");
        str = StringUtils.replace((String)str, (String)"@@@endhl@@@", (String)"</b>");
        return str;
    }
}

