if(!window.wittified)
{
    window.wittified = {};
}
if(!window.wittified.delegatedAdmin)
{
    window.wittified.delegatedAdmin = {};
}

window.wittified.delegatedAdmin.globalConfig =
{
    'load': function(init, startPage, page, endPage, searchTerm)
    {
    	AJS.$('#delegated-groups-list').spin();
    	//DELGROUPS-42
    	if(!searchTerm) {
            searchTerm = AJS.$('#group-filter').val();
        }
    	wittified.delegatedAdmin.globalConfig.groupSearchTerm = searchTerm;
    	var contextPath = require('wrm/context-path');
        AJS.$.ajax({
            'url': contextPath()+'/rest/wittified/delegated-groups/1.0/configure/groups',
            'method': 'GET',
            'data': {"startPage":startPage, "page":page, "endPage":endPage, "searchTerm":searchTerm},
            'contentType': 'application/json',
            'success': function(result)
            {
            	AJS.$('#delegated-groups-list').spinStop();
                AJS.$('#delegated-groups-list').html( wittified.templates.delegatedgroups.renderRows( {
                    'groups': result.delegatedGroups,
                    'applicationType':result.applicationType
                    } ));
                
                if(result.pageEntity) {
                	AJS.$('#delegatedGroupPagination').html( wittified.templates.delegatedgroups.paginateGroup( {
                    	'size': result.pageEntity.totalSize,
                    	'page': result.pageEntity.page,
                    	'startPage': result.pageEntity.startPage,
                    	'endPage': result.pageEntity.endPage
                    } ));
                	
                	wittified.delegatedAdmin.globalConfig.displayPaginationMessage(result.pageEntity.page, result.pageEntity.totalSize);
                }
                wittified.delegatedAdmin.globalConfig.page = result.pageEntity.page;
                wittified.delegatedAdmin.globalConfig.startPage = result.pageEntity.startPage;
                wittified.delegatedAdmin.globalConfig.endPage = result.pageEntity.endPage;
                // DELGROUPS-35 using aui-sortable to sort the table
                // For dynamically populated table, sortable function should be called explicitly after the table is rendered with all rows
                if(init){
                    AJS.$('#delegated-groups-list-table').addClass("aui-table-sortable");
                    AJS.tablessortable.setTableSortable(AJS.$("#delegated-groups-list-table"));
                } else {
                    AJS.$('#delegated-groups-list-table').trigger("update");
                }
                AJS.$('#group-filter').val(searchTerm);
                
            }})

    },
    
    'displayPaginationMessage': function(page, totalSize) {
        if(totalSize > 0) {
            var pageStart = ((page-1) * 20) + 1;
            var pageEnd = page * 20;
            if( pageEnd > totalSize ) {
                pageEnd = totalSize;
            } 
            AJS.$('#delegatedGroupCountMsg').html(
                    AJS.I18n.getText("wittified.delgroup.admin.pagination.msg", pageStart, pageEnd, totalSize)
                   ); 
        } else {
            AJS.$('#delegatedGroupCountMsg').html('');
        }
        
    }
}

window.wittified.delegatedAdmin.groupPicker = function () {
	var contextPath = require('wrm/context-path');
    if(AJS.$('input#wittified-select-group').length == 0 ){
        return;
    }
    var restPath = '/rest/wittified/delegated-groups/1.0/configure/find-all-groups';
    var $element = AJS.$('input#wittified-select-group').auiSelect2({
            multiple: true,
            minimumInputLength: 1,
            dropdownAutoWidth : true,
             ajax: {
                 url: contextPath() + restPath,
                 type: "GET",
                 dataType: 'json',
                 cache: true,
                // query parameters for the remote ajax call
                data: function data(term) {
                    return {
                        query: term,
                        maxResults: 30,
                        exclude:AJS.$('input#wittified-select-group').val()
                    };
                },
                // parse data from the server into form select2 expects
                results: function results(data) {
                    if(data.results == undefined){
                        return {
                            results: []
                        };
                    }
                    return {
                        results: data.results
                    };
                },
             },
             placeholder: "Select a Group",
             id: function id(group) {
                 return group;
                },
            // define how selected element should look like
            formatSelection: function formatSelection(group) {
                return Select2.util.escapeMarkup(group);
            },
            // define how single option should look like
            formatResult: function formatResult(group, container, query, escapeMarkup) {
                // format result string
                var resultText = group;
                return escapeMarkup(group);
            },
            // define message showed when there are no matches
            formatNoMatches: function formatNoMatches(query) {
                return "No matches found";
            },
            initSelection: function(element, callback) {
                // the input tag has a value attribute preloaded that points to a preselected repository's id
                // this function resolves that id attribute to an object that select2 can render
                // using its formatResult renderer - that way the repository name is shown preselected  
                // callback(element.val());
                
                var groups = element.val().split(',');
                element.val("");
                callback(groups);
                return;

            }
        });
        AJS.$('.aui-select2-container .select2-choices .select2-search-field input').css('width','auto');
        
        
} 


AJS.toInit(function()
{
	var contextPath = require('wrm/context-path');
    AJS.$('#dialog-add-group-submit-button').on('click', function(evt)
    {
    	evt.preventDefault();
    	//DELGROUPS-113
        var group = AJS.$('#wittified-select-group').val();
        AJS.$('#wittified-select-group').select2('val', "");
        
        AJS.$('#delegated-groups-list').html('Loading...');
        AJS.dialog2('#add-group-dialog').hide();

         AJS.$.ajax({
            'url': contextPath()+'/rest/wittified/delegated-groups/1.0/configure/add-group',
            'method': 'POST',
            'type':'POST',
            'dataType':'json',

            'contentType': 'application/json',
            'data': JSON.stringify( {
            			'group': group,
            			'startPage':wittified.delegatedAdmin.globalConfig.startPage,
            			'page':wittified.delegatedAdmin.globalConfig.page,
            			'endPage':wittified.delegatedAdmin.globalConfig.endPage,
            			'searchTerm':wittified.delegatedAdmin.globalConfig.groupSearchTerm
            		} ),
            'success': function(result)
            {
            	AJS.$('#delegated-groups-list').html( wittified.templates.delegatedgroups.renderRows( {'groups': result.delegatedGroups} ));
                
                if(result.pageEntity) {
                	AJS.$('#delegatedGroupPagination').html( wittified.templates.delegatedgroups.paginateGroup( {
                    	'size': result.pageEntity.totalSize,
                    	'page': result.pageEntity.page,
                    	'startPage': result.pageEntity.startPage,
                    	'endPage': result.pageEntity.endPage
                    } ));
                	
                	wittified.delegatedAdmin.globalConfig.displayPaginationMessage(result.pageEntity.page, result.pageEntity.totalSize);
                } 
                // DELGROUPS-35 To update tablesorter, an "update" needs to be triggered before it will update its cache
                // Ref : https://stackoverflow.com/questions/13894244/jquery-tablesorter-clear-table-information
                AJS.$('#delegated-groups-list-table').trigger("update");
                //DELGROUPS-42
                AJS.$('#group-filter').val(wittified.delegatedAdmin.globalConfig.groupSearchTerm);
            }
        });

    });

    AJS.$('#delegation-add-group').on('click', function(evt)
    {
        evt.preventDefault();
        AJS.dialog2('#add-group-dialog').show();
        AJS.$('#dialog-add-group-submit-button').attr('disabled','true');
        //DELGROUPS-113
        wittified.delegatedAdmin.groupPicker();
        AJS.$('#wittified-select-group').on('change.select2', function (e) {
            var data = e.target.value;
            if(data !== "") {
                AJS.$('#dialog-add-group-submit-button').removeAttr('disabled');
            } else {
                AJS.$('#dialog-add-group-submit-button').attr('disabled','true');
            }
        });
                   
    });
    
    AJS.$('#delegation-add-first-group').on('click', function(evt)
    {
		evt.preventDefault();
		window.location.href=contextPath()+"/plugins/servlet/wittified/delegated/groups/global?start=no";
	});
	
    AJS.$("#dialog-add-group-cancel-button").off('click').on('click', function (e) {
       e.preventDefault();
       AJS.$('#wittified-select-group').select2('val', "");
       AJS.dialog2("#add-group-dialog").hide();
    });
    
    AJS.$("#dialog-add-owner-user-cancel-button").off('click').on('click', function (e) {
       e.preventDefault();
       AJS.$('#select-owner-user').select2('val', "");
       AJS.$('#select-owner-group').select2('val', "");
       AJS.dialog2("#add-owner-dialog").hide();
    });

    AJS.$('#dialog-add-owner-user-submit-button').on('click', function(evt)
    {
        evt.preventDefault();
        var group = AJS.$('#select-owner-user').data('group');
        var userKey =AJS.$('#select-owner-user').select2('val') + ''; //convert array to string
        
        //DELGROUPS-28
        var groupKey =AJS.$('#select-owner-group').select2('val') + ''; //convert array to string
        
        AJS.$('#delegated-groups-list').html('Loading...');

        AJS.dialog2('#add-owner-dialog').hide();

         AJS.$.ajax({
            'url': contextPath()+'/rest/wittified/delegated-groups/1.0/configure/add-owner',
            'method': 'POST',
            'type':'POST',
            'dataType':'json',

            'contentType': 'application/json',
            
            //DELGROUPS-28
             'data': JSON.stringify( {
            	 		'group': group, 
            	 		'userKey': userKey, 
            	 		'groupKey': groupKey,
            	 		'startPage':wittified.delegatedAdmin.globalConfig.startPage,
            			'page':wittified.delegatedAdmin.globalConfig.page,
            			'endPage':wittified.delegatedAdmin.globalConfig.endPage,
            			'searchTerm':wittified.delegatedAdmin.globalConfig.groupSearchTerm
            	 } ),
            //'data': JSON.stringify( {'group': group, 'userKey': userKey} ),
            'success': function(result)
            {
            	AJS.$('#delegated-groups-list').html( wittified.templates.delegatedgroups.renderRows( {'groups': result.delegatedGroups} ));
                
                if(result.pageEntity) {
                	AJS.$('#delegatedGroupPagination').html( wittified.templates.delegatedgroups.paginateGroup( {
                    	'size': result.pageEntity.totalSize,
                    	'page': result.pageEntity.page,
                    	'startPage': result.pageEntity.startPage,
                    	'endPage': result.pageEntity.endPage
                    } ));
                	
                }
                AJS.$('#delegated-groups-list-table').trigger("update");
                //DELGROUPS-57
                AJS.$('#select-owner-user').select2('val', "");
                AJS.$('#select-owner-group').select2('val', "");
                //DELGROUPS-42
                AJS.$('#group-filter').val(wittified.delegatedAdmin.globalConfig.groupSearchTerm)
            }
        });

    });
    AJS.$('.delegation-add-owner-user').live('click', function(evt)
    {
        evt.preventDefault();
        var group = AJS.$(this).data('delegationid');
        
        AJS.$('#select-owner-user').data('group', group);
        AJS.dialog2('#add-owner-dialog').show();
        
        AJS.$('#dialog-add-owner-user-submit-button').attr('disabled','true');
        
        
        AJS.$("#select-owner-user").auiSelect2({
            placeholder:"Add a user as owner",
            ajax: {
                data: function (params)
                {
                    return  {
                        query: params,
                        group: group
                    }
                },
                url: contextPath()+'/rest/wittified/delegated-groups/1.0/configure/find-users',
                results: function (data)
                {
                    var select2data = $.map(data, function(obj) {
                        obj.id = obj.userKey;
                        obj.text = obj.displayName;
                        return obj;
                      });
                      
                    AJS.$('#dialog-add-owner-user-submit-button').removeAttr('disabled');
                    return {results:select2data};
                },
                cache:true
            },
            
             minimumInputLength: 1,
             multiple:true
             
        });
        AJS.$('#select-owner-user').placeholder="Add a user as owner";
        AJS.$('#select-owner-group').placeholder="Add a group as owner";
         //DELGROUPS-28
        AJS.$("#select-owner-group").auiSelect2({
            
              placeholder: "Add a group as owner",
              
                ajax: {
                data: function (params)
                {
                    return  {
                        search: params,
                        group: group
                    }
                },
                url: contextPath()+'/rest/wittified/delegated-groups/1.0/configure/find-all-groups-contain',
                results: function (data_)
                {
                    var obj = [];
                    $.each(data_, function(str,str) {

                        obj.push({id:str, text:str});
                        return obj;
                          
                      });
                     
                     AJS.$('#dialog-add-owner-user-submit-button').removeAttr('disabled');
                   
                    return {results:obj};
                },
                cache:true
            },
            
             minimumInputLength: 1,
             multiple:true
          });
            AJS.$('#select-owner-user').placeholder="Add a user as owner";
            AJS.$('#select-owner-group').placeholder="Add a group as owner";
            
            $("#select-owner-group").on("select2-opening", function() {
                $(":focus").blur();
            });

            $("#select-owner-group").on("select2-open", function() {
                setTimeout(function(){
                    $("div.select2-drop:visible div.select2-search input.select2-input").focus();
                }, 100);
            });
           
           //
    });
    var delegationGroup = '';
    AJS.$('.delegation-remove-group').live('click', function(evt)
    {
        evt.preventDefault();
        delegationGroup = AJS.$(this).data('delegationid');
        AJS.dialog2("#stop-delegation-confirm-dialog").show();
        AJS.$("#stop-delegation-dialog-header").html('<p>'
                + AJS.I18n.getText('wittified.delgroup.stop.delegatation.confirm.header', delegationGroup) + '</p>');
    });
    
    AJS.$('#dialog-stop-delegation-confirm-button').on('click', function(evt)
    	    {
    	       evt.preventDefault();
	           AJS.$.ajax({
	                    'url': contextPath()+'/rest/wittified/delegated-groups/1.0/configure/remove-group-delegation',
	                    'method': 'DELETE',
	                    'type':'DELETE',
	                    'dataType':'json',

	                    'contentType': 'application/json',
	                    'data': JSON.stringify( {
	                    	'group': delegationGroup,
	                    	'startPage':wittified.delegatedAdmin.globalConfig.startPage,
	            			'page':wittified.delegatedAdmin.globalConfig.page,
	            			'endPage':wittified.delegatedAdmin.globalConfig.endPage,
	            			'searchTerm':wittified.delegatedAdmin.globalConfig.groupSearchTerm
	                    	} ),
	                    'success': function(result)
	                    {
	                    	AJS.dialog2("#stop-delegation-confirm-dialog").hide();
	                    	AJS.$('#delegated-groups-list').html( wittified.templates.delegatedgroups.renderRows( {'groups': result.delegatedGroups} ));
	                    	
	                        if(result.pageEntity) {
	                        	AJS.$('#delegatedGroupPagination').html( wittified.templates.delegatedgroups.paginateGroup( {
	                            	'size': result.pageEntity.totalSize,
	                            	'page': result.pageEntity.page,
	                            	'startPage': result.pageEntity.startPage,
	                            	'endPage': result.pageEntity.endPage
	                            } ));
	                        	
	                        	wittified.delegatedAdmin.globalConfig.displayPaginationMessage(result.pageEntity.page, result.pageEntity.totalSize);
	                        } 
	                     // DELGROUPS-35 To update tablesorter, an "update" needs to be triggered before it will update its cache
	                        AJS.$('#delegated-groups-list-table').trigger("update");
	                        //DELGROUPS-42
	                        AJS.$('#group-filter').val(wittified.delegatedAdmin.globalConfig.groupSearchTerm);
	                    }
	                });
    	    });
    
    AJS.$("#dialog-stop-delegation-cancel-button").on("click",  function (e) {
        e.preventDefault();
        AJS.dialog2("#stop-delegation-confirm-dialog").hide();
    });

    AJS.$('.remove-owner-from-group').live('click', function(evt)
    {
        evt.preventDefault();
        
        delegationGroup = AJS.$(this).data('group');
        var key = AJS.$(this).data('key');
        var displayName = AJS.$(this).data('displayname');
       
        //DELGROUPS-28
        var isGroupOwner = AJS.$(this).data('isgroupowner');
        
        //open confirmation dialog
        AJS.dialog2("#remove-owner-dialog").show();
        AJS.$("#remove-owner-dialog-header").html('<p>'
                + AJS.I18n.getText('wittified.delgroup.remove.delegation.owner.confirm.header') + '</p>');
		AJS.$("#remove-owner-dialog-content-msg").html('<p>'+AJS.I18n.getText('wittified.delgroup.remove.delegation.owner.dialog.content', displayName) +' <b>'+delegationGroup+'</b></p>');
		
		AJS.$("#groupForRemove")[0].value=delegationGroup;
		AJS.$("#keyForRemove")[0].value=key;
		AJS.$("#isGroupOwnerForRemove")[0].value=isGroupOwner;
		
    });
    
    AJS.$("#dialog-remove-owner-cancel-button").on("click",  function (e) {
        e.preventDefault();
        AJS.dialog2("#remove-owner-dialog").hide();
    });
    
    AJS.$("#dialog-remove-owner-confirm-button").on("click",  function (e) {
        e.preventDefault();
        
        var selection = $('input[name="remove-owner-confirm"]:checked').val();
        
        var group =AJS.$("#groupForRemove")[0].value;
		var key =AJS.$("#keyForRemove")[0].value;
		var isGroupOwner =AJS.$("#isGroupOwnerForRemove")[0].value;
		
        var groupKey =null;
        var userKey =null;
        if(isGroupOwner==="true"){
            groupKey = key;
            userKey = null;
        }else{
            groupKey=null;
            userKey = key;
        }
		if(selection === 'single') {
	        //        
	         AJS.$.ajax({
	            'url': contextPath()+'/rest/wittified/delegated-groups/1.0/configure/remove-owner',
	            'method': 'DELETE',
	            'type':'DELETE',
	            'dataType':'json',
	
	            'contentType': 'application/json',
	            //'data': JSON.stringify( {'group': group, 'userKey': key} ),
	            //DELGROUPS-28
	            'data': JSON.stringify( {
	            			'group': group, 
	            			'userKey': userKey, 
	            			'groupKey': groupKey,
	            			'startPage':wittified.delegatedAdmin.globalConfig.startPage,
	            			'page':wittified.delegatedAdmin.globalConfig.page,
	            			'endPage':wittified.delegatedAdmin.globalConfig.endPage,
	            			'searchTerm':wittified.delegatedAdmin.globalConfig.groupSearchTerm
	            	} ),
	            //
	            'success': function(result)
	            {
					AJS.dialog2("#remove-owner-dialog").hide();
	            	AJS.$('#delegated-groups-list').html( wittified.templates.delegatedgroups.renderRows( {'groups': result.delegatedGroups} ));
	                
	                if(result.pageEntity) {
	                	AJS.$('#delegatedGroupPagination').html( wittified.templates.delegatedgroups.paginateGroup( {
	                    	'size': result.pageEntity.totalSize,
	                    	'page': result.pageEntity.page,
	                    	'startPage': result.pageEntity.startPage,
	                    	'endPage': result.pageEntity.endPage
	                    } ));
	                	
	                } 
	             // DELGROUPS-35 To update tablesorter, an "update" needs to be triggered before it will update its cache
	                AJS.$('#delegated-groups-list-table').trigger("update");
	                //DELGROUPS-42
	                AJS.$('#group-filter').val(wittified.delegatedAdmin.globalConfig.groupSearchTerm);
	            }
	        });
        } else if(selection === 'allGroups') {
			//        
	         AJS.$.ajax({
	            'url': contextPath()+'/rest/wittified/delegated-groups/1.0/configure/bulk-remove-owner',
	            'method': 'DELETE',
	            'type':'DELETE',
	            'dataType':'json',
	
	            'contentType': 'application/json',
	            //'data': JSON.stringify( {'group': group, 'userKey': key} ),
	            //DELGROUPS-28
	            'data': JSON.stringify( {
	            			'group': group, 
	            			'userKey': userKey, 
	            			'groupKey': groupKey,
	            			'startPage':wittified.delegatedAdmin.globalConfig.startPage,
	            			'page':wittified.delegatedAdmin.globalConfig.page,
	            			'endPage':wittified.delegatedAdmin.globalConfig.endPage,
	            			'searchTerm':wittified.delegatedAdmin.globalConfig.groupSearchTerm
	            	} ),
	            //
	            'success': function(result)
	            {
					AJS.dialog2("#remove-owner-dialog").hide();
	            	AJS.$('#delegated-groups-list').html( wittified.templates.delegatedgroups.renderRows( {'groups': result.delegatedGroups} ));
	                
	                if(result.pageEntity) {
	                	AJS.$('#delegatedGroupPagination').html( wittified.templates.delegatedgroups.paginateGroup( {
	                    	'size': result.pageEntity.totalSize,
	                    	'page': result.pageEntity.page,
	                    	'startPage': result.pageEntity.startPage,
	                    	'endPage': result.pageEntity.endPage
	                    } ));
	                	
	                } 
	             // DELGROUPS-35 To update tablesorter, an "update" needs to be triggered before it will update its cache
	                AJS.$('#delegated-groups-list-table').trigger("update");
	                //DELGROUPS-42
	                AJS.$('#group-filter').val(wittified.delegatedAdmin.globalConfig.groupSearchTerm);
	            }
	        });
		}
    });

    //DELGROUPS-42 : search groups
    AJS.$("#group-filter-submit").on('click', function(evt){
        evt.preventDefault();
        var group = AJS.$(this).data('group');
        var groupSearchTerm = AJS.$('#group-filter').val();
        wittified.delegatedAdmin.globalConfig.load(false, 1, 1, -1, groupSearchTerm);
    });

    wittified.delegatedAdmin.globalConfig.load(true, 1,1,-1, '');
    
    var groups = AJS.$(this).data('group');
    AJS.$("#excludeGroupsSelector").auiSelect2({
            placeholder:"Select a Group/s",
            ajax: {
                data: function (params)
                {
                    return  {
                        search: params,
                        group: groups
                    }
                },
                url: contextPath()+'/rest/wittified/delegated-groups/1.0/configure/find-all-groups-contain-for-exclude',
                results: function (data_)
                {
                    var obj = [];
                    $.each(data_, function(str,str) {

                        obj.push({id:str, text:str});
                        return obj;
                          
                      });
                     
                    return {results:obj};
                },
                cache:true
            },
            initSelection : function (element, callback) {
				var data = [];
				$(element.val().split(",")).each(function () {
				data.push({id: this, text: this});
				});
				callback(data);
			},
            formatNoMatches: function formatNoMatches(query) {
                return "No matches found";
            },
             minimumInputLength: 1,
             multiple:true,
             dropdownAutoWidth : true
        });
        
        AJS.$("#whiteListOnOff").off('click').on('click', function(evt){
        evt.preventDefault();
        var whitelistOnOffVal = AJS.$('#whiteListOnOff')[0].checked;
        if(whitelistOnOffVal){
        	document.getElementById('whitelistSettingsDiv').style.display="block";
        }else{
        	document.getElementById('whitelistSettingsDiv').style.display="none";
        	AJS.$('#includeRadio').attr('checked', false);
        	AJS.$('#excludeRadio').attr('checked', false);
        	AJS.$('#whiteListedDomains').value="";
        }
        
    });
});