/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.servlets;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.wittified.general.support.SupportBarService;
import com.wittified.groupadmin.analytics.DelGroupsAnalytics;
import com.wittified.groupadmin.analytics.EventType;
import java.io.IOException;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GeneralConfigurationServlet
extends HttpServlet {
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final PageBuilderService pageBuilderService;
    private final SupportBarService supportBarService;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final HttpContext httpContext;
    private final DelGroupsAnalytics delGroupsAnalytics;

    public GeneralConfigurationServlet(SoyTemplateRenderer soyTemplateRenderer, PageBuilderService pageBuilderService, SupportBarService supportBarService, PluginLicenseManager pluginLicenseManager, UserManager userManager, PluginSettingsFactory pluginSettingsFactory, HttpContext httpContext, DelGroupsAnalytics delGroupsAnalytics) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.pageBuilderService = pageBuilderService;
        this.supportBarService = supportBarService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.httpContext = httpContext;
        this.delGroupsAnalytics = delGroupsAnalytics;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.userManager.getRemoteUser() == null) {
            resp.sendError(404);
            return;
        }
        if (!this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            resp.sendError(404);
            return;
        }
        String sendStatistics = req.getParameter("sendStatistics");
        sendStatistics = sendStatistics == null ? "off" : sendStatistics;
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.delegated.group.global.configuration.analytics", (Object)sendStatistics);
        if (sendStatistics.equalsIgnoreCase("off")) {
            WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
            WeakHashMap<String, Boolean> configMap = new WeakHashMap<String, Boolean>();
            configMap.put("sendStatistics", false);
            eventDataMap.put("type", EventType.GENERAL_CONFIG.toString());
            eventDataMap.put("settings", configMap);
            this.delGroupsAnalytics.postEventInfo(EventType.GENERAL_CONFIG, eventDataMap);
        }
        String excludeGroups = req.getParameter("excludeGroupsSelector");
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.delegated.group.global.configuration.excludeGroups", (Object)excludeGroups);
        String whiteListOnOff = req.getParameter("whiteListOnOff");
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.delegated.group.global.configuration.whiteListOnOff", (Object)whiteListOnOff);
        String whiteListedDomains = req.getParameter("whiteListedDomains");
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.delegated.group.global.configuration.whiteListedDomains", (Object)(whiteListOnOff == null || whiteListOnOff != null && whiteListOnOff.equalsIgnoreCase("off") ? "" : whiteListedDomains));
        String whitelistRadio = req.getParameter("whitelistRadio");
        this.pluginSettingsFactory.createGlobalSettings().put("wittified.delegated.group.global.configuration.whitelist.whitelistRadio", (Object)whitelistRadio);
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.userManager.getRemoteUser() == null) {
            res.sendError(404);
            return;
        }
        if (!this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            res.sendError(404);
            return;
        }
        String licenseMessage = null;
        if (this.pluginLicenseManager.getLicense() == null || !this.pluginLicenseManager.getLicense().isDefined()) {
            licenseMessage = "Delegated Group Management requires a license in order to function. No valid license was found.";
        } else if (this.pluginLicenseManager.getLicense().get() != null && !((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() && ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
            licenseMessage = ((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name().equalsIgnoreCase(LicenseError.EXPIRED.toString()) ? "License has expired. Please visit the Atlassian Marketplace to renew" : (((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name().equalsIgnoreCase(LicenseError.TYPE_MISMATCH.toString()) ? "Add-on License Type does not match product license type" : (((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name().equalsIgnoreCase(LicenseError.USER_MISMATCH.toString()) ? "User count for add-on license does not match product license user count" : (((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name().equalsIgnoreCase(LicenseError.VERSION_MISMATCH.toString()) ? "Version mismatch for license" : ((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).name())));
        }
        WeakHashMap<String, String> context = new WeakHashMap<String, String>();
        if (licenseMessage == null) {
            try {
                this.pageBuilderService.assembler().resources().requireWebResource(this.pluginLicenseManager.getPluginKey() + ":atl.general");
                this.pageBuilderService.assembler().resources().requireWebResource(this.pluginLicenseManager.getPluginKey() + "delegated-group-admin-resources").requireContext("delegated-group-admin");
                context.put("supportBar", this.supportBarService.getHtml());
                String sendStatistics = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.analytics");
                context.put("sendStatistics", sendStatistics == null ? "on" : sendStatistics);
                context.put("contextPath", this.httpContext.getRequest().getContextPath());
                String excludeGroups = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.excludeGroups");
                context.put("excludeGroups", excludeGroups);
                String whiteListOnOff = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whiteListOnOff");
                context.put("whiteListOnOff", whiteListOnOff == null ? "off" : whiteListOnOff);
                String whiteListedDomains = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whiteListedDomains");
                context.put("whiteListedDomains", whiteListedDomains == null ? "" : whiteListedDomains);
                String includeOrExclude = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.whitelist.whitelistRadio");
                context.put("includeOrExclude", includeOrExclude == null ? "" : includeOrExclude);
                res.setContentType("text/html");
                this.soyTemplateRenderer.render((Appendable)res.getWriter(), this.pluginLicenseManager.getPluginKey() + ":delegated-group-admin-resources", "wittified.templates.delegatedgroups.general.configurations.renderConfig", context);
            }
            catch (Exception wes) {
                wes.getStackTrace();
            }
        } else {
            context.put("licenseMessage", licenseMessage);
            this.soyTemplateRenderer.render((Appendable)res.getWriter(), this.pluginLicenseManager.getPluginKey() + ":delegated-group-admin-resources", "wittified.templates.delegatedgroups.errorPage", context);
        }
    }
}

