/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.servlets;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.wittified.groupadmin.ao.Delegation;
import com.wittified.groupadmin.ao.DelegationService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDelegatedGroup
extends HttpServlet {
    private static final long serialVersionUID = -9019919668940135048L;
    private final UserManager userManager;
    private static final Logger logger = LoggerFactory.getLogger(UpdateDelegatedGroup.class);
    private final TemplateRenderer templateRenderer;
    private final DelegationService delegationService;

    public UpdateDelegatedGroup(UserManager userManager, TemplateRenderer templateRenderer, DelegationService delegationService) {
        this.userManager = userManager;
        this.delegationService = delegationService;
        this.templateRenderer = templateRenderer;
    }

    @HtmlSafe
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.userManager.getRemoteUser() == null) {
            resp.sendError(404);
            return;
        }
        if (!this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            resp.sendError(404);
            return;
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("uiLog", this.doUpdateDelegatedGroup());
        this.templateRenderer.render("/templates/updateDelegationGroup.vm", context, (Writer)resp.getWriter());
    }

    private String doUpdateDelegatedGroup() {
        LogManager.getLogger("com.wittified").setLevel(Level.INFO);
        List<Delegation> delegationObjs = this.delegationService.getAllDelegatedGroups();
        for (Delegation delegation : delegationObjs) {
            this.delegationService.removeGroupDelegation(delegation.getGroupObj());
        }
        int count = 0;
        StringBuilder uiLog = new StringBuilder("<table border=1><tr><th>Delegated Group</th><th>UserKey</th><th>GroupKey</th></tr>");
        for (Delegation delegation : delegationObjs) {
            String delegatedGroup = delegation.getGroupObj();
            uiLog.append("<tr><td>" + delegatedGroup + "</td>");
            logger.info("Removed delegated group and it's owners from delegated group table : " + delegatedGroup);
            this.delegationService.addGroupDelegation(delegatedGroup);
            logger.info("Added group into delegated group table : " + delegatedGroup + "</br>\n");
            String userKey = delegation.getUserKey();
            String groupOwnerName = delegation.getGroupKey();
            if (StringUtils.isNotBlank(userKey)) {
                uiLog.append("<td>" + userKey + "</td>");
                this.delegationService.addUserOwner(delegatedGroup, userKey);
            } else {
                uiLog.append("<td></td>");
            }
            if (StringUtils.isNotBlank(groupOwnerName)) {
                uiLog.append("<td>" + groupOwnerName + "</td>");
                this.delegationService.addGroupOwner(delegatedGroup, groupOwnerName);
            } else {
                uiLog.append("<td></td>");
            }
            logger.info("Migrated record : " + ++count);
            uiLog.append("</tr>");
        }
        LogManager.getLogger("com.wittified").setLevel(null);
        uiLog.append("</table>");
        return uiLog.toString();
    }
}

