/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.services;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import com.wittified.groupadmin.product.DelegatedUser;
import com.wittified.groupadmin.product.ProductService;
import com.wittified.groupadmin.rest.PagerEntity;
import com.wittified.groupadmin.services.DelegatedGroupCommonService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DelegatedGroupCommonServiceImpl
implements DelegatedGroupCommonService {
    private final Cache<String, List<User>> userCache;
    private final CacheManager cacheManager;
    private final ProductService productService;
    private final CrowdService crowdService;
    private final UserManager userManager;
    private final CrowdDirectoryService crowdDirectoryService;

    public DelegatedGroupCommonServiceImpl(CacheManager cacheManager, ProductService productService, CrowdService crowdService, UserManager userManager, CrowdDirectoryService crowdDirectoryService) {
        this.cacheManager = cacheManager;
        this.productService = productService;
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.crowdDirectoryService = crowdDirectoryService;
        this.userCache = cacheManager.getCache(DelegatedGroupCommonServiceImpl.class.getName() + ".cache", (CacheLoader)new ListUserCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());
    }

    @Override
    public int getPagePosition(Integer startPage, Integer page, Integer endPage) {
        int sum = 0;
        int middleNo = 0;
        for (int i = startPage.intValue(); i <= endPage; ++i) {
            sum += i;
        }
        middleNo = sum / 5;
        if (page == middleNo) {
            return 0;
        }
        if (page > middleNo && page == endPage) {
            return 2;
        }
        if (page > middleNo && page < endPage) {
            return 1;
        }
        if (page < middleNo && page == startPage) {
            return -2;
        }
        if (page < middleNo && page > startPage) {
            return -1;
        }
        return 0;
    }

    @Override
    public PagerEntity positionThePager(int startPage, int page, int endPage, int totalItems, int pageSize) {
        int totalPages = (int)Math.ceil((float)totalItems / (float)pageSize);
        PagerEntity pager = new PagerEntity();
        pager.setTotalSize(totalItems);
        pager.setPage(page);
        if (endPage == -1) {
            endPage = totalPages >= 5 ? 5 : totalPages;
            pager.setStartPage(1);
            pager.setEndPage(endPage);
            return pager;
        }
        int position = this.getPagePosition(startPage, page, endPage);
        if (position == 0 || page == 1 || page == totalPages) {
            pager.setStartPage(startPage);
            pager.setEndPage(endPage);
        } else if (position == -1) {
            if (page - 1 == 1) {
                pager.setStartPage(startPage);
                pager.setEndPage(endPage);
            } else {
                pager.setStartPage(startPage - 1);
                pager.setEndPage(endPage - 1);
            }
        } else if (position == -2) {
            if (page - 1 == 1) {
                pager.setStartPage(startPage - 1);
                pager.setEndPage(endPage - 1);
            } else {
                pager.setStartPage(startPage - 2);
                pager.setEndPage(endPage - 2);
            }
        } else if (position == 1) {
            if (page + 1 == totalPages) {
                pager.setStartPage(startPage);
                pager.setEndPage(endPage);
            } else {
                pager.setStartPage(startPage + 1);
                pager.setEndPage(endPage + 1);
            }
        } else if (position == 2) {
            if (page + 1 == totalPages) {
                pager.setStartPage(startPage + 1);
                pager.setEndPage(endPage + 1);
            } else {
                pager.setStartPage(startPage + 2);
                pager.setEndPage(endPage + 2);
            }
        } else {
            pager.setStartPage(startPage);
            pager.setEndPage(endPage);
        }
        return pager;
    }

    @Override
    public List<DelegatedUser> filterUsersInGroup(String groupName, String searchTerm) {
        List users = (List)this.userCache.get((Object)groupName);
        return users.stream().filter(user -> user != null && (user.getName().toLowerCase().contains(searchTerm.toLowerCase()) || user.getDisplayName().toLowerCase().contains(searchTerm.toLowerCase()) || user.getEmailAddress().toLowerCase().contains(searchTerm.toLowerCase()))).map(user -> this.convert((User)user, groupName)).collect(Collectors.toList());
    }

    @Override
    public Cache<String, List<User>> getUserCache() {
        return this.userCache;
    }

    List<User> renderUserList(String groupName) {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
        Iterable result = this.crowdService.search((Query)query);
        return Lists.newArrayList((Iterable)result);
    }

    @Override
    public List<DelegatedUser> getUsersInGroup(String group, int page) {
        ArrayList<DelegatedUser> delegatedUsers = new ArrayList<DelegatedUser>();
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(group).startingAt((page - 1) * 10).returningAtMost(10);
        Iterable result = this.crowdService.search((Query)query);
        result.forEach(user -> delegatedUsers.add(this.convert((User)user, group)));
        return delegatedUsers;
    }

    private DelegatedUser convert(User user, String groupName) {
        String key = null;
        UserProfile userProfile = this.userManager.getUserProfile(user.getName());
        if (userProfile != null) {
            key = userProfile.getUserKey().getStringValue();
        }
        DelegatedUser delegatedUser = null;
        if (this.productService.getApplicationType().equals("JIRA")) {
            String avatarUrl = this.productService.getAvatarUrl(key);
            boolean isFromNestedGroup = this.productService.isFromNestedGroup(key, groupName);
            delegatedUser = new DelegatedUser(key, user.getDisplayName(), user.getName(), user.getEmailAddress(), true, this.isUserReadOnly(user.getDirectoryId()), avatarUrl, isFromNestedGroup, true);
        } else {
            delegatedUser = new DelegatedUser(key, user.getDisplayName(), user.getName(), user.getEmailAddress(), true, this.isUserReadOnly(user.getDirectoryId()));
            delegatedUser.setUserAvatar(this.productService.getAvatarUrl(user.getName()));
        }
        delegatedUser.setActive(user.isActive());
        return delegatedUser;
    }

    private boolean isUserReadOnly(long directoryId) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        if (directory != null) {
            return !directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
        }
        return false;
    }

    private class ListUserCacheLoader
    implements CacheLoader<String, List<User>> {
        private ListUserCacheLoader() {
        }

        public List<User> load(@Nonnull String groupName) {
            return DelegatedGroupCommonServiceImpl.this.renderUserList(groupName);
        }
    }
}

