/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.CacheManager;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.wittified.groupadmin.ao.Delegation;
import com.wittified.groupadmin.ao.DelegationGroup;
import com.wittified.groupadmin.ao.DelegationService;
import com.wittified.groupadmin.ao.FavoriteUserOwner;
import com.wittified.groupadmin.ao.GroupOwner;
import com.wittified.groupadmin.ao.UserOwner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegationServiceImpl
implements DelegationService {
    private final TransactionTemplate transactionTemplate;
    private final ActiveObjects activeObjects;
    private final UserManager userManager;
    private final CacheManager cacheManager;
    private static Logger logger = LoggerFactory.getLogger(DelegationServiceImpl.class);

    public DelegationServiceImpl(TransactionTemplate transactionTemplate, ActiveObjects activeObjects, UserManager userManager, CacheManager cacheManager) {
        this.transactionTemplate = transactionTemplate;
        this.activeObjects = activeObjects;
        this.userManager = userManager;
        this.cacheManager = cacheManager;
    }

    @Override
    public boolean hasGroupDelegation(String delegatedGroup, final String userOwnerKey, final String groupOwnerName) {
        final DelegationGroup[] delegationGroups = (DelegationGroup[])this.activeObjects.find(DelegationGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{delegatedGroup}));
        if (delegationGroups.length == 0) {
            return false;
        }
        final DelegationServiceImpl impl = this;
        if (StringUtils.isBlank(groupOwnerName) && !StringUtils.isBlank(userOwnerKey)) {
            return (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction() {
                    if (((UserOwner[])DelegationServiceImpl.this.activeObjects.find(UserOwner.class, Query.select().where(" OWNER_KEY = ? AND DELEGATION_GROUP_ID = ? ", new Object[]{userOwnerKey, delegationGroups[0].getID()}))).length > 0) {
                        return true;
                    }
                    return impl.getDelegatedGrpsFromGrpOwner(userOwnerKey).contains(delegationGroups[0].getGroupName());
                }
            });
        }
        if (!StringUtils.isBlank(groupOwnerName) && StringUtils.isBlank(userOwnerKey)) {
            return (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction() {
                    return ((GroupOwner[])DelegationServiceImpl.this.activeObjects.find(GroupOwner.class, Query.select().where(" OWNER_NAME = ? AND DELEGATION_GROUP_ID = ? ", new Object[]{groupOwnerName, delegationGroups[0].getID()}))).length > 0;
                }
            });
        }
        return false;
    }

    @Override
    public void addGroupDelegation(String groupName) {
        String[] groups;
        this.cacheManager.getCache("wittified-groups-admin").removeAll();
        for (final String grp : groups = groupName.split(",")) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    DelegationGroup[] delegationGroups = (DelegationGroup[])DelegationServiceImpl.this.activeObjects.find(DelegationGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{grp}));
                    if (delegationGroups.length == 0) {
                        DelegationGroup delegationGroup = (DelegationGroup)DelegationServiceImpl.this.activeObjects.create(DelegationGroup.class, new DBParam[0]);
                        delegationGroup.setGroupName(grp);
                        delegationGroup.setLowerGroupName(grp.toLowerCase());
                        delegationGroup.save();
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void addGroupDelegationOld(String groupName, final String user) {
        String[] groups;
        this.cacheManager.getCache("wittified-groups-admin").removeAll();
        for (final String grp : groups = groupName.split(",")) {
            if (this.hasGroupDelegation(grp, user, null)) continue;
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    Delegation delegation = (Delegation)DelegationServiceImpl.this.activeObjects.create(Delegation.class, new DBParam[0]);
                    delegation.setGroupObj(grp);
                    delegation.setUserKey(user);
                    delegation.save();
                    return null;
                }
            });
        }
    }

    @Override
    public void addGroupOwnerDelegationOld(final String groupName, final String ownerGroup) {
        this.cacheManager.getCache("wittified-groups-admin").removeAll();
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                int numItemsGroup;
                if (ownerGroup != null && ownerGroup.trim().length() > 0 && (numItemsGroup = ((Delegation[])DelegationServiceImpl.this.activeObjects.find(Delegation.class, Query.select().where(" GROUP_OBJ = ? AND GROUP_KEY = ? ", new Object[]{groupName, ownerGroup}))).length) == 0) {
                    Delegation delegation2 = (Delegation)DelegationServiceImpl.this.activeObjects.create(Delegation.class, new DBParam[0]);
                    delegation2.setGroupObj(groupName);
                    delegation2.setGroupKey(ownerGroup);
                    delegation2.save();
                    logger.debug("Delegation2 AO - " + delegation2.toString());
                }
                return null;
            }
        });
    }

    @Override
    public void removeGroupDelegationOld(final String groupName, final String user) {
        if (this.hasGroupDelegation(groupName, user, null)) {
            this.cacheManager.getCache("wittified-groups-admin").removeAll();
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    DelegationServiceImpl.this.activeObjects.delete(DelegationServiceImpl.this.activeObjects.find(Delegation.class, Query.select().where(" GROUP_OBJ = ? AND USER_KEY = ? ", new Object[]{groupName, user})));
                    return null;
                }
            });
        }
    }

    @Override
    public void removeGroupDelegationOld(final String groupName, final String user, final String ownerGroup) {
        if (this.hasGroupDelegation(groupName, user, ownerGroup)) {
            this.cacheManager.getCache("wittified-groups-admin").removeAll();
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    if (user != null && user.trim().length() > 0 && (ownerGroup == null || ownerGroup != null && ownerGroup.trim().length() == 0)) {
                        DelegationServiceImpl.this.activeObjects.delete(DelegationServiceImpl.this.activeObjects.find(Delegation.class, Query.select().where(" GROUP_OBJ = ? AND USER_KEY = ? ", new Object[]{groupName, user})));
                    } else if (ownerGroup != null && ownerGroup.trim().length() > 0 && (user == null || user != null & user.trim().length() == 0)) {
                        DelegationServiceImpl.this.activeObjects.delete(DelegationServiceImpl.this.activeObjects.find(Delegation.class, Query.select().where(" GROUP_OBJ = ? AND GROUP_KEY = ? ", new Object[]{groupName, ownerGroup})));
                    } else if (ownerGroup != null && ownerGroup.trim().length() > 0 && user != null && user.trim().length() > 0) {
                        DelegationServiceImpl.this.activeObjects.delete(DelegationServiceImpl.this.activeObjects.find(Delegation.class, Query.select().where(" GROUP_OBJ = ? AND USER_KEY = ? ", new Object[]{groupName, user})));
                        DelegationServiceImpl.this.activeObjects.delete(DelegationServiceImpl.this.activeObjects.find(Delegation.class, Query.select().where(" GROUP_OBJ = ? AND GROUP_KEY = ? ", new Object[]{groupName, ownerGroup})));
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void removeGroupDelegationOld(final String groupName) {
        this.cacheManager.getCache("wittified-groups-admin").removeAll();
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                DelegationServiceImpl.this.activeObjects.delete(DelegationServiceImpl.this.activeObjects.find(Delegation.class, Query.select().where(" GROUP_OBJ = ?  ", new Object[]{groupName})));
                return null;
            }
        });
    }

    @Override
    public void removeGroupDelegation(final String groupName) {
        this.cacheManager.getCache("wittified-groups-admin").removeAll();
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                DelegationGroup[] delegationGroups;
                for (DelegationGroup delegationGroup : delegationGroups = (DelegationGroup[])DelegationServiceImpl.this.activeObjects.find(DelegationGroup.class, Query.select().where(" GROUP_NAME = ?  ", new Object[]{groupName}))) {
                    DelegationServiceImpl.this.activeObjects.delete((RawEntity[])delegationGroup.getUserOwners());
                    DelegationServiceImpl.this.activeObjects.delete((RawEntity[])delegationGroup.getGroupOwners());
                }
                DelegationServiceImpl.this.activeObjects.delete((RawEntity[])delegationGroups);
                return null;
            }
        });
    }

    @Override
    public List<String> getGroupDelegation(final String userKey) {
        final DelegationServiceImpl impl = this;
        final List<String> delegatedGroupsForUser = this.getDelegatedGrpsFromGrpOwner(userKey);
        return (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<String>>(){

            public List<String> doInTransaction() {
                ArrayList<String> groupNames = new ArrayList<String>();
                for (UserOwner userOwner : (UserOwner[])DelegationServiceImpl.this.activeObjects.find(UserOwner.class, Query.select().where(" OWNER_KEY = ?", new Object[]{userKey}))) {
                    if (!impl.doesGroupExist(userOwner.getDelegationGroup().getGroupName())) continue;
                    groupNames.add(userOwner.getDelegationGroup().getGroupName());
                }
                groupNames.addAll(delegatedGroupsForUser);
                groupNames = new ArrayList(new HashSet(groupNames));
                Collections.sort(groupNames);
                return groupNames;
            }
        });
    }

    @Override
    public DelegationGroup[] getDelegatedGroup(String groupName) {
        return (DelegationGroup[])this.activeObjects.find(DelegationGroup.class, Query.select().where(" GROUP_NAME = ?", new Object[]{groupName}));
    }

    @Override
    public List<DelegationGroup> getDelegationGroupObjs(List<String> groupNames) {
        ArrayList<DelegationGroup> delGroupObjs = new ArrayList<DelegationGroup>();
        for (String groupName : groupNames) {
            delGroupObjs.add(this.getDelegatedGroup(groupName).length > 0 ? this.getDelegatedGroup(groupName)[0] : null);
        }
        return delGroupObjs;
    }

    @Override
    public List<Delegation> getAllDelegatedGroups() {
        return this.updateGroups((List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<Delegation>>(){

            public List<Delegation> doInTransaction() {
                return Arrays.asList(DelegationServiceImpl.this.activeObjects.find(Delegation.class, Query.select().order("GROUP_OBJ ASC")));
            }
        }));
    }

    private List<String> getDelegatedGrpsFromGrpOwner(String userKey) {
        List groupOwnerObjs = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                return Arrays.asList(DelegationServiceImpl.this.activeObjects.find(GroupOwner.class));
            }
        });
        UserProfile uProfile = this.userManager.getUserProfile(new UserKey(userKey));
        UserKey uKey = uProfile != null ? uProfile.getUserKey() : null;
        List<String> delegatedGroupsForUser = new ArrayList<String>();
        if (uKey != null) {
            DelegationServiceImpl impl = this;
            delegatedGroupsForUser = groupOwnerObjs.stream().filter(groupOwner -> this.userManager.isUserInGroup(uKey, groupOwner.getOwnerName()) && impl.doesGroupExist(groupOwner.getDelegationGroup().getGroupName())).map(groupOwner -> groupOwner.getDelegationGroup().getGroupName()).distinct().collect(Collectors.toList());
        }
        return delegatedGroupsForUser;
    }

    @Override
    public List<String> getAllOwnerGroups() {
        List delegationObjs = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                return Arrays.asList(DelegationServiceImpl.this.activeObjects.find(Delegation.class, Query.select().where(" GROUP_KEY IS NOT NULL", new Object[0])));
            }
        });
        List delGroups = delegationObjs.stream().map(delObj -> delObj.getGroupKey()).collect(Collectors.toList());
        List<String> ownerGroups = delGroups.stream().collect(Collectors.toList());
        ownerGroups = new ArrayList(new HashSet(ownerGroups));
        return ownerGroups;
    }

    @Override
    public List<String> getAllOwnerUsers() {
        List<RawEntity> delegationObjs = Arrays.asList(this.activeObjects.find(Delegation.class, Query.select().where(" USER_KEY IS NOT NULL", new Object[0])));
        List delGroups = delegationObjs.stream().map(delObj -> delObj.getUserKey()).collect(Collectors.toList());
        List<String> ownerUsers = delGroups.stream().collect(Collectors.toList());
        ownerUsers = new ArrayList(new HashSet(ownerUsers));
        return ownerUsers;
    }

    @Override
    public int getMaxOwnerGroups() {
        List<RawEntity> delegationObjs = Arrays.asList(this.activeObjects.find(DelegationGroup.class, Query.select().order("GROUP_NAME ASC")));
        WeakHashMap<String, Integer> groupOwnerMap = new WeakHashMap<String, Integer>();
        for (DelegationGroup delegationGroup : delegationObjs) {
            groupOwnerMap.put(delegationGroup.getGroupName(), delegationGroup.getGroupOwners().length);
        }
        Map.Entry maxEntry = groupOwnerMap.isEmpty() ? null : Collections.max(groupOwnerMap.entrySet(), (e1, e2) -> ((Integer)e1.getValue()).compareTo((Integer)e2.getValue()));
        return maxEntry != null ? (Integer)maxEntry.getValue() : 0;
    }

    @Override
    public int getMaxOwnerUsers() {
        List<RawEntity> delegationObjs = Arrays.asList(this.activeObjects.find(DelegationGroup.class, Query.select().order("GROUP_NAME ASC")));
        WeakHashMap<String, Integer> userOwnerMap = new WeakHashMap<String, Integer>();
        for (DelegationGroup delegationGroup : delegationObjs) {
            userOwnerMap.put(delegationGroup.getGroupName(), delegationGroup.getUserOwners().length);
        }
        Map.Entry maxEntry = userOwnerMap.isEmpty() ? null : Collections.max(userOwnerMap.entrySet(), (e1, e2) -> ((Integer)e1.getValue()).compareTo((Integer)e2.getValue()));
        return maxEntry != null ? (Integer)maxEntry.getValue() : 0;
    }

    @Override
    public int getNoOfZeroOwnerGroups() {
        int count = 0;
        List<RawEntity> delegationObjs = Arrays.asList(this.activeObjects.find(DelegationGroup.class, Query.select().order("GROUP_NAME ASC")));
        for (DelegationGroup delegationGroup : delegationObjs) {
            if (delegationGroup.getUserOwners().length != 0 || delegationGroup.getGroupOwners().length != 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isActiveUserDelegate() {
        if (this.userManager.getRemoteUserKey() == null) {
            return false;
        }
        String userKey = this.userManager.getRemoteUserKey().getStringValue();
        Object obj = this.cacheManager.getCache("wittified-groups-admin").get((Object)userKey);
        if (obj != null) {
            return (Boolean)obj;
        }
        if (userKey == null) {
            return false;
        }
        boolean shouldShow = false;
        if (!this.getGroupDelegation(userKey).isEmpty()) {
            shouldShow = true;
        }
        this.cacheManager.getCache("wittified-groups-admin").put((Object)userKey, (Object)new Boolean(shouldShow));
        return shouldShow;
    }

    private List<Delegation> updateGroups(List<Delegation> delegations) {
        for (Delegation delegation : delegations) {
            if (delegation.getGroupObj() != null && !delegation.getGroupObj().isEmpty()) continue;
            delegation.setGroupObj(delegation.getGroupName());
        }
        ArrayList<Delegation> returnList = new ArrayList<Delegation>();
        for (final Delegation delegation : delegations) {
            if (this.doesGroupExist(delegation.getGroupObj())) {
                logger.debug("Allowing " + delegation.getGroupObj());
                returnList.add(delegation);
                continue;
            }
            logger.debug("Deleting " + delegation.getGroupObj());
            this.cacheManager.getCache("wittified-groups-admin").removeAll();
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    DelegationServiceImpl.this.activeObjects.delete(new RawEntity[]{delegation});
                    return null;
                }
            });
        }
        return returnList;
    }

    @Override
    public boolean doesGroupExist(String groupName) {
        logger.debug("Verifying " + groupName);
        for (String candidateGroup : this.userManager.findGroupNamesByPrefix(groupName, 0, 200)) {
            logger.debug(" Checking " + candidateGroup + " " + candidateGroup.equalsIgnoreCase(groupName));
            if (!candidateGroup.equalsIgnoreCase(groupName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addUserOwner(String delegatedGroup, final String userKey) {
        final List<RawEntity> delegationGroups = Arrays.asList(this.activeObjects.find(DelegationGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{delegatedGroup})));
        if (delegationGroups.size() > 0 && ((UserOwner[])this.activeObjects.find(UserOwner.class, Query.select().where(" OWNER_KEY = ? AND DELEGATION_GROUP_ID = ? ", new Object[]{userKey, ((DelegationGroup)delegationGroups.get(0)).getID()}))).length <= 0) {
            this.cacheManager.getCache("wittified-groups-admin").removeAll();
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    if (!delegationGroups.isEmpty()) {
                        UserOwner userOwner = (UserOwner)DelegationServiceImpl.this.activeObjects.create(UserOwner.class, new DBParam[0]);
                        userOwner.setOwnerKey(userKey);
                        userOwner.setDelegationGroup((DelegationGroup)delegationGroups.get(0));
                        userOwner.save();
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void addGroupOwner(final String delegatedGroup, final String groupName) {
        if (!this.hasGroupDelegation(delegatedGroup, null, groupName)) {
            this.cacheManager.getCache("wittified-groups-admin").removeAll();
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    List<RawEntity> delegationGroups = Arrays.asList(DelegationServiceImpl.this.activeObjects.find(DelegationGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{delegatedGroup})));
                    if (!delegationGroups.isEmpty()) {
                        GroupOwner groupOwner = (GroupOwner)DelegationServiceImpl.this.activeObjects.create(GroupOwner.class, new DBParam[0]);
                        groupOwner.setOwnerName(groupName);
                        groupOwner.setLowerOwnerName(groupName.toLowerCase());
                        groupOwner.setDelegationGroup((DelegationGroup)delegationGroups.get(0));
                        groupOwner.save();
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void removeUserOwner(final String delegatedGroup, final String userKey) {
        if (this.hasGroupDelegation(delegatedGroup, userKey, null)) {
            this.cacheManager.getCache("wittified-groups-admin").removeAll();
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    DelegationGroup[] delegationGroups = (DelegationGroup[])DelegationServiceImpl.this.activeObjects.find(DelegationGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{delegatedGroup}));
                    DelegationServiceImpl.this.activeObjects.delete(DelegationServiceImpl.this.activeObjects.find(UserOwner.class, Query.select().where(" OWNER_KEY = ? AND DELEGATION_GROUP_ID = ? ", new Object[]{userKey, delegationGroups[0].getID()})));
                    return null;
                }
            });
        }
    }

    @Override
    public void removeGroupOwner(final String delegatedGroup, final String groupName) {
        if (this.hasGroupDelegation(delegatedGroup, null, groupName)) {
            this.cacheManager.getCache("wittified-groups-admin").removeAll();
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    DelegationGroup[] delegationGroups = (DelegationGroup[])DelegationServiceImpl.this.activeObjects.find(DelegationGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{delegatedGroup}));
                    DelegationServiceImpl.this.activeObjects.delete(DelegationServiceImpl.this.activeObjects.find(GroupOwner.class, Query.select().where(" OWNER_NAME = ? AND DELEGATION_GROUP_ID = ? ", new Object[]{groupName, delegationGroups[0].getID()})));
                    return null;
                }
            });
        }
    }

    @Override
    public List<DelegationGroup> getPaginatedDelegatedGroups(int page) {
        return Arrays.asList(this.activeObjects.find(DelegationGroup.class, Query.select().order("GROUP_NAME ASC").offset((page - 1) * 25).limit(25)));
    }

    @Override
    public int getDelegationGroupCount() {
        return ((DelegationGroup[])this.activeObjects.find(DelegationGroup.class)).length;
    }

    @Override
    public int getfilteredDelegatedGroupsSize(String searchTerm) {
        return Arrays.asList(this.activeObjects.find(DelegationGroup.class, Query.select().where("LOWER_GROUP_NAME LIKE ? ", new Object[]{"%" + searchTerm.toLowerCase() + "%"}))).size();
    }

    @Override
    public List<DelegationGroup> getPaginatedFilteredDelegatedGroups(String searchTerm, int page) {
        return Arrays.asList(this.activeObjects.find(DelegationGroup.class, Query.select().where("LOWER_GROUP_NAME LIKE ? ", new Object[]{"%" + searchTerm.toLowerCase() + "%"}).order("GROUP_NAME ASC").offset((page - 1) * 25).limit(25)));
    }

    @Override
    public List<String> getAllDelegatedGroupNames() {
        ArrayList<String> groupNamesList = new ArrayList<String>();
        List<RawEntity> groups = Arrays.asList(this.activeObjects.find(DelegationGroup.class, Query.select().order("GROUP_NAME ASC")));
        for (DelegationGroup delegationGroup : groups) {
            groupNamesList.add(delegationGroup.getGroupName());
        }
        return groupNamesList;
    }

    @Override
    public List<DelegationGroup> getAllDelegatedGroupObjs() {
        List delegationObjs = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                return Arrays.asList(DelegationServiceImpl.this.activeObjects.find(DelegationGroup.class, Query.select().order("GROUP_NAME ASC")));
            }
        });
        return delegationObjs;
    }

    @Override
    public List<String> getFavoriteGroupUsers(String groupName) {
        ArrayList<String> users = new ArrayList<String>();
        try {
            DelegationGroup[] delGroups;
            for (DelegationGroup delGroup : delGroups = this.getDelegatedGroup(groupName)) {
                FavoriteUserOwner[] favOwners;
                for (FavoriteUserOwner favUser : favOwners = delGroup.getFavoriteUserOwners()) {
                    users.add(favUser.getOwnerKey());
                }
            }
            users = new ArrayList<String>(new HashSet<String>(users));
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
        return users;
    }

    @Override
    public void addFavoriteUserGroup(String delegatedGroup, final String userKey) {
        final List<RawEntity> delegationGroups = Arrays.asList(this.activeObjects.find(DelegationGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{delegatedGroup})));
        if (!delegationGroups.isEmpty() && ((FavoriteUserOwner[])this.activeObjects.find(FavoriteUserOwner.class, Query.select().where(" OWNER_KEY = ? AND DELEGATION_GROUP_ID = ? ", new Object[]{userKey, ((DelegationGroup)delegationGroups.get(0)).getID()}))).length <= 0) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    if (!delegationGroups.isEmpty()) {
                        FavoriteUserOwner favUserOwner = (FavoriteUserOwner)DelegationServiceImpl.this.activeObjects.create(FavoriteUserOwner.class, new DBParam[0]);
                        favUserOwner.setOwnerKey(userKey);
                        favUserOwner.setDelegationGroup((DelegationGroup)delegationGroups.get(0));
                        favUserOwner.save();
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void removeFavoriteUserGroup(final String delegatedGroup, final String userKey) {
        if (this.hasGroupDelegation(delegatedGroup, userKey, null)) {
            this.cacheManager.getCache("wittified-groups-admin").removeAll();
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    DelegationGroup[] delegationGroups = (DelegationGroup[])DelegationServiceImpl.this.activeObjects.find(DelegationGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{delegatedGroup}));
                    DelegationServiceImpl.this.activeObjects.delete(DelegationServiceImpl.this.activeObjects.find(FavoriteUserOwner.class, Query.select().where(" OWNER_KEY = ? AND DELEGATION_GROUP_ID = ? ", new Object[]{userKey, delegationGroups[0].getID()})));
                    return null;
                }
            });
        }
    }
}

