/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.groupadmin.rest;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.collect.Lists;
import com.wittified.groupadmin.analytics.DelGroupsAnalytics;
import com.wittified.groupadmin.analytics.EventType;
import com.wittified.groupadmin.ao.DelegationGroup;
import com.wittified.groupadmin.ao.DelegationService;
import com.wittified.groupadmin.ao.GroupOwner;
import com.wittified.groupadmin.ao.UserOwner;
import com.wittified.groupadmin.product.ProductService;
import com.wittified.groupadmin.rest.DelegationEndPoints;
import com.wittified.groupadmin.rest.GroupOwnerEntity;
import com.wittified.groupadmin.rest.UserEntity;
import com.wittified.groupadmin.services.DelegatedGroupCommonService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/configure")
public class GlobalConfigurationEndPoints {
    private final DelegationService delegationService;
    private final UserManager userManager;
    private final ProductService productService;
    private final PluginLicenseManager pluginLicenseManager;
    private final DelegatedGroupCommonService delegatedGroupPaginationService;
    private final DelGroupsAnalytics delGroupsAnalytics;
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final Logger logger = LoggerFactory.getLogger(DelegationEndPoints.class);

    public GlobalConfigurationEndPoints(DelegationService delegationService, UserManager userManager, ProductService productService, PluginLicenseManager pluginLicenseManager, DelegatedGroupCommonService delegatedGroupPaginationService, DelGroupsAnalytics delGroupsAnalytics, PluginSettingsFactory pluginSettingsFactory) {
        this.delegationService = delegationService;
        this.userManager = userManager;
        this.productService = productService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.delegatedGroupPaginationService = delegatedGroupPaginationService;
        this.delGroupsAnalytics = delGroupsAnalytics;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/find-all-groups")
    public Response findAllOfTheGroups(@Context HttpServletRequest req) {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        String search = req.getParameter("query");
        String excludedGroup = req.getParameter("exclude");
        WeakHashMap<String, List<String>> groupsContainer = new WeakHashMap<String, List<String>>();
        List<String> groups = this.productService.getGroupsStartingWith(search, excludedGroup);
        String excludedGroupsFromDelegation = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.delegated.group.global.configuration.excludeGroups");
        if (excludedGroupsFromDelegation != null) {
            String[] groupArr;
            for (String group : groupArr = excludedGroupsFromDelegation.split(",")) {
                groups.remove(group);
            }
        }
        groupsContainer.put("results", groups);
        return Response.ok(groupsContainer).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/find-all-groups-contain")
    public Response findAllOfTheGroupsContain(@QueryParam(value="search") String search, @QueryParam(value="group") String delegatedGroupName) {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        return Response.ok(this.productService.getGroupsContain(search, delegatedGroupName)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/find-all-groups-contain-for-exclude")
    public Response findAllOfTheGroupsContainForExclude(@QueryParam(value="search") String search, @QueryParam(value="group") String delegatedGroupName) {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        List<String> groups = this.productService.getGroupsContain(search, delegatedGroupName);
        List<String> delegatedGroups = this.delegationService.getAllDelegatedGroupNames();
        for (String group : delegatedGroups) {
            groups.remove(group);
        }
        return Response.ok(groups).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/find-users-in-group")
    public Response findUsersInGroup(@QueryParam(value="group") String groupName) {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        logger.debug("Looking for group " + groupName);
        return Response.ok(this.productService.getUsersInGroup(groupName)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/find-users")
    public Response findUsers(@QueryParam(value="query") String userName, @QueryParam(value="group") String delegatedGroupName) {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        logger.debug("Looking for users ");
        return Response.ok(this.productService.finderUsers(userName, delegatedGroupName)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/add-owner")
    public Response addUser(Map<String, String> data, @Context HttpServletRequest request) {
        int n;
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.isInValid()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (data == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        logger.debug("addUser data:" + data);
        String groupKey = data.get("groupKey");
        String userKey = data.get("userKey");
        String group = data.get("group");
        String user = data.get("user");
        String[] users = null;
        String[] groups = null;
        if (!this.isBrowserBasedClient(request) && StringUtils.isNotBlank(user)) {
            users = user.split(",");
            StringBuilder notFoundUsers = new StringBuilder();
            String[] userKeysFromUser = new StringBuilder();
            String[] stringArray = users;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                String userName = stringArray[i];
                UserProfile userProfile = this.userManager.getUserProfile(userName);
                if (userProfile != null) {
                    userKeysFromUser.append(userProfile.getUserKey().getStringValue());
                    userKeysFromUser.append(",");
                    continue;
                }
                notFoundUsers.append(userName);
                notFoundUsers.append(",");
            }
            if (StringUtils.isNotBlank(notFoundUsers.toString())) {
                String string = notFoundUsers.toString().endsWith(",") ? notFoundUsers.toString().substring(0, notFoundUsers.length() - 1) : notFoundUsers.toString();
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"message\": \"'User/s " + string + "' not found\"}")).build();
            }
            if (StringUtils.isNotBlank(userKeysFromUser.toString())) {
                String string = userKey = userKeysFromUser.toString().endsWith(",") ? userKeysFromUser.toString().substring(0, userKeysFromUser.toString().length() - 1) : userKeysFromUser.toString();
            }
        }
        if (!this.isBrowserBasedClient(request) && StringUtils.isNoneBlank(groupKey)) {
            groups = groupKey.split(",");
            StringBuilder notFoundGroups = new StringBuilder();
            for (String groupName : groups) {
                if (this.productService.isGroupExists(groupName)) continue;
                notFoundGroups.append(groupName);
                notFoundGroups.append(",");
            }
            if (StringUtils.isNotBlank(notFoundGroups.toString())) {
                String notFoundGroupsStr = notFoundGroups.toString().endsWith(",") ? notFoundGroups.toString().substring(0, notFoundGroups.length() - 1) : notFoundGroups.toString();
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"message\": \"'Group/s " + notFoundGroupsStr + "' not found\"}")).build();
            }
        }
        String[] userKeys = null;
        String[] groupKeys = null;
        if (StringUtils.isNoneBlank(userKey)) {
            userKeys = userKey.split(",");
        }
        if (!StringUtils.isBlank(groupKey)) {
            groupKeys = groupKey.split(",");
        }
        if (userKeys != null && StringUtils.isNoneBlank(group)) {
            for (String key : userKeys) {
                this.delegationService.addUserOwner(group, key);
            }
            this.delGroupsAnalytics.postEventInfo(EventType.ADDED_OWNER_USER_TO_DELEGATED_GROUP);
        }
        if (groupKeys != null && StringUtils.isNoneBlank(group)) {
            for (String key : groupKeys) {
                if (!this.productService.isGroupExists(key)) continue;
                this.delegationService.addGroupOwner(group, key);
            }
            this.delGroupsAnalytics.postEventInfo(EventType.ADDED_OWNER_GROUP_TO_DELEGATED_GROUP);
        }
        if (StringUtils.isBlank(groupKey) && StringUtils.isNoneBlank(userKey)) {
            for (String key : userKeys) {
                if (!this.productService.doesUserExistAndIsActive(key)) continue;
                this.delegationService.addGroupDelegationOld(group, key);
            }
        }
        if (StringUtils.isNoneBlank(groupKey)) {
            for (String key : groupKeys) {
                if (!this.productService.isGroupExists(key)) continue;
                this.delegationService.addGroupOwnerDelegationOld(group, key);
            }
        }
        boolean bl = true;
        int page = 1;
        int endPage = -1;
        String searchTerm = "";
        if (StringUtils.isNoneBlank(data.get("startPage"))) {
            n = Integer.parseInt(data.get("startPage"));
        }
        if (StringUtils.isNoneBlank(data.get("page"))) {
            page = Integer.parseInt(data.get("page"));
        }
        if (StringUtils.isNoneBlank(data.get("endPage"))) {
            endPage = Integer.parseInt(data.get("endPage"));
        }
        if (StringUtils.isNoneBlank(data.get("searchTerm"))) {
            searchTerm = data.get("searchTerm");
        }
        if (this.isBrowserBasedClient(request)) {
            return this.getAllConfiguredGroups(n, page, endPage, searchTerm);
        }
        boolean SUCCESS = true;
        StringBuilder message = new StringBuilder();
        message.append("{\"message\":\"");
        if (!this.productService.isGroupExists(group)) {
            message.append("Delegated group " + group + " not found. ");
            SUCCESS = false;
        }
        if (StringUtils.isNoneBlank(groupKey)) {
            StringBuilder groupOwners = new StringBuilder();
            for (String key : groupKeys) {
                if (this.productService.isGroupExists(key)) continue;
                groupOwners.append(key);
                groupOwners.append(",");
            }
            if (StringUtils.isNotBlank(groupOwners.toString())) {
                String string = groupOwners.toString().endsWith(",") ? groupOwners.toString().substring(0, groupOwners.length() - 1) : groupOwners.toString();
                message.append("Group owner/s " + string + " not found.");
                SUCCESS = false;
            }
        }
        if (StringUtils.isNoneBlank(user)) {
            StringBuilder userOwners = new StringBuilder();
            for (String key : users) {
                if (this.productService.doesUserExistAndIsActive(key)) continue;
                userOwners.append(key);
                userOwners.append(",");
            }
            if (StringUtils.isNotBlank(userOwners.toString())) {
                String string = userOwners.toString().endsWith(",") ? userOwners.toString().substring(0, userOwners.length() - 1) : userOwners.toString();
                message.append("User owner/s " + string + " not found or not active.");
                SUCCESS = false;
            }
        }
        message.append("\"}");
        logger.debug("addUser message:" + message.toString());
        return Response.status((Response.Status)(SUCCESS ? Response.Status.OK : Response.Status.NOT_FOUND)).entity((Object)(SUCCESS ? this.getDelegatedGroupAsStr(group) : message.toString())).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/remove-owner")
    public Response removeUser(Map<String, String> data, @Context HttpServletRequest request) {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.isInValid()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (data == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        logger.debug("removeUser data:" + data);
        String groupKey = data.get("groupKey");
        String userKey = data.get("userKey");
        String group = data.get("group");
        String user = data.get("user");
        boolean notOwnerUser = false;
        boolean notOwnerGroup = false;
        if (!this.isBrowserBasedClient(request) && StringUtils.isNotBlank(user)) {
            UserProfile userProfile = this.userManager.getUserProfile(user);
            if (userProfile != null) {
                userKey = userProfile.getUserKey().getStringValue();
            } else {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"message\": \"'" + user + "' not found\"}")).build();
            }
        }
        if (StringUtils.isNoneBlank(userKey) && this.productService.isGroupExists(group) && !this.getUserOwners(group).contains(userKey)) {
            notOwnerUser = true;
        }
        if (StringUtils.isNoneBlank(groupKey) && this.productService.isGroupExists(group) && !this.getGroupOwners(group).contains(groupKey)) {
            notOwnerGroup = true;
        }
        if (data != null && !StringUtils.isBlank(userKey)) {
            this.delegationService.removeUserOwner(group, userKey);
            this.delGroupsAnalytics.postEventInfo(EventType.REMOVED_OWNER_USER_FROM_DELEGATED_GROUP);
        }
        if (data != null && !StringUtils.isBlank(groupKey)) {
            this.delegationService.removeGroupOwner(group, groupKey);
            this.delGroupsAnalytics.postEventInfo(EventType.REMOVED_OWNER_GROUP_FROM_DELEGATED_GROUP);
        }
        if (data != null && groupKey == null) {
            this.delegationService.removeGroupDelegationOld(group, userKey);
        } else if (data != null && groupKey != null) {
            this.delegationService.removeGroupDelegationOld(group, userKey, groupKey);
        }
        int startPage = 1;
        int page = 1;
        int endPage = -1;
        String searchTerm = "";
        if (StringUtils.isNoneBlank(data.get("startPage"))) {
            startPage = Integer.parseInt(data.get("startPage"));
        }
        if (StringUtils.isNoneBlank(data.get("page"))) {
            page = Integer.parseInt(data.get("page"));
        }
        if (StringUtils.isNoneBlank(data.get("endPage"))) {
            endPage = Integer.parseInt(data.get("endPage"));
        }
        if (StringUtils.isNoneBlank(data.get("searchTerm"))) {
            searchTerm = data.get("searchTerm");
        }
        if (this.isBrowserBasedClient(request)) {
            return this.getAllConfiguredGroups(startPage, page, endPage, searchTerm);
        }
        boolean SUCCESS = true;
        StringBuilder message = new StringBuilder();
        message.append("{\"message\":\"");
        if (!this.productService.isGroupExists(group)) {
            message.append("Delegated group " + group + " not found. ");
            SUCCESS = false;
        }
        if (StringUtils.isNoneBlank(groupKey) && !this.productService.isGroupExists(groupKey)) {
            message.append("Group owner " + groupKey + " not found. ");
            SUCCESS = false;
        }
        if (StringUtils.isNoneBlank(user) && !this.productService.doesUserExistAndIsActive(user)) {
            message.append("User owner " + userKey + " not found or is not active. ");
            SUCCESS = false;
        }
        if (notOwnerUser) {
            message.append("User " + user + "/" + userKey + " is not owner for Delegated group " + group + ". ");
            SUCCESS = false;
        }
        if (notOwnerGroup) {
            message.append("Group " + groupKey + " is not owner for Delegated group " + group + ". ");
            SUCCESS = false;
        }
        message.append("\"}");
        logger.debug("removeUser message:" + message.toString());
        return Response.status((Response.Status)(SUCCESS ? Response.Status.OK : Response.Status.NOT_FOUND)).entity((Object)(SUCCESS ? this.getDelegatedGroupAsStr(group) : message.toString())).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/remove-group-delegation")
    public Response removeDelegationFromGroup(Map<String, String> data) {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        this.delegationService.removeGroupDelegation(data.get("group"));
        this.delGroupsAnalytics.postEventInfo(EventType.DELEGATED_GROUP_REMOVED);
        this.delegationService.removeGroupDelegationOld(data.get("group"));
        int startPage = 1;
        int page = 1;
        int endPage = -1;
        String searchTerm = "";
        if (StringUtils.isNoneBlank(data.get("startPage"))) {
            startPage = Integer.parseInt(data.get("startPage"));
        }
        if (StringUtils.isNoneBlank(data.get("page"))) {
            page = Integer.parseInt(data.get("page"));
        }
        if (StringUtils.isNoneBlank(data.get("endPage"))) {
            endPage = Integer.parseInt(data.get("endPage"));
        }
        if (StringUtils.isNoneBlank(data.get("searchTerm"))) {
            searchTerm = data.get("searchTerm");
        }
        return this.getAllConfiguredGroups(startPage, page, endPage, searchTerm);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/add-group")
    public Response addGroup(Map<String, String> data, @Context HttpServletRequest request) {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        if (data == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        logger.debug("addUser data:" + data);
        String group = data.get("group");
        if (StringUtils.isBlank(group)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int startPage = 1;
        int page = 1;
        int endPage = -1;
        String searchTerm = "";
        if (StringUtils.isNoneBlank(data.get("startPage"))) {
            startPage = Integer.parseInt(data.get("startPage"));
        }
        if (StringUtils.isNoneBlank(data.get("page"))) {
            page = Integer.parseInt(data.get("page"));
        }
        if (StringUtils.isNoneBlank(data.get("endPage"))) {
            endPage = Integer.parseInt(data.get("endPage"));
        }
        if (StringUtils.isNoneBlank(data.get("searchTerm"))) {
            searchTerm = data.get("searchTerm");
        }
        if (this.isBrowserBasedClient(request)) {
            this.delegationService.addGroupDelegationOld(group, null);
            this.delegationService.addGroupDelegation(group);
            this.delGroupsAnalytics.postEventInfo(EventType.DELEGATED_GROUP_ADDED);
            return this.getAllConfiguredGroups(startPage, page, endPage, searchTerm);
        }
        WeakHashMap<String, String> result = new WeakHashMap<String, String>();
        for (String groupName : group.split(",")) {
            boolean groupExist = this.productService.isGroupExists(groupName);
            if (groupExist) {
                this.delegationService.addGroupDelegationOld(groupName, null);
                this.delegationService.addGroupDelegation(groupName);
                result.put(groupName, this.getDelegatedGroupAsStr(groupName));
                continue;
            }
            result.put(groupName, "{\"message\":\"'" + group + "' not found \"}");
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups")
    public Response getAllConfiguredGroups(@DefaultValue(value="1") @QueryParam(value="startPage") Integer startPage, @DefaultValue(value="1") @QueryParam(value="page") Integer page, @DefaultValue(value="-1") @QueryParam(value="endPage") Integer endPage, @DefaultValue(value="") @QueryParam(value="searchTerm") String searchTerm) {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((int)403).build();
        }
        if (this.isInValid()) {
            return Response.status((int)204).build();
        }
        WeakHashMap<String, Object> paginatedGroups = new WeakHashMap<String, Object>();
        List<Object> delegatedGroups = Lists.newArrayList();
        int totalGroups = 0;
        totalGroups = StringUtils.isNoneBlank(searchTerm) ? this.delegationService.getfilteredDelegatedGroupsSize(searchTerm) : this.delegationService.getDelegationGroupCount();
        int totalPage = (int)Math.ceil((double)totalGroups / 25.0);
        if (totalPage < endPage) {
            if (page == endPage) {
                page = totalPage;
            }
            if ((startPage = Integer.valueOf((endPage = Integer.valueOf(totalPage)) - 4)) < 1) {
                startPage = 1;
            }
            if (endPage == startPage) {
                endPage = -1;
            }
        } else if (endPage < startPage + 4) {
            int reqEndPage = startPage + 4;
            endPage = reqEndPage <= totalPage ? reqEndPage : totalPage;
        }
        if (totalGroups == 0) {
            endPage = -1;
        }
        paginatedGroups.put("pageEntity", this.delegatedGroupPaginationService.positionThePager(startPage, page, endPage, totalGroups, 25));
        delegatedGroups = !StringUtils.isBlank(searchTerm) ? this.delegationService.getPaginatedFilteredDelegatedGroups(searchTerm, page) : this.delegationService.getPaginatedDelegatedGroups(page);
        LinkedHashMap<String, GroupOwnerEntity> groups = new LinkedHashMap<String, GroupOwnerEntity>();
        for (DelegationGroup delegationGroup : delegatedGroups) {
            GroupOwnerEntity groupOwnerEntity;
            if (groups.containsKey(delegationGroup.getGroupName())) {
                groupOwnerEntity = (GroupOwnerEntity)groups.get(delegationGroup.getGroupName());
            } else {
                groupOwnerEntity = new GroupOwnerEntity();
                groupOwnerEntity.setGroup(delegationGroup.getGroupName());
                groupOwnerEntity.setOwners(new ArrayList<UserEntity>());
            }
            for (UserOwner userOwner : delegationGroup.getUserOwners()) {
                UserProfile userProfile = this.userManager.getUserProfile(new UserKey(userOwner.getOwnerKey()));
                if (userProfile == null) continue;
                UserEntity userEntity = new UserEntity();
                userEntity.setKey(userProfile.getUserKey().getStringValue());
                userEntity.setDisplayName(userProfile.getFullName());
                userEntity.setIsGroup(false);
                groupOwnerEntity.addOwner(userEntity);
            }
            for (GroupOwner groupOwner : delegationGroup.getGroupOwners()) {
                UserEntity userEntity = new UserEntity();
                userEntity.setKey(groupOwner.getOwnerName());
                userEntity.setDisplayName(groupOwner.getOwnerName());
                userEntity.setIsGroup(true);
                userEntity.setCount(this.getOwnerGroupCount(groupOwner.getOwnerName()));
                groupOwnerEntity.addOwner(userEntity);
            }
            groupOwnerEntity.setGroupExist(this.delegationService.doesGroupExist(delegationGroup.getGroupName()));
            groups.put(delegationGroup.getGroupName(), groupOwnerEntity);
        }
        List delegatedGroupEntities = groups.values().stream().collect(Collectors.toList());
        paginatedGroups.put("delegatedGroups", delegatedGroupEntities);
        paginatedGroups.put("applicationType", this.productService.getApplicationType());
        return Response.ok(paginatedGroups).build();
    }

    private boolean isInValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            if (((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid()) {
                return false;
            }
            logger.error("Delegated groups license is invalid: " + ((LicenseError)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().get()).toString());
            return true;
        }
        logger.error("Delegated groups license is not licensed");
        return true;
    }

    private Integer getOwnerGroupCount(String groupKey) {
        return this.productService.getUsersInGroup(groupKey).size();
    }

    private boolean isBrowserBasedClient(HttpServletRequest request) {
        return StringUtils.containsIgnoreCase(request.getHeader("User-Agent"), "mozilla");
    }

    private String getDelegatedGroupAsStr(String groupName) {
        StringBuilder userOwners = new StringBuilder();
        StringBuilder groupOwners = new StringBuilder();
        for (DelegationGroup delegation : this.delegationService.getDelegatedGroup(groupName)) {
            for (GroupOwner groupOwner : delegation.getGroupOwners()) {
                groupOwners.append(groupOwner.getOwnerName() + ",");
            }
            for (UserOwner userOwner : delegation.getUserOwners()) {
                UserProfile userProfile = this.userManager.getUserProfile(new UserKey(userOwner.getOwnerKey()));
                if (userProfile != null) {
                    userOwners.append(userProfile.getUsername() + ",");
                    continue;
                }
                userOwners.append(userOwner.getOwnerKey() + ",");
            }
        }
        JSONObject delegatedGroupJson = new JSONObject();
        try {
            delegatedGroupJson.put("group", groupName);
            delegatedGroupJson.put("groupOwners", StringUtils.removeEnd(groupOwners.toString(), ","));
            delegatedGroupJson.put("userOwners", StringUtils.removeEnd(userOwners.toString(), ","));
        }
        catch (JSONException e) {
            logger.error("Error when constructing the JSON Object:" + e.getMessage());
        }
        logger.debug(delegatedGroupJson.toString());
        return delegatedGroupJson.toString();
    }

    private List<String> getUserOwners(String groupName) {
        ArrayList<String> userOwnersList = new ArrayList<String>();
        for (DelegationGroup delegation : this.delegationService.getDelegatedGroup(groupName)) {
            for (UserOwner userOwner : delegation.getUserOwners()) {
                UserProfile userProfile = this.userManager.getUserProfile(new UserKey(userOwner.getOwnerKey()));
                if (userProfile == null) continue;
                userOwnersList.add(userProfile.getUserKey().getStringValue());
            }
        }
        return userOwnersList;
    }

    private List<String> getGroupOwners(String groupName) {
        ArrayList<String> groupOwnersList = new ArrayList<String>();
        for (DelegationGroup delegation : this.delegationService.getDelegatedGroup(groupName)) {
            for (GroupOwner groupOwner : delegation.getGroupOwners()) {
                groupOwnersList.add(groupOwner.getOwnerName());
            }
        }
        return groupOwnersList;
    }
}

