/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parboiled.common.Preconditions;
import org.parboiled.trees.MutableTreeNode;
import org.parboiled.trees.TreeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableTreeNodeImpl<T extends MutableTreeNode<T>>
implements MutableTreeNode<T> {
    private final List<T> children = new ArrayList<T>();
    private final List<T> childrenView = Collections.unmodifiableList(this.children);
    private T parent;

    @Override
    public T getParent() {
        return this.parent;
    }

    @Override
    public List<T> getChildren() {
        return this.childrenView;
    }

    @Override
    public void addChild(int n, T t2) {
        Preconditions.checkElementIndex(n, this.children.size() + 1);
        if (t2 != null) {
            if (t2.getParent() == this) {
                return;
            }
            if (t2.getParent() != null) {
                TreeUtils.removeChild((MutableTreeNode)t2.getParent(), t2);
            }
        }
        this.children.add(n, t2);
        MutableTreeNodeImpl.setParent(t2, this);
    }

    @Override
    public void setChild(int n, T t2) {
        Preconditions.checkElementIndex(n, this.children.size());
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.children.get(n);
        if (mutableTreeNode == t2) {
            return;
        }
        MutableTreeNodeImpl.setParent(mutableTreeNode, null);
        if (t2 != null && t2.getParent() != this) {
            TreeUtils.removeChild((MutableTreeNode)t2.getParent(), t2);
        }
        this.children.set(n, t2);
        MutableTreeNodeImpl.setParent(t2, this);
    }

    @Override
    public T removeChild(int n) {
        Preconditions.checkElementIndex(n, this.children.size());
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.children.remove(n);
        MutableTreeNodeImpl.setParent(mutableTreeNode, null);
        return (T)mutableTreeNode;
    }

    private static <T extends MutableTreeNode<T>> void setParent(T t2, MutableTreeNodeImpl<T> mutableTreeNodeImpl) {
        if (t2 != null) {
            ((MutableTreeNodeImpl)t2).parent = mutableTreeNodeImpl;
        }
    }
}

