/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.upgrades;

import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetProjectEntitiesUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(ActiveObjectsUpgradeTask.class);
    private final NotificationService notificationService;

    public TargetProjectEntitiesUpgradeTask(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public int getBuildNumber() {
        return 7;
    }

    public String getShortDescription() {
        return "Created separate entity for target project in notifications dataset";
    }

    public Collection<Message> doUpgrade() throws Exception {
        log.info("Upgrading notifications dataset...");
        List<Notification> notifications = this.notificationService.getAllNotifications();
        for (Notification notification : notifications) {
            this.notificationService.updateTargetProjectEntities(notification);
        }
        log.info("Migration of notifications dataset completed...");
        return Collections.emptySet();
    }

    public String getPluginKey() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("announcer-project.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "com.wittified.atl-announcer-" + properties.getProperty("wittified-app-key");
    }
}

