/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.plugins.rest.common.security.LicensedOnly;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.NotificationService;
import com.wittified.format.FormatService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.NotificationBean;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
public class UserProfileViewServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(UserProfileViewServlet.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final NotificationService notificationService;
    private final LicenseCounter licenseCounter;
    private final FormatService formatService;

    public UserProfileViewServlet(TemplateRenderer templateRenderer, UserManager userManager, NotificationService notificationService, LicenseCounter licenseCounter, FormatService formatService) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseCounter = licenseCounter;
        this.formatService = formatService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        UserProfile user = this.userManager.getRemoteUser();
        res.setContentType("text/html");
        res.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        res.setHeader("Expires", "0");
        res.setHeader("Pragma", "no-cache");
        String template = "/templates/security-breach.vm";
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("helper", (Object)this);
        if (user != null) {
            List<NotificationBean> notifications = AnnouncerHelper.getAllNotifications(this.notificationService.getAllConfirmedNotificationsForUser(user));
            if (CollectionUtils.isNotEmpty(notifications)) {
                for (NotificationBean notification : notifications) {
                    String contents = this.formatService.formatThis(notification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, notification.getHtml()));
                    notification.setHtml(contents);
                    notification.setContents(contents);
                }
            }
            context.put("notifications", notifications);
            template = "/templates/profile/my-notifications-page.vm";
        } else {
            context.put("message", "In order to view this page - you have to be logged in.");
        }
        this.render(template, context, res);
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }
}

