/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.listeners;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.event.PluginLicenseAddedEvent;
import com.atlassian.upm.api.license.event.PluginLicenseUpdatedEvent;
import com.wittified.analytics.AnnouncerAnalytics;
import com.wittified.analytics.EventType;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AnnouncerListener
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final AnnouncerAnalytics announcerAnalytics;
    private final PluginLicenseEventRegistry pluginLicenseEventRegistry;
    private static final Logger logger = LoggerFactory.getLogger(AnnouncerListener.class);
    private final NotificationService notificationService;

    public AnnouncerListener(EventPublisher eventPublisher, AnnouncerAnalytics announcerAnalytics, PluginLicenseEventRegistry pluginLicenseEventRegistry, NotificationService notificationService) {
        this.eventPublisher = eventPublisher;
        this.announcerAnalytics = announcerAnalytics;
        this.notificationService = notificationService;
        this.pluginLicenseEventRegistry = pluginLicenseEventRegistry;
        this.pluginLicenseEventRegistry.register((Object)this);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        if ("com.wittified.atl-announcer-confluence".equals(plugin.getKey()) || "com.wittified.atl-announcer-jira".equals(plugin.getKey()) || "com.wittified.atl-announcer-stash".equals(plugin.getKey())) {
            Map<String, Object> eventDataMap = this.initializeEventDataMap();
            List<Notification> allNotifications = this.notificationService.getAllNotifications();
            if (CollectionUtils.isNotEmpty(allNotifications)) {
                this.runUpgradeTasks(allNotifications);
                eventDataMap.put("allNotificationsCount", allNotifications.size());
                eventDataMap.put("activeNotificationsCount", allNotifications.stream().filter(notification -> BooleanUtils.isTrue(notification.getActive())).count());
                eventDataMap.put("inActiveNotificationsCount", allNotifications.stream().filter(notification -> BooleanUtils.isFalse(notification.getActive())).count());
                eventDataMap.put("dateRestrictedNotificationsCount", allNotifications.stream().filter(notification -> BooleanUtils.isTrue(notification.getDateRestrict())).count());
                eventDataMap.put("bannerTypeNotificationsCount", allNotifications.stream().filter(notification -> "banner".equalsIgnoreCase(notification.getType())).count());
                eventDataMap.put("fullpageTypeNotificationsCount", allNotifications.stream().filter(notification -> "intercept".equalsIgnoreCase(notification.getType())).count());
                eventDataMap.put("flagTypeNotificationsCount", allNotifications.stream().filter(notification -> "flag".equalsIgnoreCase(notification.getType())).count());
                eventDataMap.put("dialogTypeNotificationsCount", allNotifications.stream().filter(notification -> "dialog".equalsIgnoreCase(notification.getType())).count());
            }
            this.announcerAnalytics.postEventInfo(EventType.INSTALL, eventDataMap);
        }
    }

    private void runUpgradeTasks(List<Notification> notifications) {
        for (Notification notification : notifications) {
            boolean shouldPersist = false;
            if (notification.getDateRestrict() == null) {
                notification.setDateRestrict(false);
                shouldPersist = true;
            }
            if (notification.getTempActive() == null) {
                notification.setTempActive(false);
                shouldPersist = true;
            }
            if (notification.getRecurringWeeklyType() == null) {
                notification.setRecurringWeeklyType(false);
                shouldPersist = true;
            }
            if (!shouldPersist) continue;
            this.notificationService.saveNotification(notification);
        }
    }

    private Map<String, Object> initializeEventDataMap() {
        WeakHashMap<String, Object> eventDataMap = new WeakHashMap<String, Object>();
        eventDataMap.put("allNotificationsCount", 0);
        eventDataMap.put("activeNotificationsCount", 0);
        eventDataMap.put("inActiveNotificationsCount", 0);
        eventDataMap.put("dateRestrictedNotificationsCount", 0);
        eventDataMap.put("bannerTypeNotificationsCount", 0);
        eventDataMap.put("fullpageTypeNotificationsCount", 0);
        eventDataMap.put("flagTypeNotificationsCount", 0);
        eventDataMap.put("dialogTypeNotificationsCount", 0);
        return eventDataMap;
    }

    @EventListener
    public void onPluginLicenseAddedEvent(PluginLicenseAddedEvent pluginLicenseAddedEvent) {
        try {
            this.announcerAnalytics.postEventInfo(EventType.LICENSE_ADDED);
        }
        catch (Exception e) {
            logger.debug("Error while posting analytics data: ", (Throwable)e);
        }
    }

    @EventListener
    public void onPluginLicenseUpdatedEvent(PluginLicenseUpdatedEvent pluginLicenseUpdatedEvent) {
        try {
            this.announcerAnalytics.postEventInfo(EventType.LICENSE_UPDATED);
        }
        catch (Exception e) {
            logger.debug("Error while posting analytics data: ", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        this.announcerAnalytics.postEventInfo(EventType.UNINSTALL);
        this.eventPublisher.unregister((Object)this);
        this.pluginLicenseEventRegistry.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

