/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.AbstractList;
import java.util.List;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableList<T>
extends AbstractList<T> {
    private static final ImmutableList<?> EMPTY_LIST = new ImmutableList<Object>(){

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException("Empty list has no element with index " + n);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ImmutableList<Object> append(Object object) {
            return 1.of(object);
        }
    };

    public abstract ImmutableList<T> append(T var1);

    public static <T> ImmutableList<T> copyOf(List<T> regularList) {
        Preconditions.checkArgNotNull(regularList, "other");
        return regularList instanceof ImmutableList ? regularList : new RegularList(regularList.toArray());
    }

    public static <T> ImmutableList<T> of() {
        return EMPTY_LIST;
    }

    public static <T> ImmutableList<T> of(T t2) {
        return new SingleElementList<T>(t2);
    }

    public static <T> ImmutableList<T> of(T t2, T t3) {
        return new TwoElementList(t2, t3);
    }

    public static <T> ImmutableList<T> of(T t2, T t3, T t4) {
        return new RegularList(new Object[]{t2, t3, t4});
    }

    public static <T> ImmutableList<T> of(T ... TArray) {
        Preconditions.checkArgNotNull(TArray, "elements");
        return new RegularList((Object[])TArray.clone());
    }

    public static <T> ImmutableList<T> of(T t2, T[] TArray) {
        Preconditions.checkArgNotNull(TArray, "more");
        return new RegularList(Utils.arrayOf(t2, (Object[])TArray.clone()));
    }

    public static <T> ImmutableList<T> of(T[] TArray, T t2) {
        Preconditions.checkArgNotNull(TArray, "first");
        return new RegularList(Utils.arrayOf((Object[])TArray.clone(), t2));
    }

    public static <T> ImmutableList<T> of(T t2, ImmutableList<T> immutableList) {
        Preconditions.checkArgNotNull(immutableList, "more");
        if (immutableList instanceof SingleElementList) {
            return ImmutableList.of(t2, ((SingleElementList)immutableList).element);
        }
        if (immutableList instanceof TwoElementList) {
            TwoElementList twoElementList = (TwoElementList)immutableList;
            return new RegularList(new Object[]{t2, twoElementList.element0, twoElementList.element1});
        }
        if (immutableList instanceof RegularList) {
            RegularList regularList = (RegularList)immutableList;
            return new RegularList(Utils.arrayOf(t2, regularList.elements));
        }
        Preconditions.checkState(immutableList == EMPTY_LIST);
        return ImmutableList.of(t2);
    }

    public static <T> ImmutableList<T> of(ImmutableList<T> immutableList, T t2) {
        Preconditions.checkArgNotNull(immutableList, "more");
        if (immutableList instanceof SingleElementList) {
            return ImmutableList.of(((SingleElementList)immutableList).element, t2);
        }
        if (immutableList instanceof TwoElementList) {
            TwoElementList twoElementList = (TwoElementList)immutableList;
            return new RegularList(new Object[]{twoElementList.element0, twoElementList.element1, t2});
        }
        if (immutableList instanceof RegularList) {
            RegularList regularList = (RegularList)immutableList;
            return new RegularList(Utils.arrayOf(regularList.elements, t2));
        }
        Preconditions.checkState(immutableList == EMPTY_LIST);
        return ImmutableList.of(t2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegularList
    extends ImmutableList<Object> {
        private final Object[] elements;

        private RegularList(Object[] objectArray) {
            this.elements = objectArray;
        }

        @Override
        public Object get(int n) {
            return this.elements[n];
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public ImmutableList<Object> append(Object object) {
            Object[] objectArray = new Object[this.elements.length + 1];
            System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
            objectArray[this.elements.length] = object;
            return new RegularList(objectArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TwoElementList<T>
    extends ImmutableList<T> {
        private final T element0;
        private final T element1;

        private TwoElementList(T t2, T t3) {
            this.element0 = t2;
            this.element1 = t3;
        }

        @Override
        public T get(int n) {
            Preconditions.checkElementIndex(n, 2);
            return n == 0 ? this.element0 : this.element1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public ImmutableList<T> append(T t2) {
            return TwoElementList.of(this.element0, this.element1, t2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleElementList<T>
    extends ImmutableList<T> {
        private final T element;

        public SingleElementList(T t2) {
            this.element = t2;
        }

        @Override
        public T get(int n) {
            Preconditions.checkElementIndex(n, 1);
            return this.element;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public ImmutableList<T> append(T t2) {
            return SingleElementList.of(this.element, t2);
        }
    }
}

