/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.upgrades;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.wittified.ao.NotificationService;
import com.wittified.ao.NotificationUser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationUserUpgradeTask
implements PluginUpgradeTask {
    private final NotificationService notificationService;
    private final UserManager userManager;
    private static Logger logger = LoggerFactory.getLogger(NotificationUserUpgradeTask.class);

    public NotificationUserUpgradeTask(NotificationService notificationService, UserManager userManager) {
        this.notificationService = notificationService;
        this.userManager = userManager;
    }

    public int getBuildNumber() {
        return 4;
    }

    public String getShortDescription() {
        return "Store Userkey in the NOTIFICATION_USER table";
    }

    public Collection<Message> doUpgrade() throws Exception {
        LogManager.getLogger((String)"com.wittified").setLevel(Level.INFO);
        List<NotificationUser> notificationUsers = this.notificationService.getAllNotificationUsers();
        int totalSize = notificationUsers.size();
        int count = 0;
        for (NotificationUser notificationUser : notificationUsers) {
            UserProfile userProfile = this.userManager.getUserProfile(notificationUser.getUser());
            notificationUser.setUserKey(userProfile.getUserKey().getStringValue());
            notificationUser.save();
            logger.info("Updating notification user : " + ++count + "of " + totalSize);
        }
        LogManager.getLogger((String)"com.wittified").setLevel(null);
        return Collections.emptySet();
    }

    public String getPluginKey() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("announcer-project.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "com.wittified.atl-announcer-" + properties.getProperty("wittified-app-key");
    }
}

