/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets.statuspage;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.wittified.ao.statuspage.ConfigToProject;
import com.wittified.ao.statuspage.ConfigToStatus;
import com.wittified.ao.statuspage.StatusPageConfig;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.statuspage.StatusPageService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPageConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 4171476064213410310L;
    private static Logger logger = LoggerFactory.getLogger(StatusPageConfigServlet.class);
    private final StatusPageService statusPageService;
    private final TemplateRenderer templateRenderer;
    private final LicenseCounter licenseCounter;
    private final UserManager userManager;

    public StatusPageConfigServlet(StatusPageService statusPageService, TemplateRenderer templateRenderer, LicenseCounter licenseCounter, UserManager userManager) {
        this.statusPageService = statusPageService;
        this.templateRenderer = templateRenderer;
        this.licenseCounter = licenseCounter;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        StatusPageConfig config = this.statusPageService.getConfig(req);
        String jsonInString = null;
        if (config == null) {
            res.setContentType("application/json");
            res.setCharacterEncoding("UTF-8");
            PrintWriter out = res.getWriter();
            out.print("Error while fetching Config");
        } else {
            try {
                jsonInString = this.buildJSONResponse(config, req.getRemoteUser());
            }
            catch (JSONException e) {
                logger.error("error while building configuration response");
            }
            res.setContentType("application/json");
            res.setCharacterEncoding("UTF-8");
            PrintWriter out = res.getWriter();
            out.print(jsonInString);
        }
    }

    private String buildJSONResponse(StatusPageConfig config, String user) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("active", config.getActive());
        json.put("title", (Object)config.getTitle());
        json.put("description", (Object)config.getDescription());
        json.put("announcementType", (Object)config.getAnnouncementType());
        json.put("notificationType", config.getNotificationType());
        json.put("filter-groups", config.getFilterGroups());
        json.put("filter-projects", config.getFilterProjects());
        json.put("pages", (Object)config.getPage());
        JSONArray statuses = new JSONArray();
        for (ConfigToStatus status : config.getStatuses()) {
            statuses.put((Object)status.getStatus());
        }
        json.put("statuses", (Object)statuses);
        json.put("groups", (Object)config.getGroup());
        if (config.getFilterProjects()) {
            JSONArray projects = new JSONArray();
            for (ConfigToProject project : config.getProjects()) {
                projects.put((Object)(project.getProjectKey() + "#" + project.getProjectName()));
            }
            json.put("projects", (Object)projects);
        }
        json.put("eol", (Object)config.getEOL());
        List allProjects = this.licenseCounter.getAllProjects(user).entrySet().stream().map(x -> (String)x.getKey() + "#" + (String)x.getValue()).collect(Collectors.toList());
        json.put("all-projects", allProjects);
        List allGroupNames = StreamSupport.stream(this.userManager.findGroupNamesByPrefix("", 0, 1000).spliterator(), false).collect(Collectors.toList());
        json.put("all-groups", allGroupNames);
        return json.toString();
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (StringUtils.isNotBlank(req.getParameter("configId"))) {
            String reqType = req.getParameter("type");
            if (StringUtils.isNotBlank(reqType) && reqType.equalsIgnoreCase("UPDATE")) {
                this.statusPageService.updateConfig(req);
            } else if (StringUtils.isNotBlank(reqType) && reqType.equalsIgnoreCase("DELETE")) {
                this.statusPageService.deleteConfig(req);
            }
        } else {
            this.statusPageService.createConfig(req);
        }
        res.sendRedirect(req.getContextPath() + "/plugins/servlet/wittified/admin/statuspage/configs/list");
    }
}

