/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.plugins.rest.common.security.LicensedOnly;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.general.support.SupportBarService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.entities.GlobalConfiguration;
import com.wittified.services.GlobalConfigurationService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
public class GlobalConfigurationServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GlobalConfigurationServlet.class);
    private final SupportBarService supportBarService;
    private final LicenseCounter licenseCounter;
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final NotificationService notificationService;
    private final PluginLicenseManager licenseStorageManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final WebSudoManager webSudoManager;
    private final GlobalConfigurationService globalConfigurationService;

    public GlobalConfigurationServlet(TemplateRenderer templateRenderer, UserManager userManager, NotificationService notificationService, PluginLicenseManager licenseStorageManager, LicenseCounter licenseCounter, PluginSettingsFactory pluginSettingsFactory, WebSudoManager webSudoManager, SupportBarService supportBarService, GlobalConfigurationService globalConfigurationService) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseStorageManager = licenseStorageManager;
        this.licenseCounter = licenseCounter;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.webSudoManager = webSudoManager;
        this.supportBarService = supportBarService;
        this.globalConfigurationService = globalConfigurationService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserProfile username = this.userManager.getRemoteUser();
        GlobalConfiguration config = this.globalConfigurationService.getGlobalConfiguration();
        if (username != null && AnnouncerHelper.isAdminUser(this.userManager)) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("license", this.getCheckLicense());
            context.put("config", config);
            context.put("product", this.licenseCounter.getApplicationType());
            context.put("supportbarHtml", AnnouncerHelper.getSupportBarHtml(this.supportBarService, this.licenseCounter.getApplicationType()));
            context.put("wittifiedXsfrToken", this.licenseCounter.getXsfrToken(req, res));
            res.setContentType("text/html");
            this.render("/templates/global-configuration.vm", context, res);
        } else {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            res.setContentType("text/html");
            this.render("/templates/security-breach.vm", context, res);
        }
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }

    public int getNumUsers(Notification notification) {
        if (notification == null) {
            return this.licenseCounter.getNumberOfUsers();
        }
        String groupName = notification.getGroupTarget();
        if (!notification.getFilterGroups()) {
            groupName = null;
        }
        logger.debug("Looking up " + groupName);
        if (groupName == null || groupName.isEmpty()) {
            return this.licenseCounter.getNumberOfUsers();
        }
        return this.licenseCounter.getNumUsersInGroup(groupName);
    }

    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }
}

