/*
 * Decompiled with CFR 0.152.
 */
package com.wittified;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.wittified.ao.Notification;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.general.support.SupportBarService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.NotificationBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncerHelper {
    private static final Logger logger = LoggerFactory.getLogger(AnnouncerHelper.class);
    private static final FastDateFormat cookieExpireDateFormat = FastDateFormat.getInstance("EEE, dd MMM yyyy HH:mm:ss zzz", TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
    private static final String WEEK_DAY_CRON_DELIMITER = ",";

    public static int getNumberOfUsers(Notification notification) {
        return notification.getNotificationUsers().length;
    }

    public static int getNumberOfUsersV1(NotificationBean notification) {
        return notification.getNotificationUsers().length;
    }

    public static String getTitle(Notification notification) {
        return notification.getTitle();
    }

    public static int getNumberOfAnonUsers(Notification notification) {
        return notification.getAnonUsers().length;
    }

    public static int getNumberOfAnonUsersV1(NotificationBean notification) {
        return notification.getAnonUsers().length;
    }

    public static String getCookieName(HttpServletRequest request, HttpServletResponse response) {
        return AnnouncerHelper.getCookieName(request);
    }

    public static String escapeEcmaScript(String stringToEscape) {
        return StringEscapeUtils.escapeEcmaScript(stringToEscape);
    }

    public static String getCookieName(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        if (session != null) {
            return session.getId() + "-" + session.getCreationTime();
        }
        return null;
    }

    public static void setCookie(String key, String value, int expires, String path, HttpServletRequest request, HttpServletResponse response) {
        StringBuilder cookieString = new StringBuilder();
        cookieString.append(key + "=" + value + ";");
        if (expires != 0) {
            cookieString.append(" Expires=" + AnnouncerHelper.getExpires(expires) + ";");
        }
        if (path != null) {
            cookieString.append(" path=" + path + ";");
        }
        cookieString.append(" SameSite=Strict;");
        if (request.getScheme().equalsIgnoreCase("https")) {
            cookieString.append(" Secure;");
        }
        response.addHeader("Set-Cookie", cookieString.toString());
    }

    private static String getExpires(int maxAge) {
        if (maxAge < 0) {
            return "";
        }
        Calendar expireDate = Calendar.getInstance();
        expireDate.setTime(new Date());
        expireDate.add(13, maxAge);
        return cookieExpireDateFormat.format(expireDate);
    }

    public static String getContentWithWhitelistedTagsOnly(PluginSettingsFactory pluginSettingsFactory, String contents) {
        Safelist safelist = Safelist.relaxed();
        safelist.addProtocols("a", "href", "slack");
        String whiteListTags = (String)pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.html.whitelist.tags");
        logger.debug("whiteListTags: " + whiteListTags);
        if (StringUtils.isNotBlank(whiteListTags)) {
            List<String> entries = Arrays.asList(whiteListTags.split("[\\r\\n]+"));
            try {
                logger.debug("------------SUPPORT-4163--------------");
                String[] whiteListedTags = entries.get(0).replaceAll("\\s", "").split("=")[1].split(WEEK_DAY_CRON_DELIMITER);
                logger.debug("whiteListedTags - " + String.valueOf(whiteListedTags));
                safelist.addTags(whiteListedTags);
                for (String attr : entries.subList(1, entries.size())) {
                    logger.debug("attr " + attr);
                    String tag = attr.replaceAll("\\s", "").split("=")[0].split("\\.")[0];
                    logger.debug("tag " + tag);
                    String[] attributes = attr.replaceAll("\\s", "").split("=")[1].split(WEEK_DAY_CRON_DELIMITER);
                    logger.debug("attributes " + String.valueOf(attributes));
                    safelist.addAttributes(tag, attributes);
                    logger.debug("safelist ", (Object)safelist);
                }
                logger.debug("------------SUPPORT-4163--------------");
            }
            catch (Exception e) {
                logger.debug("------------SUPPORT-4163--------------");
                logger.debug("entries in exception" + String.valueOf(entries));
                logger.debug(e.getMessage());
                logger.debug("------------SUPPORT-4163--------------");
            }
        }
        return Jsoup.clean(contents, safelist);
    }

    public static List<NotificationBean> getAllNotifications(List<Notification> notificationList) {
        ArrayList<NotificationBean> notifications = new ArrayList<NotificationBean>();
        if (notificationList == null || notificationList.isEmpty()) {
            return Collections.emptyList();
        }
        for (Notification notification : notificationList) {
            notifications.add(new NotificationBean(notification));
        }
        return notifications;
    }

    public static List<NotificationBean> getAllNotificationsForUser(List<NotificationCacheEntry> notificationList) {
        ArrayList<NotificationBean> notifications = new ArrayList<NotificationBean>();
        if (notificationList == null || notificationList.isEmpty()) {
            return Collections.emptyList();
        }
        for (NotificationCacheEntry notification : notificationList) {
            notifications.add(new NotificationBean(notification));
        }
        return notifications;
    }

    public static Query prepareQuery(String limit, String offset, String active, String filterProject) {
        try {
            Query query = Query.select();
            if (StringUtils.isNotBlank(limit) && StringUtils.isNotBlank(offset)) {
                int offsetVal = Integer.parseInt(offset);
                if (offsetVal < 0) {
                    offsetVal = 0;
                }
                query = query.limit(Integer.parseInt(limit)).offset(offsetVal);
            }
            if (StringUtils.isNotBlank(active)) {
                query = query.where("ACTIVE = ? ", new Object[]{Boolean.parseBoolean(active)});
                if (StringUtils.isNotBlank(filterProject)) {
                    query = query.where("ACTIVE = ? AND FILTER_PROJECT = ? AND TARGET_PROJECT = ? ", new Object[]{Boolean.parseBoolean(active), true, ":" + filterProject + ":"});
                }
            }
            query = query.order("ID DESC");
            return query;
        }
        catch (Exception e) {
            logger.debug("Exception while preparing the query", (Throwable)e);
            return null;
        }
    }

    public static boolean isAdminUser(UserManager userManager) {
        if (userManager == null || userManager.getRemoteUser() == null) {
            return false;
        }
        UserProfile user = userManager.getRemoteUser();
        UserKey userKey = user.getUserKey();
        return userManager.isAdmin(userKey) || userManager.isSystemAdmin(userKey);
    }

    public static boolean isUserInGroup(UserManager userManager, String group) {
        if (userManager == null || userManager.getRemoteUserKey() == null) {
            return false;
        }
        return userManager.isUserInGroup(userManager.getRemoteUserKey(), group);
    }

    public static String handleVars(LicenseCounter licenseCounter, String text) {
        if (text == null || text.isEmpty() || !text.contains("$ANNOUNCER_")) {
            return text;
        }
        Map<String, String> replacements = licenseCounter.getVarData();
        for (String key : replacements.keySet()) {
            text = text.replaceAll("\\$ANNOUNCER_" + key, replacements.get(key));
        }
        return text;
    }

    public static String generateCronExpression(Notification notification, long startTime) {
        logger.debug("Custom Recurrence Notification -- constructing recurring job");
        String cronExpression = null;
        SimpleDateFormat hours = new SimpleDateFormat("HH");
        SimpleDateFormat minutes = new SimpleDateFormat("mm");
        SimpleDateFormat seconds = new SimpleDateFormat("ss");
        String hh = hours.format(new Date(startTime));
        String mm4 = minutes.format(new Date(startTime));
        String ss = seconds.format(new Date(startTime));
        cronExpression = ss + " " + mm4 + " " + hh + " 1 * ? *";
        if (notification.getRecurringTypeOption()) {
            logger.debug("** Custom Recurrence Notification is of Recurring type **");
            String dayName = "";
            String recurringType = notification.getRecurringType();
            if (StringUtils.isNoneBlank(recurringType) && recurringType.equals("weekly")) {
                switch (notification.getDayOfWeek()) {
                    case 1: {
                        dayName = "MON";
                        break;
                    }
                    case 2: {
                        dayName = "TUE";
                        break;
                    }
                    case 3: {
                        dayName = "WED";
                        break;
                    }
                    case 4: {
                        dayName = "THU";
                        break;
                    }
                    case 5: {
                        dayName = "FRI";
                        break;
                    }
                    case 6: {
                        dayName = "SAT";
                        break;
                    }
                    case 7: {
                        dayName = "SUN";
                    }
                }
                cronExpression = ss + " " + mm4 + " " + hh + " ? * " + dayName + " *";
            }
            if (StringUtils.isNoneBlank(recurringType) && recurringType.equals("monthly")) {
                cronExpression = ss + " " + mm4 + " " + hh + " " + notification.getDayOfMonth() + " * ? *";
            }
            if (StringUtils.isNoneBlank(recurringType) && recurringType.equals("lastDayOfMonth")) {
                cronExpression = ss + " " + mm4 + " " + hh + " 28-31 * ? *";
            }
        } else if (notification.getRecurringWeeklyType().booleanValue() && StringUtils.isNotBlank(notification.getSelectedDays())) {
            String[] weekDays = notification.getSelectedDays().split("#");
            if (weekDays != null && weekDays.length > 0) {
                cronExpression = ss + " " + mm4 + " " + hh + " ? * " + AnnouncerHelper.getDays(weekDays) + " *";
            }
        } else {
            cronExpression = ss + " " + mm4 + " " + hh + " 1/1 * ? *";
        }
        return cronExpression;
    }

    public static String getDays(String[] weekDays) {
        StringBuilder sb = new StringBuilder();
        for (String day : weekDays) {
            sb.append(AnnouncerHelper.getDay(Integer.parseInt(day))).append(WEEK_DAY_CRON_DELIMITER);
        }
        return sb.substring(0, sb.length() - WEEK_DAY_CRON_DELIMITER.length());
    }

    public static String getDay(int dayIndex) {
        switch (dayIndex) {
            case 1: {
                return "SUN";
            }
            case 2: {
                return "MON";
            }
            case 3: {
                return "TUE";
            }
            case 4: {
                return "WED";
            }
            case 5: {
                return "THU";
            }
            case 6: {
                return "FRI";
            }
            case 7: {
                return "SAT";
            }
        }
        return "";
    }

    public static boolean isUserInTargetList(UserProfile user, String targetedUsers) {
        if (user == null || StringUtils.isBlank(targetedUsers)) {
            logger.debug("Current user or targeted users are null.\nCurrent User: {}\ntargetedUsers: {}", (Object)user, (Object)targetedUsers);
            return false;
        }
        boolean isUserTargeted = false;
        String currentUserKey = user.getUserKey().getStringValue().trim();
        for (String targetedUser : targetedUsers.split(WEEK_DAY_CRON_DELIMITER)) {
            String targetedUserKey;
            String[] userParts = targetedUser.split(":");
            if (userParts.length <= 0 || !StringUtils.equals(currentUserKey, targetedUserKey = userParts[0].trim())) continue;
            logger.debug("Current user is in the targeted users list.");
            isUserTargeted = true;
            break;
        }
        return isUserTargeted;
    }

    public static String getSupportBarHtml(SupportBarService supportBarService, String product) {
        try {
            return supportBarService.getHtml();
        }
        catch (Throwable e) {
            logger.error("Error getting support bar html", e);
            if (product == null || product.isEmpty()) {
                return "";
            }
            return String.format("Announcer for %s ", product.substring(0, 1) + product.toLowerCase().substring(1));
        }
    }
}

