/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.xwork;

import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.NotificationService;
import com.wittified.general.support.SupportBarService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.dto.NotificationCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSpaceAction
extends AbstractSpaceAdminAction {
    private final Logger logger = LoggerFactory.getLogger(ConfluenceSpaceAction.class);
    private LicenseCounter licenseCounter;
    private PluginLicenseManager licenseStorageManager;
    private NotificationService notificationService;
    private HttpContext httpContext;
    private SupportBarService supportBarService;
    public String projectKey = "";
    public NotificationCount notificationCount = null;

    public void setSupportBarService(SupportBarService supportBarService) {
        this.supportBarService = supportBarService;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void setLicenseCounter(LicenseCounter licenseCounter) {
        this.licenseCounter = licenseCounter;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setPluginLicenseManager(PluginLicenseManager licenseStorageManager) {
        this.licenseStorageManager = licenseStorageManager;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        String projectKey = this.getSpaceKey();
        this.logger.debug(this.licenseCounter.currentUserCanEdit(projectKey) + " they can edit?");
        if (this.licenseCounter.currentUserCanEdit(projectKey)) {
            this.projectKey = projectKey;
            this.notificationCount = this.notificationService.getNotificationCount(projectKey);
        }
        return "input";
    }

    public NotificationCount getNotificationCount() {
        return this.notificationCount;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public boolean getFilterProject() {
        return true;
    }

    public String getLicense() {
        return this.getCheckLicense();
    }

    public String getProduct() {
        return this.licenseCounter.getApplicationType();
    }

    public String getWittifiedXsfrToken() {
        return this.licenseCounter.getXsfrToken(this.httpContext.getRequest(), this.httpContext.getResponse());
    }

    public String getContextPath() {
        return this.getGlobalSettings().getBaseUrl();
    }

    public String getSupportbarHtml() {
        return AnnouncerHelper.getSupportBarHtml(this.supportBarService, this.licenseCounter.getApplicationType());
    }

    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }
}

