/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.wittified.licensecounters.LicenseCounter;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONException;

@Path(value="/picker")
public class PickerEndPoint {
    private final LicenseCounter licenseCounter;

    @Inject
    public PickerEndPoint(LicenseCounter licenseCounter) {
        this.licenseCounter = licenseCounter;
    }

    @GET
    @Path(value="/groups")
    public Response getGroupNames(@Context HttpServletRequest req) throws JSONException {
        String startString = req.getParameter("query");
        String excludedGroup = req.getParameter("exclude");
        return Response.ok((Object)this.licenseCounter.getGroupsStartingWith(startString, excludedGroup).toString()).build();
    }

    @GET
    @Path(value="/projects")
    public Response getProjectNames(@Context HttpServletRequest req) throws JSONException {
        String startString = req.getParameter("query");
        String excludedProject = req.getParameter("exclude");
        return Response.ok((Object)this.licenseCounter.getProjectsStartingWith(startString, excludedProject).toString()).build();
    }

    @GET
    @Path(value="/categories")
    public Response getProjectCategoryNames(@Context HttpServletRequest req) throws JSONException {
        String startString = req.getParameter("query");
        String excludedProject = req.getParameter("exclude");
        return Response.ok((Object)this.licenseCounter.getCategoriesStartingWith(startString, excludedProject).toString()).build();
    }

    @GET
    @Path(value="/projectRoles")
    public Response getProjectRoleNames(@Context HttpServletRequest req) throws JSONException {
        String startString = req.getParameter("query");
        String excludedProject = req.getParameter("exclude");
        return Response.ok((Object)this.licenseCounter.getProjectRolesStartingWith(startString, excludedProject).toString()).build();
    }
}

