/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.wittified.AnnouncerHelper;
import com.wittified.DisplayTypeHolder;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.format.FormatService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.NotificationBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/accept")
public class AcceptNotificationEndPoint {
    private final UserManager userManager;
    private final NotificationService notificationService;
    private final LicenseCounter licenseCounter;
    private final FormatService formatService;
    private static Logger logger = LoggerFactory.getLogger(AcceptNotificationEndPoint.class);

    @Inject
    public AcceptNotificationEndPoint(UserManager userManager, NotificationService notificationService, LicenseCounter licenseCounter, FormatService formatService) {
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseCounter = licenseCounter;
        this.formatService = formatService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/dialog")
    @AnonymousSiteAccess
    @AnonymousAllowed
    public Response getNotificationForDialog(@Context HttpServletRequest req) {
        List<NotificationCacheEntry> theNotifications;
        UserProfile user;
        CacheControl control = new CacheControl();
        control.setMaxAge(1);
        control.setNoCache(true);
        control.setNoStore(true);
        control.setPrivate(true);
        String target = null;
        if (req.getParameter("target") != null && !req.getParameter("target").equals("")) {
            target = req.getParameter("target");
        }
        if ((user = this.userManager.getRemoteUser()) == null) {
            String sessionId = AnnouncerHelper.getCookieName(req);
            if (sessionId == null || sessionId.equals("")) return Response.status((int)403).build();
            theNotifications = this.notificationService.getAllNotificationsForAnonymous(sessionId, "dialog").getEntries();
        } else {
            theNotifications = this.notificationService.getAllNotificationsForUser(user, "dialog").getEntries();
        }
        if (theNotifications.size() == 0) {
            return Response.ok().cacheControl(control).build();
        }
        NotificationCacheEntry theNotification = null;
        for (NotificationCacheEntry notification : theNotifications) {
            if (!this.displayNotification(notification, target) || !notification.getType().equals("dialog") || theNotification != null) continue;
            theNotification = notification;
        }
        if (theNotification == null) {
            return Response.ok().cacheControl(control).build();
        }
        NotificationBean notificationBean = new NotificationBean();
        notificationBean.setTitle(theNotification.getTitle());
        notificationBean.setType(theNotification.getType());
        notificationBean.setDisplay(DisplayTypeHolder.getIconHtml(theNotification.getDisplayType()));
        notificationBean.setDelayButton(theNotification.getDelayButton());
        notificationBean.setResetButton(theNotification.isResetButton());
        notificationBean.setFilterProject(theNotification.getFilterProject());
        if (theNotification.getFilterProject()) {
            notificationBean.setTargetProject(theNotification.getTargetProject());
        }
        notificationBean.setFilterGroups(theNotification.getFilterGroups());
        if (theNotification.getFilterGroups()) {
            notificationBean.setGroupTarget(theNotification.getGroupTarget());
        }
        if (theNotification.getHtml() == null) {
            notificationBean.setContents("");
        } else {
            notificationBean.setContents(this.formatService.formatThis(theNotification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, theNotification.getHtml())));
        }
        if (theNotification.getDisplayType() == 1) {
            notificationBean.setDisplay("warning");
        } else if (theNotification.getDisplayType() == 2) {
            notificationBean.setDisplay("info");
        } else if (theNotification.getDisplayType() == 3) {
            notificationBean.setDisplay("error");
        } else {
            notificationBean.setDisplay("info");
        }
        notificationBean.setCssClass(DisplayTypeHolder.getCss(theNotification.getDisplayType()));
        notificationBean.setButtonText(theNotification.getButtonText());
        notificationBean.setShowButton(theNotification.isShowButton());
        notificationBean.setIconHtml(DisplayTypeHolder.getIconHtml(theNotification.getDisplayType()));
        notificationBean.setID(theNotification.getID());
        return Response.ok((Object)notificationBean).cacheControl(control).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/flags")
    @AnonymousSiteAccess
    @AnonymousAllowed
    public Response getNotificationForFlags(@Context HttpServletRequest req) {
        List<NotificationCacheEntry> theNotifications;
        UserProfile user;
        CacheControl control = new CacheControl();
        control.setMaxAge(1);
        control.setNoCache(true);
        control.setNoStore(true);
        control.setPrivate(true);
        String target = null;
        if (req.getParameter("target") != null && !req.getParameter("target").equals("")) {
            target = req.getParameter("target");
        }
        if ((user = this.userManager.getRemoteUser()) == null) {
            String sessionId = AnnouncerHelper.getCookieName(req);
            if (sessionId == null || sessionId.equals("")) return Response.status((int)403).build();
            theNotifications = this.notificationService.getAllNotificationsForAnonymous(sessionId, "flag").getEntries();
        } else {
            theNotifications = this.notificationService.getAllNotificationsForUser(user, "flag").getEntries();
        }
        if (theNotifications.size() == 0) {
            return Response.ok().cacheControl(control).build();
        }
        ArrayList<NotificationBean> notificationBeans = new ArrayList<NotificationBean>();
        for (NotificationCacheEntry theNotification : theNotifications) {
            if (theNotification == null || !this.displayNotification(theNotification, target)) continue;
            NotificationBean notificationBean = new NotificationBean();
            notificationBean.setTitle(theNotification.getTitle());
            notificationBean.setDelayButton(theNotification.getDelayButton());
            notificationBean.setResetButton(theNotification.isResetButton());
            if (theNotification.getHtml() == null) {
                notificationBean.setContents("");
            } else {
                notificationBean.setContents(this.formatService.formatThis(theNotification.getFormat(), AnnouncerHelper.handleVars(this.licenseCounter, theNotification.getHtml())));
            }
            notificationBean.setCssClass(DisplayTypeHolder.getCss(theNotification.getDisplayType()));
            notificationBean.setButtonText(theNotification.getButtonText());
            notificationBean.setShowButton(theNotification.isShowButton());
            notificationBean.setID(theNotification.getID());
            notificationBean.setType(theNotification.getType());
            notificationBean.setDisplay(DisplayTypeHolder.getBannerType(theNotification.getDisplayType()));
            notificationBean.setIconHtml(DisplayTypeHolder.getIconHtml(theNotification.getDisplayType()));
            notificationBeans.add(notificationBean);
        }
        return Response.ok(notificationBeans).cacheControl(control).build();
    }

    private boolean displayNotification(NotificationCacheEntry notification, String projectKey) {
        if (notification.getFilterProject()) {
            if (projectKey == null) {
                return false;
            }
            if (notification.getTargetProject() == null) {
                return true;
            }
            return notification.getTargetProject().contains(":" + projectKey + ":");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AnonymousSiteAccess
    @AnonymousAllowed
    @Path(value="/accept")
    public Response acceptNotification(@Context HttpServletRequest req, Map<String, Object> params) {
        UserProfile user;
        int id = (Integer)params.get("id");
        CacheControl control = new CacheControl();
        control.setMaxAge(1);
        control.setNoCache(true);
        control.setNoStore(true);
        control.setPrivate(true);
        HashMap<String, String> status = new HashMap<String, String>();
        status.put("status", "failed");
        long currTime = System.currentTimeMillis();
        long dwellTime = -1L;
        String startTime = (String)params.get("loadTime");
        if (startTime != null) {
            dwellTime = currTime - Long.parseLong(startTime);
        }
        if ((user = this.userManager.getRemoteUser()) == null) {
            String sessionId = AnnouncerHelper.getCookieName(req);
            if (sessionId == null || sessionId.equals("")) return Response.status((int)403).build();
            if (!this.notificationService.confirmNotificationForAnonymous(id, sessionId, dwellTime)) return Response.ok(status).cacheControl(control).build();
            status.put("status", "success");
            return Response.ok(status).cacheControl(control).build();
        }
        Notification notification = this.notificationService.getThisNotification(id);
        if ("JIRA".equals(this.licenseCounter.getApplicationType()) && notification.getFilterProject()) {
            String projectKey;
            String string = projectKey = params.get("key") != null ? params.get("key").toString() : "";
            if (notification.getTargetProject() == null || !notification.getTargetProject().contains(":" + projectKey + ":") || !this.licenseCounter.doesUserHasBrowsePermissionOnProject(projectKey)) return Response.ok(status).cacheControl(control).build();
            boolean proceedWithAcknoledgement = true;
            if (notification.getFilterProjectRole() && StringUtils.isNotEmpty(notification.getTargetProjectRole())) {
                proceedWithAcknoledgement = this.licenseCounter.isUserInProjectRole(user, notification.getTargetProjectRole(), projectKey);
            }
            if (!proceedWithAcknoledgement || !this.notificationService.confirmNotificationForUser(id, user, dwellTime)) return Response.ok(status).cacheControl(control).build();
            status.put("status", "success");
            return Response.ok(status).cacheControl(control).build();
        }
        try {
            this.notificationService.confirmNotificationForUser(id, user, dwellTime);
            status.put("status", "success");
            return Response.ok(status).cacheControl(control).build();
        }
        catch (Exception e) {
            logger.error("Exception while acknowledging the notification", (Throwable)e);
        }
        return Response.ok(status).cacheControl(control).build();
    }
}

