/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.licensecounters;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.builder.EmailBuilder;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.AnnouncerDataService;
import com.wittified.ao.Notification;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.licensecounters.LicenseCounter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraLicenseCounter
implements LicenseCounter {
    private final AvatarService avatarService = ComponentAccessor.getAvatarService();
    private final com.atlassian.jira.user.util.UserManager userManager = ComponentAccessor.getUserManager();
    private final GroupManager groupManager = ComponentAccessor.getGroupManager();
    private final PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
    private final ProjectManager projectManager = ComponentAccessor.getProjectManager();
    private final UserManager salUserManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ApplicationProperties applicationProperties;
    private final ApplicationRoleManager applicationRoleManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final GroupPickerSearchService groupService;
    private final ProjectRoleManager projectRoleManager;
    private final AnnouncerDataService announcerDataService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nResolver i18nResolver;
    private final LoginService loginService;
    private static final Logger logger = LoggerFactory.getLogger(JiraLicenseCounter.class);

    public JiraLicenseCounter(UserManager salUserManager, PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties, ApplicationRoleManager applicationRoleManager, DateTimeFormatter dateTimeFormatter, GroupPickerSearchService groupService, ProjectRoleManager projectRoleManager, AnnouncerDataService announcerDataService, I18nResolver i18nResolver, LoginService loginService) {
        this.salUserManager = salUserManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.applicationProperties = applicationProperties;
        this.applicationRoleManager = applicationRoleManager;
        this.dateTimeFormatter = dateTimeFormatter;
        this.groupService = groupService;
        this.projectRoleManager = projectRoleManager;
        this.announcerDataService = announcerDataService;
        this.jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        this.i18nResolver = i18nResolver;
        this.loginService = loginService;
    }

    @Override
    public int getNumberOfUsers() {
        return this.getActiveUsers().size();
    }

    @Override
    public String getApplicationType() {
        return "JIRA";
    }

    @Override
    public String getAvatarURL(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        return this.avatarService.getAvatarAbsoluteURL(ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser(), user, Avatar.Size.MEDIUM).toString();
    }

    @Override
    public Map<String, String> getActiveUsers() {
        HashMap<String, String> users = new HashMap<String, String>();
        GroupManager groupManager = ComponentAccessor.getGroupManager();
        for (Group group : this.applicationRoleManager.getGroupsForLicensedRoles()) {
            for (ApplicationUser user : groupManager.getDirectUsersInGroup(group)) {
                users.put(user.getKey(), user.getName());
            }
        }
        return users;
    }

    @Override
    public Map<String, String> getAllProjects(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Project project : ComponentAccessor.getProjectManager().getProjectObjects()) {
            if (!ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user) && !ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user)) continue;
            retMap.put(project.getKey(), project.getName());
        }
        return retMap;
    }

    @Override
    public String getProjectKey(Object obj) {
        return null;
    }

    @Override
    public String getProductContainerName() {
        return "project";
    }

    @Override
    public int getNumUsersInGroup(String groupName) {
        Group group = this.groupManager.getGroup(groupName);
        if (group != null) {
            return this.groupManager.getUserNamesInGroup(groupName).size();
        }
        return -2;
    }

    @Override
    public List<String> getUserNamesInGroup(String groupName) {
        ArrayList<String> list = new ArrayList<String>();
        for (String username : this.groupManager.getUserNamesInGroup(groupName)) {
            list.add(username);
        }
        return list;
    }

    @Override
    public boolean currentUserCanEdit(String key) {
        String enabledProjectConfig = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (enabledProjectConfig == null) {
            enabledProjectConfig = "false";
        }
        if (enabledProjectConfig.equals("false")) {
            return false;
        }
        Project project = this.projectManager.getProjectObjByKey(key);
        if (project == null) {
            return false;
        }
        UserKey userKey = this.salUserManager.getRemoteUserKey();
        if (userKey == null) {
            return false;
        }
        ApplicationUser applicationUser = this.userManager.getUserByKey(userKey.getStringValue());
        return this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, applicationUser);
    }

    @Override
    public String getXsfrToken(HttpServletRequest request, HttpServletResponse response) {
        XsrfTokenGenerator xsrfTokenGenerator = (XsrfTokenGenerator)ComponentAccessor.getComponentOfType(XsrfTokenGenerator.class);
        return xsrfTokenGenerator.generateToken(request);
    }

    @Override
    public boolean validateXsfrToken(HttpServletRequest request, String token) {
        XsrfTokenGenerator xsrfTokenGenerator = (XsrfTokenGenerator)ComponentAccessor.getComponentOfType(XsrfTokenGenerator.class);
        return xsrfTokenGenerator.validateToken(request, token);
    }

    @Override
    public HttpServletResponse getResponseObject() {
        return ExecutingHttpRequest.getResponse();
    }

    @Override
    public HttpServletRequest getRequestObject() {
        return ExecutingHttpRequest.get();
    }

    @Override
    public Map<String, String> getVarData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("EMAIL", "");
        data.put("FULL_NAME", "Anonymous");
        data.put("USER_NAME", "anonymous");
        UserProfile currentUser = this.salUserManager.getRemoteUser();
        if (currentUser != null) {
            data.put("EMAIL", currentUser.getEmail());
            data.put("FULL_NAME", currentUser.getFullName());
            data.put("USER_NAME", currentUser.getUsername());
        }
        return data;
    }

    @Override
    public String getSkippedPaths() {
        return "/login.jsp|/plugins/servlet/oauth|/secure/admin/WebSudoAuthenticate|/secure/admin/authenticate.jsp|/logout|/plugins/servlet/applinks/|/plugins/servlet/streams|/rpc/|/rest/|/secure/useravatar|/secure/projectavatar|/plugins/servlet/upm|/plugins/servlet/wittified/admin/notifications";
    }

    @Override
    public boolean areFlagsSupported() {
        String version = this.applicationProperties.getVersion();
        if (version.startsWith("6.")) {
            return version.startsWith("6.4");
        }
        return true;
    }

    @Override
    public String getPluginKey() {
        return "com.wittified.atl-announcer-jira";
    }

    @Override
    public JSONObject getGroupsStartingWith(String startString, String excludeGroup) throws JSONException {
        return this.findGroupsAsBean(startString, excludeGroup);
    }

    public JSONObject findGroupsAsBean(String startString, String excludeGroups) throws JSONException {
        ArrayList<String> groupNames = Lists.newArrayList();
        JSONObject groupsContainer = new JSONObject();
        List groups = this.groupService.findGroups(startString);
        int total = this.limitGroupResults(groups, excludeGroups, groupNames, startString);
        groupsContainer.put("groups", groupNames);
        groupsContainer.put("total", total);
        return groupsContainer;
    }

    private int limitGroupResults(List<Group> groups, String excludeGroups, List<String> groupNames, String startString) {
        int limit = 20;
        int i = 0;
        int total = groups.size();
        for (Group group : groups) {
            if (i >= limit) break;
            if (!excludeGroups.equalsIgnoreCase(group.getName())) {
                groupNames.add(group.getName());
                ++i;
                continue;
            }
            --total;
        }
        return total;
    }

    @Override
    public String getProjectString(String pKeys) {
        logger.debug("pKeys:" + pKeys);
        ArrayList<Object> projectStrings = Lists.newArrayList();
        if (StringUtils.isEmpty(pKeys)) {
            pKeys = "";
        }
        List<String> keys = Arrays.asList(pKeys.split("::"));
        ListIterator<String> i = keys.listIterator();
        while (i.hasNext()) {
            i.set(i.next().replace(":", ""));
        }
        for (String key : keys) {
            if (key == "") continue;
            Object projectString = "";
            Project project = this.projectManager.getProjectObjByKey(key);
            if (project == null) continue;
            projectString = project.getName() + " (" + key + ")";
            projectStrings.add(projectString);
        }
        return String.join((CharSequence)",", projectStrings);
    }

    @Override
    public String parseDate(Date date) {
        return this.dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.RELATIVE).format(date);
    }

    @Override
    public JSONObject getProjectsStartingWith(String startString, String excludeProject) throws JSONException {
        return this.findProjectsAsBean(startString, excludeProject);
    }

    public JSONObject findProjectsAsBean(String startString, String excludeProjects) throws JSONException {
        ArrayList<String> projectNames = Lists.newArrayList();
        JSONObject projectsContainer = new JSONObject();
        List<Project> projects = this.getProjects().distinct().collect(Collectors.toList());
        int total = this.limitProjectResults(projects, excludeProjects, projectNames, startString);
        projectsContainer.put("results", projectNames);
        projectsContainer.put("total", total);
        return projectsContainer;
    }

    public Stream<Project> getProjects() {
        Collection browseProjects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser());
        Collection adminsterProjects = this.permissionManager.getProjects(ProjectPermissions.ADMINISTER_PROJECTS, ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser());
        return Stream.concat(browseProjects.stream(), adminsterProjects.stream());
    }

    private int limitProjectResults(List<Project> projects, String excludeProjects, List<String> projectNames, String startString) {
        int limit = 20;
        int i = 0;
        int total = projects.size();
        for (Project project : projects) {
            if (i >= limit) break;
            if (!excludeProjects.equalsIgnoreCase(project.getName())) {
                if (!project.getName().toLowerCase().startsWith(startString.toLowerCase())) continue;
                projectNames.add(project.getName() + " (" + project.getKey() + ")");
                ++i;
                continue;
            }
            --total;
        }
        return total;
    }

    @Override
    public boolean isProjInCategory(String[] categories, String projectKey) {
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        ProjectCategory category = this.projectManager.getProjectCategoryForProject(project);
        if (category == null) {
            return false;
        }
        return Arrays.asList(categories).contains(category.getName());
    }

    @Override
    public JSONObject getCategoriesStartingWith(String startString, String excludedCategory) throws JSONException {
        return this.findCategoriesAsBean(startString, excludedCategory);
    }

    private JSONObject findCategoriesAsBean(String startString, String excludedCategory) throws JSONException {
        ArrayList<String> categoryNames = Lists.newArrayList();
        JSONObject categoriesContainer = new JSONObject();
        Collection categories = this.projectManager.getAllProjectCategories();
        int total = this.limitProjectCategoryResults(categories, excludedCategory, categoryNames, startString);
        categoriesContainer.put("categories", categoryNames);
        categoriesContainer.put("total", total);
        return categoriesContainer;
    }

    private int limitProjectCategoryResults(Collection<ProjectCategory> categories, String excludedCategory, List<String> projectCategoryNames, String startString) {
        int limit = 20;
        int i = 0;
        int total = categories.size();
        for (ProjectCategory category : categories) {
            if (i >= limit) break;
            if (!excludedCategory.equalsIgnoreCase(category.getName())) {
                if (!category.getName().toLowerCase().startsWith(startString.toLowerCase())) continue;
                projectCategoryNames.add(category.getName());
                ++i;
                continue;
            }
            --total;
        }
        return total;
    }

    @Override
    public JSONObject getProjectRolesStartingWith(String startString, String excludedProjectRole) throws JSONException {
        ArrayList<String> projectRoleNames = Lists.newArrayList();
        JSONObject projectRolesContainer = new JSONObject();
        List<ProjectRole> projectRoles = this.projectRoleManager.getProjectRoles().stream().collect(Collectors.toList());
        int total = this.limitProjectRoleResults(projectRoles, excludedProjectRole, projectRoleNames, startString);
        projectRolesContainer.put("results", projectRoleNames);
        projectRolesContainer.put("total", total);
        return projectRolesContainer;
    }

    private int limitProjectRoleResults(List<ProjectRole> projectRoles, String excludedProjectRole, List<String> projectRoleNames, String startString) {
        int limit = 20;
        int i = 0;
        int total = projectRoles.size();
        for (ProjectRole role : projectRoles) {
            if (i >= limit) break;
            if (!excludedProjectRole.equalsIgnoreCase(role.getName())) {
                if (!role.getName().toLowerCase().startsWith(startString.toLowerCase())) continue;
                projectRoleNames.add(role.getName());
                ++i;
                continue;
            }
            --total;
        }
        return total;
    }

    @Override
    public List<String> getAllProjectRoles() {
        return this.projectRoleManager.getProjectRoles().stream().map(role -> role.getName()).collect(Collectors.toList());
    }

    @Override
    public List<String> getAllCategories() {
        return this.projectManager.getAllProjectCategories().stream().map(category -> category.getName()).collect(Collectors.toList());
    }

    @Override
    public boolean isGroupExists(String groupName) {
        return this.groupManager.getGroup(groupName) != null;
    }

    @Override
    public boolean isNewUser(UserProfile user) {
        if (user == null) {
            return false;
        }
        LoginInfo loginInfo = this.loginService.getLoginInfo(user.getUsername());
        return loginInfo != null && loginInfo.getLoginCount() == 1L;
    }

    @Override
    public boolean projectDoesNotExist(String key) {
        logger.debug("Check if Jira project exist for project key:" + key + ":projectManager.getProjectByCurrentKey(key):" + String.valueOf(this.projectManager.getProjectByCurrentKey(key)));
        return this.projectManager.getProjectByCurrentKey(key) == null;
    }

    @Override
    public boolean doesUserHasBrowsePermissionOnProject(String key) {
        logger.debug("Project key:" + key);
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, this.projectManager.getProjectByCurrentKey(key), ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser());
    }

    @Override
    public boolean isUserInProjectRole(UserProfile user, String targetedProjectRoles, String projectKey) {
        Project targetProject = ComponentAccessor.getProjectManager().getProjectByCurrentKey(projectKey);
        for (String role : targetedProjectRoles.split(",")) {
            if (!this.projectRoleManager.isUserInProjectRole(this.userManager.getUserByName(user.getUsername()), this.projectRoleManager.getProjectRole(role), targetProject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentUserKey() {
        return this.jiraAuthenticationContext.getLoggedInUser().getKey();
    }

    @Override
    public void sendEmail(Notification theNotification, String toUserKey, String exportedFilePath) {
        ApplicationUser user = this.userManager.getUserByKey(toUserKey);
        NotificationRecipient notificationRecipient = new NotificationRecipient(user);
        SMTPMailServer mailServer = MailFactory.getServerManager().getDefaultSMTPMailServer();
        if (mailServer == null) {
            this.announcerDataService.saveNotificationExportStatus(theNotification, false);
            return;
        }
        SingleMailQueueItem mailQueueItem = null;
        Email email = new Email(mailServer.getDefaultFrom());
        email.setTo(user.getEmailAddress());
        email.setFrom(mailServer.getDefaultFrom());
        email.setFromName(mailServer.getDefaultFrom());
        String subjectTemplate = this.i18nResolver.getText("wittified.announcer.admin.report.mail.subject", new Serializable[]{this.getApplicationType(), theNotification.getTitle()});
        WeakHashMap<String, String> context = new WeakHashMap<String, String>();
        context.put("firstname", user.getDisplayName());
        context.put("reportName", theNotification.getTitle());
        context.put("exportedFilePath", exportedFilePath);
        try {
            mailQueueItem = new EmailBuilder(email, notificationRecipient).withBodyFromFile("templates/activity-report-email-body.vm").withSubject(subjectTemplate).addParameters(context).renderNowAsQueueItem();
        }
        catch (MessagingException e) {
            e.printStackTrace();
            logger.error("Unable to send email: " + e.getMessage());
        }
        ComponentAccessor.getMailQueue().addItem(mailQueueItem);
        logger.debug("Announcer - Mail sent");
    }

    @Override
    public void scheduleAnnouncerReportJob(int id) {
    }

    @Override
    public boolean displayNotification(NotificationCacheEntry notification, String projectKey) {
        boolean isDisplayProject = true;
        boolean isDisplayCategory = true;
        boolean isDisplayGroup = true;
        boolean isFilterProject = false;
        boolean isFilterCategory = false;
        boolean isFilterGroup = false;
        UserProfile user = this.salUserManager.getRemoteUser();
        if (notification.getFilterUser()) {
            boolean isUserTargeted = AnnouncerHelper.isUserInTargetList(user, notification.getTargetUser());
            if (isUserTargeted) {
                logger.debug("User: " + user.getUsername() + " is targeted for the announcement " + notification.getTitle());
                return true;
            }
            logger.debug("User: " + user.getUsername() + " is not targeted for the announcement " + notification.getTitle());
            return false;
        }
        if (notification.isNewUser && !this.isNewUser(this.salUserManager.getRemoteUser())) {
            return false;
        }
        if (notification.getFilterProject()) {
            isFilterProject = true;
            if (projectKey == null) {
                return false;
            }
            if (notification.getTargetProject() != null) {
                if (!notification.getTargetProject().contains(":" + projectKey + ":")) {
                    isDisplayProject = false;
                } else if (notification.getFilterProjectRole() && !this.isUserInProjectRole(this.salUserManager.getRemoteUser(), notification.getTargetProjectRole(), projectKey)) {
                    isDisplayProject = false;
                }
            } else {
                isDisplayProject = false;
            }
        }
        if (notification.getFilterProjectCategory()) {
            String[] categories;
            isFilterCategory = true;
            if (projectKey == null) {
                logger.debug("Returning project key false");
                return false;
            }
            if (notification.getTargetProjectCategories() != null && !this.isProjInCategory(categories = notification.getTargetProjectCategories().split(","), projectKey)) {
                isDisplayCategory = false;
            }
        }
        if (notification.getFilterGroups()) {
            isFilterGroup = true;
            isDisplayGroup = this.isUserInGroups(this.salUserManager.getRemoteUserKey(), notification);
        }
        if (isFilterProject && isFilterCategory) {
            if (isFilterGroup) {
                return (isDisplayCategory || isDisplayProject) && isDisplayGroup;
            }
            return isDisplayCategory || isDisplayProject;
        }
        if (isFilterCategory) {
            if (isFilterGroup) {
                return isDisplayCategory && isDisplayGroup;
            }
            return isDisplayCategory;
        }
        if (isFilterProject) {
            logger.debug("isFilterProject:" + isFilterProject);
            logger.debug("isDisplayGroup:" + isDisplayGroup);
            if (isFilterGroup) {
                logger.debug("isDisplayProject && isDisplayGroup:" + (isDisplayProject && isDisplayGroup));
                return isDisplayProject && isDisplayGroup;
            }
            logger.debug("isDisplayProject:" + isDisplayProject);
            return isDisplayProject;
        }
        if (isFilterGroup) {
            return isDisplayGroup;
        }
        return true;
    }

    private boolean isUserInGroups(UserKey userkey, NotificationCacheEntry notification) {
        String[] groups = notification.getGroupTarget().split(",");
        boolean found = false;
        for (String group : groups) {
            if (!this.salUserManager.isUserInGroup(userkey, group)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public List<String> getAllGroups(String user) {
        Iterable groups = this.salUserManager.findGroupNamesByPrefix("", 0, 100000);
        ArrayList<String> allGroups = new ArrayList<String>();
        for (String group : groups) {
            allGroups.add(group);
        }
        return allGroups;
    }

    @Override
    public boolean isUserExists(String username) {
        return this.salUserManager.getUserProfile(username) != null;
    }
}

