/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import org.parboiled.common.Preconditions;
import org.parboiled.trees.MutableBinaryTreeNode;
import org.parboiled.trees.MutableTreeNode;
import org.parboiled.trees.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtils {
    private TreeUtils() {
    }

    public static <T extends TreeNode<T>> T getRoot(T t2) {
        if (t2 == null) {
            return null;
        }
        if (t2.getParent() != null) {
            return TreeUtils.getRoot(t2.getParent());
        }
        return t2;
    }

    public static <T extends MutableTreeNode<T>> void addChild(T t2, T t3) {
        Preconditions.checkArgNotNull(t2, "parent");
        t2.addChild(t2.getChildren().size(), t3);
    }

    public static <T extends MutableTreeNode<T>> void removeChild(T t2, T t3) {
        Preconditions.checkArgNotNull(t2, "parent");
        int n = t2.getChildren().indexOf(t3);
        Preconditions.checkElementIndex(n, t2.getChildren().size());
        t2.removeChild(n);
    }

    public static <N extends MutableBinaryTreeNode<N>> N toLeftAssociativity(N n) {
        Preconditions.checkArgNotNull(n, "node");
        MutableBinaryTreeNode mutableBinaryTreeNode = (MutableBinaryTreeNode)n.right();
        if (mutableBinaryTreeNode == null) {
            return n;
        }
        n.setRight((MutableBinaryTreeNode)((MutableBinaryTreeNode)mutableBinaryTreeNode.left()));
        mutableBinaryTreeNode.setLeft(n);
        return (N)mutableBinaryTreeNode;
    }
}

