/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.licensecounters;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.stash.avatar.AvatarRequest;
import com.atlassian.stash.avatar.AvatarService;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectService;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.PermissionValidationService;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.wittified.ao.Notification;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.licensecounters.LicenseCounter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StashLicenseCounter
implements LicenseCounter {
    private final Logger logger = LoggerFactory.getLogger(StashLicenseCounter.class);
    private final LicenseService licenseService;
    private final AvatarService avatarService;
    private final UserService userService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final ProjectService projectService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final RequestManager requestManager;
    private final UserManager salUserManager;
    private final ApplicationProperties applicationProperties;

    public StashLicenseCounter(LicenseService licenseService, AvatarService avatarService, UserService userService, PermissionService permissionService, ProjectService projectService, PermissionValidationService permissionValidationService, PluginSettingsFactory pluginSettingsFactory, XsrfTokenAccessor xsrfTokenAccessor, RequestManager requestManager, UserManager salUserManager, ApplicationProperties applicationProperties) {
        this.licenseService = licenseService;
        this.avatarService = avatarService;
        this.userService = userService;
        this.permissionService = permissionService;
        this.projectService = projectService;
        this.permissionValidationService = permissionValidationService;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.requestManager = requestManager;
        this.salUserManager = salUserManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public int getNumberOfUsers() {
        return this.licenseService.getLicensedUsersCount();
    }

    @Override
    public String getApplicationType() {
        return "STASH";
    }

    @Override
    public String getAvatarURL(String username) {
        AvatarRequest avatarRequest = new AvatarRequest(false, 45);
        return this.avatarService.getUrlForPerson((Person)this.userService.getUserByName(username), avatarRequest);
    }

    @Override
    public Map<String, String> getActiveUsers() {
        PageRequestImpl pageRequest = new PageRequestImpl(0, 100000);
        HashMap<String, String> userMap = new HashMap<String, String>();
        for (StashUser stashUser : this.permissionService.getGrantedUsers(Permission.LICENSED_USER, (PageRequest)pageRequest).getValues()) {
            userMap.put(stashUser.getName(), stashUser.getName());
        }
        for (String groupName : this.permissionService.getGrantedGroups(Permission.LICENSED_USER, (PageRequest)pageRequest).getValues()) {
            for (StashUser stashUser : this.userService.findUsersByGroup(groupName, (PageRequest)pageRequest).getValues()) {
                userMap.put(stashUser.getName(), stashUser.getName());
            }
        }
        return userMap;
    }

    @Override
    public Map<String, String> getAllProjects(String username) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (String k : this.projectService.findAllKeys()) {
            Project project = this.projectService.getByKey(k);
            retMap.put(k, project.getName());
        }
        return retMap;
    }

    @Override
    public String getProjectKey(Object obj) {
        HttpServletRequest request = (HttpServletRequest)obj;
        if (request.getRequestURI() == null || request.getRequestURI().isEmpty()) {
            return null;
        }
        String projectKey = null;
        String mvcStartPath = request.getContextPath() + "/mvc/projects/";
        String nonmvcStartPath = request.getContextPath() + "/projects/";
        String manipulationPath = null;
        if (request.getRequestURI().startsWith(mvcStartPath)) {
            manipulationPath = request.getRequestURI().substring(mvcStartPath.length());
        } else if (request.getRequestURI().startsWith(nonmvcStartPath)) {
            manipulationPath = request.getRequestURI().substring(nonmvcStartPath.length());
        } else {
            return null;
        }
        this.logger.debug("Manip path: " + manipulationPath);
        if (!manipulationPath.isEmpty()) {
            projectKey = manipulationPath.contains("/") ? manipulationPath.substring(0, manipulationPath.indexOf("/")) : manipulationPath;
            this.logger.debug("projectKey: " + projectKey);
            try {
                if (this.projectService.getByKey(projectKey) != null) {
                    return projectKey;
                }
            }
            catch (Exception e) {
                this.logger.debug("Error accessing project: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public HttpServletResponse getResponseObject() {
        return (HttpServletResponse)this.requestManager.getRequestContext().getRawResponse();
    }

    @Override
    public HttpServletRequest getRequestObject() {
        return (HttpServletRequest)this.requestManager.getRequestContext().getRawRequest();
    }

    @Override
    public String getProductContainerName() {
        return "project";
    }

    @Override
    public int getNumUsersInGroup(String groupName) {
        PageRequestImpl pageRequest = new PageRequestImpl(0, 0x100000);
        int c = 0;
        for (StashUser stashUser : this.userService.findUsersByGroup(groupName, (PageRequest)pageRequest).getValues()) {
            ++c;
        }
        return c;
    }

    @Override
    public List<String> getUserNamesInGroup(String groupName) {
        ArrayList<String> list = new ArrayList<String>();
        PageRequestImpl pageRequest = new PageRequestImpl(0, 0x100000);
        for (StashUser stashUser : this.userService.findUsersByGroup(groupName, (PageRequest)pageRequest).getValues()) {
            list.add(stashUser.getName());
        }
        return list;
    }

    @Override
    public boolean currentUserCanEdit(String key) {
        String enabledProjectConfig = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (enabledProjectConfig == null) {
            enabledProjectConfig = "false";
        }
        if (enabledProjectConfig.equals("false")) {
            return false;
        }
        Project project = this.projectService.getByKey(key);
        if (project == null) {
            return false;
        }
        try {
            this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
        }
        catch (AuthorisationException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getXsfrToken(HttpServletRequest request, HttpServletResponse response) {
        return this.xsrfTokenAccessor.getXsrfToken(request, response, true);
    }

    @Override
    public boolean validateXsfrToken(HttpServletRequest request, String token) {
        if (token == null || token.isEmpty()) {
            return false;
        }
        String requestToken = this.xsrfTokenAccessor.getXsrfToken(request, null, false);
        return requestToken.equals(token);
    }

    @Override
    public Map<String, String> getVarData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("EMAIL", "");
        data.put("FULL_NAME", "Anonymous");
        data.put("USER_NAME", "anonymous");
        UserProfile currentUser = this.salUserManager.getRemoteUser();
        if (currentUser != null) {
            data.put("EMAIL", currentUser.getEmail());
            data.put("FULL_NAME", currentUser.getFullName());
            data.put("USER_NAME", currentUser.getUsername());
        }
        return data;
    }

    @Override
    public String getSkippedPaths() {
        return "/scm/|/plugins/servlet/upm|/plugins/servlet/wittified/admin/notifications|/admin/backups|/mvc/maintenance|/unavailable|/rest/keys";
    }

    @Override
    public boolean areFlagsSupported() {
        String version = this.applicationProperties.getVersion();
        if (version.startsWith("2.")) {
            return false;
        }
        if (version.startsWith("3.")) {
            return version.startsWith("3.11") || version.startsWith("3.10") || version.startsWith("3.9");
        }
        return true;
    }

    @Override
    public String getPluginKey() {
        return "com.wittified.atl-announcer-stash";
    }

    @Override
    public String getProjectString(String targetProject) {
        return null;
    }

    @Override
    public JSONObject getGroupsStartingWith(String startString, String excludeGroup) throws JSONException {
        return null;
    }

    @Override
    public String parseDate(Date date) {
        return null;
    }

    @Override
    public JSONObject getProjectsStartingWith(String startString, String excludeProject) throws JSONException {
        return null;
    }

    @Override
    public boolean isProjInCategory(String[] categories, String projectKey) {
        return false;
    }

    @Override
    public JSONObject getCategoriesStartingWith(String startString, String excludedProject) throws JSONException {
        return null;
    }

    @Override
    public JSONObject getProjectRolesStartingWith(String startString, String excludedProject) throws JSONException {
        return null;
    }

    @Override
    public List<String> getAllProjectRoles() {
        return null;
    }

    @Override
    public List<String> getAllCategories() {
        return null;
    }

    @Override
    public boolean isGroupExists(String groupName) {
        return false;
    }

    @Override
    public boolean isNewUser(UserProfile remoteUser) {
        return false;
    }

    @Override
    public boolean projectDoesNotExist(String key) {
        return false;
    }

    @Override
    public boolean doesUserHasBrowsePermissionOnProject(String key) {
        return false;
    }

    @Override
    public boolean isUserInProjectRole(UserProfile user, String targetedProjectRoles, String projectKey) {
        return false;
    }

    @Override
    public String getCurrentUserKey() {
        return null;
    }

    @Override
    public void sendEmail(Notification theNotification, String toUserEmail, String exportedFilePath) {
    }

    @Override
    public void scheduleAnnouncerReportJob(int id) {
    }

    @Override
    public boolean displayNotification(NotificationCacheEntry notification, String projectKey) {
        return false;
    }

    @Override
    public List<String> getAllGroups(String user) {
        return null;
    }

    @Override
    public boolean isUserExists(String username) {
        return false;
    }
}

