/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets.statuspage;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.wittified.ao.statuspage.Incident;
import com.wittified.ao.statuspage.IncidentUpdate;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.statuspage.StatusPageService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPageIncidentServlet
extends HttpServlet {
    private static final long serialVersionUID = -5888852654369617648L;
    private static Logger logger = LoggerFactory.getLogger(StatusPageIncidentServlet.class);
    private final StatusPageService statusPageService;
    private final LicenseCounter licenseCounter;
    private final PluginSettings settings;

    public StatusPageIncidentServlet(StatusPageService statusPageService, TemplateRenderer templateRenderer, LicenseCounter licenseCounter, UserManager userManager, PluginSettingsFactory settingsFactory) {
        this.statusPageService = statusPageService;
        this.licenseCounter = licenseCounter;
        this.settings = settingsFactory.createSettingsForKey("com.wittified.atl-announcer:atl-announcer");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out;
        boolean badResponse = false;
        JSONObject json = new JSONObject();
        if (StringUtils.isNotBlank(req.getParameter("key"))) {
            JSONArray jsonUpdates = new JSONArray();
            String key = req.getParameter("key");
            Incident incident = this.statusPageService.getIncident(key);
            Properties props = (Properties)this.settings.get("com.wittified.atl-announcer:atl-announcer:token-config");
            if (props == null) {
                badResponse = true;
            } else {
                String baseUrl = props.getProperty("baseUrl");
                String apiToken = props.getProperty("apiToken");
                String applicationType = props.getProperty("applicationType");
                List<JSONObject> pages = null;
                try {
                    IncidentUpdate[] updates;
                    pages = this.statusPageService.getPages(baseUrl, apiToken, applicationType);
                    JSONObject pageObject = this.getPageObject(incident.getStatusPageConfig().getPage(), pages);
                    json.put("page", (Object)pageObject.getString("name"));
                    json.put("id", incident.getID());
                    json.put("config", (Object)incident.getStatusPageConfig().getTitle());
                    json.put("status", incident.getStatus());
                    json.put("startDate", (Object)this.licenseCounter.parseDate(incident.getStartDate()));
                    json.put("updatedDate", (Object)this.licenseCounter.parseDate(incident.getUpdatedDate()));
                    json.put("tittle", (Object)incident.getTitle());
                    for (IncidentUpdate update : updates = incident.getUpdates()) {
                        JSONObject jsonUpdate = new JSONObject();
                        jsonUpdate.put("status", (Object)StringUtils.capitalize(update.getStatus()));
                        jsonUpdate.put("key", (Object)update.getKey());
                        jsonUpdate.put("updateDate", (Object)this.licenseCounter.parseDate(update.getUpdateDate()));
                        jsonUpdate.put("message", (Object)update.getMessage());
                        jsonUpdates.put((Object)jsonUpdate);
                    }
                    json.put("updates", (Object)jsonUpdates);
                }
                catch (Exception e) {
                    logger.debug("Error while fetching Incident: " + e.getMessage());
                    badResponse = true;
                }
            }
        } else {
            badResponse = true;
        }
        if (badResponse) {
            res.setContentType("application/json");
            res.setCharacterEncoding("UTF-8");
            out = res.getWriter();
            out.print("Error while fetching Incident");
        } else {
            res.setContentType("application/json");
            res.setCharacterEncoding("UTF-8");
            out = res.getWriter();
            out.print(json);
        }
    }

    private JSONObject getPageObject(String pageKey, List<JSONObject> pages) throws JSONException {
        JSONObject pageObject = null;
        for (JSONObject object : pages) {
            if (!object.getString("id").equalsIgnoreCase(pageKey)) continue;
            pageObject = object;
            break;
        }
        return pageObject;
    }
}

