/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceTemporalAnnouncementJob
implements JobRunner {
    private final Logger logger = LoggerFactory.getLogger(ConfluenceTemporalAnnouncementJob.class);
    private final NotificationService notificationService;

    public ConfluenceTemporalAnnouncementJob(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            Date now = new Date();
            List<Notification> notifications = this.notificationService.getAllNotifications();
            if (CollectionUtils.isEmpty(notifications)) {
                return JobRunnerResponse.success();
            }
            for (Notification notification : notifications) {
                if (notification == null) continue;
                this.notificationService.handleNotificationStatus(notification, now);
            }
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return JobRunnerResponse.failed((Throwable)e);
        }
    }
}

