/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.ao.NotificationToNotificationUser;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.NotificationBean;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class ActivityReportServlet
extends HttpServlet {
    private final NotificationService notificationService;
    private final UserManager userManager;
    private final LicenseCounter licenseCounter;
    private final TemplateRenderer templateRenderer;
    private final ApplicationProperties applicationProperties;
    private final Logger logger = LoggerFactory.getLogger(ActivityReportServlet.class);

    public ActivityReportServlet(NotificationService notificationService, UserManager userManager, LicenseCounter licenseCounter, TemplateRenderer templateRenderer, ApplicationProperties applicationProperties) {
        this.notificationService = notificationService;
        this.userManager = userManager;
        this.licenseCounter = licenseCounter;
        this.templateRenderer = templateRenderer;
        this.applicationProperties = applicationProperties;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pKey;
        int id;
        Notification theNotification;
        response.setContentType("text/html");
        boolean block = true;
        UserProfile currUser = this.userManager.getRemoteUser();
        if (currUser != null && AnnouncerHelper.isAdminUser(this.userManager)) {
            block = false;
        } else if (currUser != null && (theNotification = this.notificationService.getThisNotification(id = Integer.parseInt(request.getParameter("id")))) != null && theNotification.getFilterProject() && theNotification.getTargetProject() != null && (pKey = theNotification.getTargetProject()) != null) {
            pKey = pKey.replaceAll(":", "");
            if (theNotification.getTargetProject().contains(pKey) && this.licenseCounter.currentUserCanEdit(pKey)) {
                block = false;
            }
        }
        if (!block) {
            id = Integer.parseInt(request.getParameter("id"));
            theNotification = this.notificationService.getThisNotification(id);
            if (theNotification == null) {
                response.sendError(404);
                return;
            }
            int numAnonUsers = 0;
            int numRealUsers = 0;
            long totalRealDwellTime = 0L;
            long totalAnonDwellTime = this.notificationService.getTotalAnonDwellTime(theNotification.getID());
            if (theNotification.getNumAnon() != null) {
                numAnonUsers = theNotification.getNumAnon();
            }
            numAnonUsers += theNotification.getAnonUsers().length;
            for (NotificationToNotificationUser notificationToNotificationUser : this.notificationService.getNotificationToUser(theNotification.getID())) {
                if (notificationToNotificationUser.getDwellTime() != null) {
                    totalRealDwellTime += notificationToNotificationUser.getDwellTime().longValue();
                }
                ++numRealUsers;
            }
            float averageAnonDwellTime = 0.0f;
            if (numAnonUsers > 0) {
                averageAnonDwellTime = totalAnonDwellTime / (long)numAnonUsers;
            }
            float averageUserDwellTime = 0.0f;
            if (numRealUsers > 0) {
                averageUserDwellTime = totalRealDwellTime / (long)numRealUsers;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType())) {
                context.put("displayHeader", false);
            } else {
                context.put("displayHeader", true);
            }
            DecimalFormat format = new DecimalFormat("0.00");
            context.put("averageAnonDwellTime", format.format(averageAnonDwellTime / 1000.0f));
            context.put("averageUserDwellTime", format.format(averageUserDwellTime / 1000.0f));
            context.put("totalAnonUsers", numAnonUsers);
            context.put("totalUserUsers", numRealUsers);
            context.put("helper", (Object)this);
            context.put("targetingUsers", theNotification.getFilterUser());
            context.put("notification", new NotificationBean(this.notificationService.getThisNotification(id)));
            context.put("product", this.licenseCounter.getApplicationType());
            String exportedFileDirectory = this.applicationProperties.getHomeDirectory().getAbsolutePath() + "/announcer_report_export/";
            String fileName = "notification_report_" + theNotification.getTitle() + "_" + theNotification.getID() + ".csv";
            String exportedFilePath = exportedFileDirectory.concat(fileName);
            context.put("exportedFilePath", exportedFilePath);
            context.put("currentUserEmail", this.userManager.getRemoteUser().getEmail());
            this.render("/templates/activity-report.vm", context, response);
        } else {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            response.setContentType("text/html");
            this.render("/templates/security-breach.vm", context, response);
        }
    }

    public String escapeEcmaScript(String stringToEscape) {
        return AnnouncerHelper.escapeEcmaScript(stringToEscape);
    }

    public UserProfile getUser(String user) {
        return this.userManager.getUserProfile(user);
    }

    public String getDecorator() {
        if ("CONFLUENCE".equals(this.licenseCounter.getApplicationType())) {
            return "atl.general";
        }
        return "atl.admin";
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }
}

