/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.rest;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.wittified.ao.NotificationService;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/profile")
public class UserProfileEndPoint {
    private final UserManager userManager;
    private final NotificationService notificationService;

    @Inject
    public UserProfileEndPoint(UserManager userManager, NotificationService notificationService) {
        this.userManager = userManager;
        this.notificationService = notificationService;
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/reset")
    public Response acceptNotification(@Context HttpServletRequest req, Map<String, String> data) {
        int id = Integer.parseInt(data.get("id"));
        CacheControl control = new CacheControl();
        control.setMaxAge(1);
        control.setNoCache(true);
        control.setNoStore(true);
        control.setPrivate(true);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null) {
            this.notificationService.unConfirmThisNotificationForUser(id, user);
        }
        return Response.ok().cacheControl(control).build();
    }
}

