/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableMap;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.RecurringAnnouncementJobRunnerImpl;
import com.wittified.job.RecurringAnnouncementScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecurringAnnouncementSchedulerImpl
implements RecurringAnnouncementScheduler {
    private static Logger logger = LoggerFactory.getLogger(RecurringAnnouncementSchedulerImpl.class);
    private final SchedulerService schedulerService;
    private final NotificationService notificationService;

    public RecurringAnnouncementSchedulerImpl(SchedulerService schedulerService, NotificationService notificationService) {
        this.schedulerService = schedulerService;
        this.notificationService = notificationService;
    }

    @Override
    public void schedule(String cronExpression, Notification notification) {
        try {
            logger.debug(String.format("In schedule method for cron %s", cronExpression));
            logger.debug("For Notification ::: " + notification);
            String jobRunnerKey = String.format("Recurring Job for Notification: %s", notification.getTitle());
            this.schedulerService.registerJobRunner(JobRunnerKey.of((String)jobRunnerKey), (JobRunner)new RecurringAnnouncementJobRunnerImpl(this, this.notificationService));
            Schedule schedule = Schedule.forCronExpression((String)cronExpression);
            String recurringType = "";
            if (cronExpression.contains("28-31")) {
                recurringType = "lastDayOfMonthRecurring";
            }
            logger.debug(String.valueOf(schedule.getCronScheduleInfo()));
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)jobRunnerKey)).withSchedule(schedule).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters(ImmutableMap.of("NOTIFICATION_ID", notification.getID(), "RECURRING_TYPE", recurringType));
            JobId jobId = JobId.of((String)String.valueOf(notification.getID()));
            this.schedulerService.scheduleJob(jobId, jobConfig);
            logger.debug(String.valueOf(jobId));
            logger.debug(String.valueOf(jobConfig));
            logger.debug(String.format("Job scheduled for %s", jobConfig.getSchedule()));
        }
        catch (SchedulerServiceException e) {
            e.printStackTrace();
            logger.warn("Failed to schedule recurring notifications job", (Throwable)e);
        }
    }

    @Override
    public void reschedule(String cronExpression, Notification notification) {
        logger.debug("Rescheduling with new cron expression...." + cronExpression);
        JobId jobId = JobId.of((String)String.valueOf(notification.getID()));
        this.schedulerService.unscheduleJob(jobId);
        this.schedule(cronExpression, notification);
        logger.debug("Rescheduling done!");
    }

    @Override
    public void unscheduleJob(Notification notification) {
        JobId jobId = JobId.of((String)String.valueOf(notification.getID()));
        this.schedulerService.unscheduleJob(jobId);
    }
}

