/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.analytics;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.google.common.collect.Lists;
import com.wittified.licensecounters.BitBucketLicenseCounter;
import com.wittified.licensecounters.ConfluenceLicenseCounter;
import com.wittified.licensecounters.JiraLicenseCounter;
import com.wittified.licensecounters.LicenseCounter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    protected static final Logger log = LoggerFactory.getLogger(Util.class);
    public static final String JIRA_SOFTWARE_KEY_NAME = "jiraSoftware";
    public static final String JIRA_CORE_NAME = "JIRA Core";
    public static final String JIRA_SOFTWARE_NAME = "JIRA Software";

    public static Map<String, Object> getPluginInfo(LicenseCounter licenseCounter, PluginLicenseManager licenseManager) {
        PluginAccessor pluginAccessor;
        log.debug("Building plugin  data...");
        HashMap<String, Object> pluginAnalyticsData = new HashMap<String, Object>();
        if (licenseCounter instanceof JiraLicenseCounter) {
            pluginAccessor = ComponentAccessor.getPluginAccessor();
            pluginAnalyticsData.put("pluginVersion", Util.getPluginVersion(licenseManager, pluginAccessor));
        }
        if (licenseCounter instanceof ConfluenceLicenseCounter) {
            pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
            pluginAnalyticsData.put("pluginVersion", pluginAccessor.getPlugin("com.wittified.atl-announcer-confluence").getPluginInformation().getVersion());
        }
        if (licenseCounter instanceof BitBucketLicenseCounter) {
            pluginAccessor = (PluginAccessor)ComponentLocator.getComponent(PluginAccessor.class, (String)"pluginAccessor");
            pluginAnalyticsData.put("pluginVersion", pluginAccessor.getPlugin("com.wittified.atl-announcer-stash").getPluginInformation().getVersion());
        }
        pluginAnalyticsData.put("pluginKey", Util.getPluginKey(licenseManager));
        pluginAnalyticsData.put("pluginLicense", Util.getPluginLicense(licenseManager));
        try {
            Option licenseOption = licenseManager.getLicense();
            String LicenseSEN = (String)((PluginLicense)licenseOption.get()).getSupportEntitlementNumber().get();
            if (licenseOption.isDefined()) {
                pluginAnalyticsData.put("pluginLicenseSEN", LicenseSEN);
            } else {
                pluginAnalyticsData.put("pluginLicenseSEN", "NONE");
            }
        }
        catch (Exception e) {
            log.debug("Unable to fetch SupportEntitlementNumber for License when posting PluginInfo event, Setting it to None.");
            pluginAnalyticsData.put("pluginLicenseSEN", "NONE");
        }
        return pluginAnalyticsData;
    }

    public static Map<String, Object> getHostInfo(LicenseCounter licenseCounter, HostLicenseInformation hostLicenseInformation) {
        LicenseService licenseService;
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (licenseCounter instanceof JiraLicenseCounter) {
            JiraLicenseService jiraLicenseService = (JiraLicenseService)ComponentAccessor.getComponent(JiraLicenseService.class);
            ArrayList jirLicenseDetails = Lists.newArrayList(jiraLicenseService.getLicenses());
            try {
                LicenseDetails coreLicenceDetail = jirLicenseDetails.stream().filter(item -> JIRA_CORE_NAME.equalsIgnoreCase(item.getApplicationDescription())).findAny().orElse(null);
                LicenseDetails softwareLicenceDetail = jirLicenseDetails.stream().filter(item -> JIRA_SOFTWARE_NAME.equalsIgnoreCase(item.getApplicationDescription())).findAny().orElse(null);
                Util.populateBaseLicenseDetails(data, hostLicenseInformation, jiraLicenseService.getServerId());
                Util.populateJiraLicenseDetails(data, coreLicenceDetail);
                if (softwareLicenceDetail != null) {
                    HashMap<String, Object> jiraSoftwareData = new HashMap<String, Object>();
                    Util.populateJiraLicenseDetails(jiraSoftwareData, softwareLicenceDetail);
                    data.put(JIRA_SOFTWARE_KEY_NAME, jiraSoftwareData);
                }
            }
            catch (Exception e) {
                data = null;
            }
        }
        if (licenseCounter instanceof ConfluenceLicenseCounter) {
            licenseService = (LicenseService)ContainerManager.getComponent((String)"licenseService");
            ConfluenceLicense confluenceLicense = licenseService.retrieve();
            data.put("hostLicenseType", confluenceLicense.getLicenseType().name());
            data.put("hostVersion".toString(), confluenceLicense.getLicenseVersion());
            data.put("hostLicenseLevel", confluenceLicense.getMaximumNumberOfUsers());
        }
        if (licenseCounter instanceof BitBucketLicenseCounter) {
            licenseService = (com.atlassian.bitbucket.license.LicenseService)ComponentLocator.getComponent(com.atlassian.bitbucket.license.LicenseService.class, (String)"licenseService");
            BitbucketServerLicense license = licenseService.get();
            data.put("hostServerId", license.getServerId());
            data.put("hostLicenseType", license.getLicenseType().name());
            data.put("hostLicenseLevel", license.getMaximumNumberOfUsers());
        }
        return data;
    }

    private static void populateDataMap(Map<String, Object> data, LicenseDetails licenseDetail, HostLicenseInformation hostLicenseInformation, int totalUserLimit) {
        data.put("hostLicenseType", licenseDetail == null ? "n/a" : licenseDetail.getLicenseType().name());
        data.put("hostVersion".toString(), ComponentAccessor.getApplicationProperties().getString("jira.version"));
        data.put("hostLicenseLevel", Integer.toString(totalUserLimit));
        if (hostLicenseInformation != null) {
            data.put("hostEdition", hostLicenseInformation.getEdition().get());
            data.put("hostIsDataCenter", hostLicenseInformation.isDataCenter());
            data.put("hostIsEvaluation", hostLicenseInformation.isEvaluation());
        }
    }

    private static String getPluginVersion(PluginLicenseManager licenseManager, PluginAccessor pluginAccessor) {
        return pluginAccessor.getPlugin(licenseManager.getPluginKey()).getPluginInformation().getVersion();
    }

    private static String getPluginKey(PluginLicenseManager licenseManager) {
        return licenseManager.getPluginKey();
    }

    private static String getPluginLicense(PluginLicenseManager licenseManager) {
        boolean licenseOk;
        boolean bl = licenseOk = licenseManager.getLicense() != null && licenseManager.getLicense().isDefined();
        if (licenseOk) {
            PluginLicense pluginLicense = (PluginLicense)licenseManager.getLicense().get();
            licenseOk = pluginLicense.isValid();
            if (!licenseOk) {
                return ((LicenseError)pluginLicense.getError().get()).name();
            }
            return pluginLicense.getLicenseType().name();
        }
        return "UNLICENSED";
    }

    private static void populateBaseLicenseDetails(Map<String, Object> data, HostLicenseInformation hostLicenseInformation, String serverId) {
        data.put("hostServerId", serverId == null ? "NONE" : serverId);
        data.put("hostVersion".toString(), ComponentAccessor.getApplicationProperties().getString("jira.version"));
        if (hostLicenseInformation != null) {
            data.put("hostIsDataCenter", hostLicenseInformation.isDataCenter());
            data.put("hostIsEvaluation", hostLicenseInformation.isEvaluation());
            if (hostLicenseInformation.getEdition() != null && hostLicenseInformation.getEdition().isDefined()) {
                data.put("hostEdition", hostLicenseInformation.getEdition().get());
            }
        }
    }

    private static void populateJiraLicenseDetails(Map<String, Object> data, LicenseDetails licenceDetails) {
        int totalUserLimit = 0;
        if (licenceDetails != null) {
            data.put("hostLicenseType", licenceDetails.getLicenseType() == null ? "NONE" : licenceDetails.getLicenseType().name());
            data.put("hostSEN", licenceDetails.getSupportEntitlementNumber() == null ? "NONE" : licenceDetails.getSupportEntitlementNumber());
            data.put("hostMaxUsers", licenceDetails.getJiraLicense() == null ? "NONE" : Integer.valueOf(licenceDetails.getJiraLicense().getMaximumNumberOfUsers()));
            totalUserLimit = Util.getUserLimit(licenceDetails);
            data.put("hostLicenseLevel", Integer.toString(totalUserLimit));
        }
    }

    private static int getUserLimit(LicenseDetails licenceDetail) {
        int totalUserLimit = 0;
        if (licenceDetail != null) {
            LicensedApplications applications = licenceDetail.getLicensedApplications();
            Set keys = applications.getKeys();
            for (ApplicationKey key : keys) {
                totalUserLimit = applications.getUserLimit(key);
            }
        }
        return totalUserLimit;
    }
}

