/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.plugins.rest.common.security.LicensedOnly;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.wittified.ao.NotificationService;
import com.wittified.ao.NotificationToNotificationUser;
import com.wittified.ao.NotificationUser;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
public class UpdateNotifUserKey
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(UpdateNotifUserKey.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final NotificationService notificationService;
    private final ActiveObjects activeObjects;
    private final WebSudoManager webSudoManager;

    public UpdateNotifUserKey(TemplateRenderer templateRenderer, UserManager userManager, NotificationService notificationService, ActiveObjects activeObjects, WebSudoManager webSudoManager) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.activeObjects = activeObjects;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(req, res);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.userManager.isAdmin(user.getUserKey())) {
            context.put("message", "You are currently not logged in. Please log in order to confirm this announcement");
            this.render("/templates/security-breach.vm", context, res);
            return;
        }
        List<NotificationUser> notificationUsers = this.notificationService.getAllNotificationUsersWithKeyNull();
        List users = notificationUsers.stream().map(notifUser -> notifUser.getUser()).collect(Collectors.toList());
        context.put("notificationUsers", users);
        res.setContentType("text/html");
        this.render("/templates/update-notif-userkey.vm", context, res);
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }

    @Transactional
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || user != null && !this.userManager.isAdmin(user.getUserKey())) {
            context.put("message", "You are currently not logged in. Please log in order to confirm this announcement");
            this.render("/templates/security-breach.vm", context, res);
            return;
        }
        LogManager.getLogger((String)"com.wittified").setLevel(Level.INFO);
        List<NotificationUser> notificationUsers = this.notificationService.getAllNotificationUsersWithKeyNull();
        int totalSize = notificationUsers.size();
        int count = 0;
        for (NotificationUser notificationUser : notificationUsers) {
            UserProfile userProfile = this.userManager.getUserProfile(notificationUser.getUser());
            if (userProfile != null) {
                notificationUser.setUserKey(userProfile.getUserKey().getStringValue());
                notificationUser.save();
                logger.info("Updating notification user : " + ++count + "of " + totalSize);
                continue;
            }
            logger.info("User does not exist in the system with username : " + notificationUser.getUser());
            for (NotificationToNotificationUser notificationToNotificationUser : (NotificationToNotificationUser[])this.activeObjects.find(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_USER_ID = ? ", new Object[]{notificationUser.getID()}))) {
                this.activeObjects.delete(new RawEntity[]{notificationToNotificationUser});
            }
            this.activeObjects.delete(new RawEntity[]{notificationUser});
        }
        LogManager.getLogger((String)"com.wittified").setLevel(null);
        this.doGet(req, res);
    }
}

