/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieVerificationServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private static final Logger logger = LoggerFactory.getLogger(CookieVerificationServlet.class);

    public CookieVerificationServlet(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String token = this.getCookieValue("wit-announce-token", req);
        if (token == null || token.isEmpty()) {
            logger.warn("User did not accept the token cookie");
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("context", req.getContextPath());
            this.render("/templates/cookie-warning.vm", context, resp);
        } else {
            String location = req.getParameter("redirectURL");
            if (location == null || location.isEmpty()) {
                location = "";
            }
            logger.debug("Redirecting to " + location);
            resp.sendRedirect(!location.contains("//") ? location : "/");
        }
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }

    private String getCookieValue(String name, HttpServletRequest request) {
        if (request.getCookies() == null) {
            return "";
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return "";
    }
}

